' Copyright (C) 2004 - 2007 db4objects Inc. http:'www.db4o.com 
Imports System
Imports System.IO

Imports Db4objects.Db4o
Imports Db4objects.Db4o.Ext
Imports Db4objects.Db4o.Query
Imports Db4objects.Db4o.Config

' Proxy object. Transfers TestValue object over the network
' and stores it to db4o.
Namespace RemotingClasses

    Public Class TestValueServer
        Inherits MarshalByRefObject

        Private _testValue As TestValue

        Private Const Db4oFileName As String = "reference.db4o"

        Public Property TestValue() As TestValue
            Get
                Return _testValue
            End Get
            Set(ByVal value As TestValue)
                _testValue = value
            End Set
        End Property
        ' end TestValue

        Public Sub StoreData()
            ' Store TestValue object to db4o
            File.Delete(Db4oFileName)
            Dim db As IObjectContainer = Database()
            Try
                db.Set(TestValue)
                db.Commit()
            Catch ex As Exception
                System.Console.WriteLine(ex.Message)
            Finally
                db.Close()
            End Try
        End Sub
        ' end StoreData

        Public Function RetrieveData() As String
            ' Retrieve TestValue object and return its String representation
            Dim db As IObjectContainer = Database()
            Try
                Dim result As IObjectSet = db.Query(GetType(TestValue))
                System.Console.WriteLine(result.Count)
                If (result.Count > 0) Then
                    Return CType(result.Next(), TestValue).GetData()
                End If
            Catch ex As Exception
                System.Console.WriteLine(ex.Message)
            Finally
                db.Close()
            End Try
            Return "No results"
        End Function
        ' end RetrieveData

        Private Shared Function Database() As IObjectContainer
            Dim container As IObjectContainer = Nothing
            Try
                container = Db4oFactory.OpenFile(Db4oFileName)
            Catch ex As DatabaseFileLockedException
                System.Console.WriteLine(ex.Message)
            End Try
            Return container
        End Function
        ' end Database
    End Class
End Namespace


