' Copyright (C) 2004 - 2007 db4objects Inc. http:'www.db4o.com 
Imports System
Imports System.IO

Imports System.Runtime.Remoting
Imports System.Runtime.Remoting.Channels
Imports System.Runtime.Remoting.Channels.Http
Imports System.Runtime.Remoting.Channels.Tcp

Imports Interfaces

Namespace RemotingExample

    Class Program

        Private Const Db4oFileName As String = "reference.db4o"

        ' Reference to remote ITest implementation.
        Dim testRemoteReference As Interfaces.Interfaces.ITest

        Public Sub New()

            Dim url As String
            ' delete db4o file to run an example on a single object
            File.Delete(Db4oFileName)

            ' Setup a client channel to our services.
            Dim channel As HttpChannel = New HttpChannel(0)
            url = "http://LocalHost:65101/"

            ' Register the channel
            ChannelServices.RegisterChannel(channel, False)

            ' Setup remote access to ITest implementation
            Dim obj As MarshalByRefObject = CType(RemotingServices.Connect(GetType(Interfaces.Interfaces.ITest), url + "TestEndPoint"), MarshalByRefObject)

            ' Set a test object
            testRemoteReference = CType(obj, Interfaces.Interfaces.ITest)
        End Sub
        ' end New

        Private Sub RunTest()
            ' Change data in the remote object
            testRemoteReference.ChangeData("test String")
            System.Console.WriteLine(testRemoteReference.GetData())
            ' Store the object remotely to the database
            testRemoteReference.StoreData()
            ' Retrieve the object data from the remote database
            System.Console.WriteLine(testRemoteReference.RetrieveData())
        End Sub
        ' end RunTest

        Shared Sub Main(ByVal args As String())
            Dim p As Program = New Program()
            p.RunTest()
        End Sub
        ' end Main
    End Class
End Namespace
