<?php
/*
 * $Id: class.htmlTicketresolutions.inc.php,v 1.2.2.2.2.3 2003/11/11 05:50:04 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('tck');

class htmlTicketresolutions
{
	var $public;

	function htmlTicketresolutions()
	{
		$this->public = array('modify', 'delete', 'submitModify', 'submitDelete');
	}

	function GetActionLinks($include, $enclose, $id, $dark)
	{
		global $dcl_info;

		$link = '';
		if ($GLOBALS['SEC'] >= $dcl_info['DCL_MOD_WO'] && ereg('m', $include))
			$link .= GetLink(STR_CMMN_EDIT, '', menuLink('', "menuAction=htmlTicketresolutions.modify&id=$id"), true);

		if ($GLOBALS['SEC'] >= $dcl_info['DCL_DEL_WO'] && ereg('x', $include))
		{
			if ($link != '')
				$link .= '|&nbsp;';

			$link .= GetLink(STR_CMMN_DELETE, '', menuLink('', "menuAction=htmlTicketresolutions.delete&id=$id"), true);
		}

		return $link;
	}

	function modify()
	{
		commonHeader();
	}

	function submitModify()
	{
		commonHeader();

		$oBO = CreateObject('dcl.boTicketresolutions');
		CleanVars($GLOBALS['HTTP_POST_VARS']);
		$oBO->modify($GLOBALS['HTTP_POST_VARS']);
		
		$obj = CreateObject('dcl.dbTickets');
		$obj->Load($oBO->oDB->ticketid);
		
		$objH = CreateObject('dcl.htmlTicketDetail');
		$objH->Show($obj);
	}

	function delete()
	{
		commonHeader();
	}

	function submitDelete()
	{
		commonHeader();

		$objH = CreateObject('dcl.htmlTicketDetail');
		$objH->Show($obj);
	}

	function DisplayForm($ticketid, $obj = '')
	{
		global $dcl_info;

		$isEdit = is_object($obj);

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_HAVE_WO']))
			return PrintPermissionDenied();

		$objT = CreateObject('dcl.dbTickets');
		$objProduct = CreateObject('dcl.dbProducts');
		$objStat = CreateObject('dcl.htmlStatuses');

		$objT->Connect();
		$objProduct->Connect();

		$objT->Load($ticketid);
		$objProduct->Query('SELECT tcksetid FROM products WHERE id=' . $objT->product);
		$objProduct->next_record();
		$setid = $objProduct->f(0);

		$Template = CreateTemplate(array('hForm' => 'htmlTicketresolutionsForm.tpl'));
		$Template->set_block('hForm', 'escalate', 'hEscalate');
		$Template->set_var('hEscalate', '');
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('TXT_STATUS', STR_TCK_STATUS);
		$Template->set_var('TXT_RESOLUTION', STR_TCK_RESOLUTION);
		$Template->set_var('BTN_SAVE', STR_CMMN_SAVE);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);
		$Template->set_var('TXT_HIGHLIGHTEDNOTE', STR_CMMN_HIGHLIGHTEDNOTE);
		$Template->set_var('VAL_FORMACTION', menuLink());

		if ($isEdit)
		{
			$Template->set_var('TXT_TITLE', sprintf(STR_TCK_EDITRESOLUTION, $obj->ticketid));
			$Template->set_var('CMB_STATUS', $objStat->GetCombo($obj->status, 'status', 'name', 0, false, $setid));
			$Template->set_var('VAL_RESOLUTION', htmlspecialchars($obj->resolution));
			$hiddenVars = '<input type="hidden" name="menuAction" value="htmlTicketresolutions.submitModify">';
			$hiddenVars .= sprintf('<input type="hidden" name="startedon" value="%s">', $obj->startedon);
		}
		else
		{
			$Template->set_var('TXT_TITLE', sprintf(STR_TCK_ADDRESOLUTION, $ticketid));

			$Template->set_var('CMB_STATUS', $objStat->GetCombo($objT->status, 'status', 'name', 0, false, $setid));
			$Template->set_var('VAL_RESOLUTION', '');

			$hiddenVars = '<input type="hidden" name="menuAction" value="boTicketresolutions.dbadd">';
			$hiddenVars .= sprintf('<input type="hidden" name="startedon" value="%s">', date($dcl_info['DCL_TIMESTAMP_FORMAT']));

			// Allow agents to escalate to ticket leads
			if ($GLOBALS['SEC'] < $dcl_info['DCL_ASSIGN_WO'])
			{
				$Template->set_var('TXT_ESCALATE', STR_TCK_ESCALATE);
				$Template->parse('hEscalate', 'escalate');
			}

		}

		$hiddenVars .= sprintf('<input type="hidden" name="ticketid" value="%d">', $ticketid);
		$Template->set_var('HIDDEN_VARS', $hiddenVars);

		$Template->pparse('out', 'hForm');
	}

	function GetResolutions($ticketid, $editResID = 0, $forDelete = false)
	{
		global $dcl_info;

		$retVal = '';

		$obj = CreateObject('dcl.dbTicketresolutions');
		$obj->Connect();
		if ($obj->GetResolutions($ticketid) != -1)
		{
			if ($obj->next_record())
			{
				$objPersonnel = CreateObject('dcl.dbPersonnel');
				$objPersonnel->Connect();
				$objStatus = CreateObject('dcl.dbStatuses');
				$objStatus->Connect($objPersonnel->conn);

				$Template = CreateTemplate(array('hForm' => 'htmlTicketresolutions.tpl'));
				$Template->set_block('hForm', 'nodelete', 'hNodelete');
				$Template->set_block('hForm', 'delete', 'hDelete');

				$Template->set_var('hNodelete', '');
				$Template->set_var('hDelete', '');
				$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
				$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
				$Template->set_var('TXT_STATUS', STR_TCK_STATUS);
				$Template->set_var('TXT_BY', STR_CMMN_BY);
				$Template->set_var('TXT_ON', STR_CMMN_ON);
				$Template->set_var('TXT_TIME', STR_TCK_APPROXTIME);
				$Template->set_var('TXT_RESOLUTION', STR_TCK_RESOLUTION);

				do
				{
					$obj->GetRow();

					$objPersonnel->Load($obj->loggedby);
					$objStatus->Load($obj->status);

					if (!$forDelete || $editID == 0)
					{
						$Template->set_var('LNK_OPTIONS', $this->GetActionLinks('mx', true, $obj->resid, false));
						$Template->parse('hNodelete', 'nodelete');
					}
					else
						$Template->parse('hDelete', 'delete');

					$Template->set_var('VAL_RESOLUTIONID', $obj->resid);
					$Template->set_var('VAL_STATUS', $objStatus->name);
					$Template->set_var('VAL_LOGGEDBY', $objPersonnel->short);
					$Template->set_var('VAL_LOGGEDON', $obj->loggedon);
					$Template->set_var('VAL_HOURSTEXT', $obj->GetHoursText());
					$Template->set_var('VAL_RESOLUTION', CreateLinkedText(nl2br(htmlspecialchars($obj->resolution))));
					$retVal .= $Template->parse('out', 'hForm');
				}
				while ($obj->next_record());
			}
		}

		return $retVal;
	}
}
?>
