/*!

\if MANPAGES
\page dsrdump Dump DICOM SR file and data set
\else
\page dsrdump dsrdump: Dump DICOM SR file and data set
\endif

\section synopsis SYNOPSIS

\verbatim
dsrdump [options] dsrfile-in...
\endverbatim

\section description DESCRIPTION

The \b dsrdump utility dumps the contents of a DICOM Structured Reporting (SR)
document (file format or raw data set) to stdout in textual form.  The output
of the document content follows the format proposed in David Clunie's book
"DICOM Structured Reporting" (PixelMed Publishing, 2000).

If \b dsrdump reads a raw data set (DICOM data without a file format
meta-header) it will attempt to guess the transfer syntax by examining the
first few bytes of the file.  It is not always possible to correctly guess the
transfer syntax and it is better to convert a data set to a file format
whenever possible (using the \b dcmconv utility).  It is also possible to use
the \e -f and <em>-t[ieb]</em> options to force \b dsrdump to read a dataset
with a particular transfer syntax.

\section parameters PARAMETERS

\verbatim
dsrfile-in  DICOM SR input filename to be dumped
\endverbatim

\section options OPTIONS

\subsection general_options general options
\verbatim
  -h   --help
         print this help text and exit

       --version
         print version information and exit

  -d   --debug
         debug mode, print debug information

  -dd  --verbose-debug
         verbose debug mode, print more details
\endverbatim

\subsection input_options input options
\verbatim
input file format:

  +f   --read-file
         read file format or data set (default)

  +fo  --read-file-only
         read file format only

  -f   --read-dataset
         read data set without file meta information

input transfer syntax:

  -t=  --read-xfer-auto
         use TS recognition (default)

  -td  --read-xfer-detect
         ignore TS specified in the file meta header

  -te  --read-xfer-little
         read with explicit VR little endian TS

  -tb  --read-xfer-big
         read with explicit VR big endian TS

  -ti  --read-xfer-implicit
         read with implicit VR little endian TS
\endverbatim

\subsection parsing_options parsing options
\verbatim
additional information:

  -Ip  --processing-details
         show currently processed content item

error handling:

  -Ec  --ignore-constraints
         ignore relationship content constraints

  -Ee  --ignore-item-errors
         do not abort on content item errors, just warn
         (e.g. missing value type specific attributes)

  -Ei  --skip-invalid-items
         skip invalid content items (incl. sub-tree)
\endverbatim

\subsection output_options output options
\verbatim
printing:

  +Pf  --print-filename
         print header with filename for each document

  -Ph  --no-document-header
         do not print general document information

  +Pn  --number-nested-items
         print position string in front of each line

  -Pn  --indent-nested-items
         indent nested items by spaces (default)

  +Pl  --print-long-values
         print long item values completely

  -Pl  --shorten-long-values
         print long item values shortened (default)

  +Pu  --print-instance-uid
         print SOP instance UID of referenced objects

  +Pc  --print-all-codes
         print all codes (incl. concept name codes)

  +Pt  --print-template-id
         print template identification information
\endverbatim

\section notes NOTES

\subsection dicom_conformance DICOM Conformance

The \b dsrdump utility supports the following SOP Classes (according to
DICOM 2004 and Supplement 94):

\verbatim
BasicTextSR                 1.2.840.10008.5.1.4.1.1.88.11
EnhancedSR                  1.2.840.10008.5.1.4.1.1.88.22
ComprehensiveSR             1.2.840.10008.5.1.4.1.1.88.33
ProcedureLog                1.2.840.10008.5.1.4.1.1.88.40
MammographyCADSR            1.2.840.10008.5.1.4.1.1.88.50
KeyObjectSelectionDocument  1.2.840.10008.5.1.4.1.1.88.59
ChestCADSR                  1.2.840.10008.5.1.4.1.1.88.65
XRayRadiationDoseSR         1.2.840.10008.5.1.4.1.1.88.67
\endverbatim

\section command_line COMMAND LINE

All command line tools use the following notation for parameters: square
brackets enclose optional values (0-1), three trailing dots indicate that
multiple values are allowed (1-n), a combination of both means 0 to n values.

Command line options are distinguished from parameters by a leading '+' or '-'
sign, respectively.  Usually, order and position of command line options are
arbitrary (i.e. they can appear anywhere).  However, if options are mutually
exclusive the rightmost appearance is used.  This behaviour conforms to the
standard evaluation rules of common Unix shells.

In addition, one or more command files can be specified using an '@' sign as a
prefix to the filename (e.g. <em>\@command.txt</em>).  Such a command argument
is replaced by the content of the corresponding text file (multiple
whitespaces are treated as a single separator) prior to any further
evaluation.  Please note that a command file cannot contain another command
file.  This simple but effective approach allows to summarize common
combinations of options/parameters and avoids longish and confusing command
lines (an example is provided in file <em>share/data/dumppat.txt</em>).

\section environment ENVIRONMENT

The \b dsrdump utility will attempt to load DICOM data dictionaries specified
in the \e DCMDICTPATH environment variable.  By default, i.e. if the
\e DCMDICTPATH environment variable is not set, the file
<em>\<PREFIX\>/lib/dicom.dic</em> will be loaded unless the dictionary is built
into the application (default for Windows).

The default behaviour should be preferred and the \e DCMDICTPATH environment
variable only used when alternative data dictionaries are required.  The
\e DCMDICTPATH environment variable has the same format as the Unix shell
\e PATH variable in that a colon (":") separates entries.  The data dictionary
code will attempt to load each file specified in the \e DCMDICTPATH
environment variable.  It is an error if no data dictionary can be loaded.

\section see_also SEE ALSO

<b>dcmconv</b>(1)

\section copyright COPYRIGHT

Copyright (C) 2000-2005 by Kuratorium OFFIS e.V., Escherweg 2, 26121 Oldenburg,
Germany.

*/
