#ifndef __MD_H__
#define __MD_H__

/* Important: BLOCKSIZE must be a multiple of 64.  */
#define BLOCKSIZE 4096

/* length of the computed md5sum in byte */
#define MD5SUMLEN 16

/*************************************/
/* Process LEN bytes of BUFFER.      */
/* It is assumed that LEN % 64 == 0. */
/*************************************/
void md5_process_block (const void *buffer, unsigned char md5sum[MD5SUMLEN]);

/**********************************************/
/* verify if the 2 given md5sum are identical */
/* output: 0=no, !=0=yes                      */
/**********************************************/
#define md5sum_match(md1,md2)		(memcmp(md1,md2,MD5SUMLEN)==0)

/****************************************************/
/* convert the given md5sum into a printable string */
/****************************************************/
void md5tostr(const unsigned char md5sum[MD5SUMLEN],char str[3*MD5SUMLEN+1]);

/****************************************/
/* convert the given string into md5sum */
/****************************************/
/* output: 1= ok, 0=invalid string */
/***********************************/
int strtomd5(const char str[3*MD5SUMLEN+1],unsigned char md5sum[MD5SUMLEN]);

/****************************************/
/* compute the MD5SUM of the given file */
/****************************************/
/* output: 0=ok, !=0=error */
/***************************/
int md5sum_of_file(const char *filename, unsigned char md5sum[MD5SUMLEN]);

#endif
