/*******************************************************************
 *            main.c
 *
 *  Sat Jul 29 14:14:52 2006
 *  Copyright  2006  Neil Williams
 *  linux@codehelp.co.uk
 *******************************************************************/
/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <glib/gstdio.h>
#include <archive.h>
#include "dvarchive.h"
#include "dvpreview.h"
#include "interface.h"
#include "support.h"
#include "callbacks.h"

/** list of other windows derived from this instance. */
static GList * subwindows = NULL;

void
dv_add_child (GtkWindow * child)
{
	subwindows = g_list_append (subwindows, child);
}

guint
dv_count_kids (void)
{
	return g_list_length (subwindows);
}

void
dv_remove_child (GtkWindow * child)
{
	subwindows = g_list_remove (subwindows, child);
}

int
main (int argc, char *argv[])
{
	DVContents * context;
	gchar **remaining_args;
	GOptionContext *option_context;
	GnomeProgram *dv;
	struct stat statinfo;
	gint stat_val;
	GOptionEntry option_entries[] = {
		/* option that collects filenames */
		{G_OPTION_REMAINING, 0, 0, G_OPTION_ARG_FILENAME_ARRAY,
			&remaining_args, NULL, _("file")},
		{NULL, 0, 0, G_OPTION_ARG_NONE, NULL, NULL, NULL}
	};

#ifdef ENABLE_NLS
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
#endif
	g_assert (archive_api_version () == ARCHIVE_API_VERSION);
	remaining_args = NULL;
	option_context = g_option_context_new ("");
	g_option_context_add_main_entries (option_context,
		option_entries, GETTEXT_PACKAGE);
	dv = gnome_program_init (PACKAGE, VERSION, LIBGNOMEUI_MODULE,
		argc, argv,
		GNOME_PARAM_HUMAN_READABLE_NAME, _(GETTEXT_PACKAGE),
		GNOME_PARAM_APP_DATADIR, PACKAGE_DATA_DIR,
		GNOME_PARAM_GOPTION_CONTEXT, option_context, 
		GNOME_PARAM_NONE);
	add_pixmap_directory (PACKAGE_PIXMAP_DIR);
	subwindows = NULL;
	if (!preview_init ())
		g_warning (_("Unable to create preview key file"));
	/* parse remaining command-line arguments that are not
	   options (i.e. filenames)*/
	if (remaining_args != NULL)
	{
		gint i, num_args;

		num_args = g_strv_length (remaining_args);
		for (i = 0; i < num_args; ++i)
		{
			/* one window for each .deb file specified */
			GtkWindow *window1;

			context = dv_create();
			window1 = GTK_WINDOW(create_deb_gview_window ());
			g_return_val_if_fail (window1, EXIT_FAILURE);
			g_object_set_data (G_OBJECT(window1), 
				DVCONTENTS, context);
			set_dv_parent (GTK_WIDGET(window1));
	        stat_val = g_stat (remaining_args[i],  &statinfo);
       		if (S_ISREG (statinfo.st_mode) || statinfo.st_size > 0)
				set_deb_file (g_strdup (remaining_args[i]), context);
			gtk_widget_show (GTK_WIDGET(window1));
			subwindows = g_list_append (subwindows, window1);
		}
		g_strfreev (remaining_args);
		remaining_args = NULL;
	}
	else
	{
		GtkWindow *window1;

		context = dv_create();
		window1 = GTK_WINDOW(create_deb_gview_window ());
		g_return_val_if_fail (window1, EXIT_FAILURE);
		g_object_set_data (G_OBJECT(window1), DVCONTENTS, context);
		set_dv_parent (GTK_WIDGET(window1));
		gtk_widget_show GTK_WIDGET((window1));
		subwindows = g_list_append (subwindows, window1);
	}
	gtk_main ();
	return EXIT_SUCCESS;
}
