
/* strx.c */

#include "strx.h"
#include "gen.h"

/* Copy into `d' a string from `s' up to just before `x'.  Terminate
 * with a null.  */
char *strxcpy( char *d, const char *s, const char *const x ) {
  char *const ret = d;
  while ( s < x && *s ) *d++ = *s++;
  *d = '\0';
  return ret;
}

/* Compare string `d' against string `s' as though 's' ended at 'x'.  */
int strxcmp( const char *d, const char *s, const char *const x ) {
  for ( ; s < x; ++d, ++s ) {
    if (  *d !=  *s ) return *d < *s ? -1 : 1;
    if ( !*d && !*s ) return                0;
  }
  return                     *d      ?  1 : 0;
}

