/* chordops.h
 *
 * the header files for chordops.c, functions which manipulate chords
 * For denemo, a gtk+ frontend to Lilypond, the GNU music typesetter
 *
 * (c) 2000, 2001 Matthew Hiller <matthew.hiller@yale.edu>
 *
 */

#include <glib.h>
#include "datastructures.h"

void newclefify (mudelaobject * thechord, gint dclef);

void findreversealigns (mudelaobject * thechord);

mudelaobject *newchord (gint baseduration, gint numdots);

void addtone (mudelaobject * mudelaobj, gint mid_c_offset, gint enshift,
	      gint dclef);

void removetone (mudelaobject * mudelaobj, gint mid_c_offset, gint dclef);

void shiftpitch (mudelaobject * mudelaobj, gint mid_c_offset,
		 gint is_sharpening);

void changedur (mudelaobject * thechord, gint baseduration, gint numdots);

void changenumdots (mudelaobject * thechord, int number);

void freechord (mudelaobject * mudelaobj);

mudelaobject *clone_chord (mudelaobject * mudelaobj);
