/* clefdialog.c
 * callback that creates "change staff" dialog box
 * user for further action

 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 1999 Matthew Hiller */

#include <gtk/gtk.h>
#include <string.h>
#include "calculatepositions.h"
#include "chordops.h"
#include "commandfuncs.h"
#include "contexts.h"
#include "draw.h"
#include "datastructures.h"
#include "dialogs.h"
#include "measureops.h"
#include "objops.h"
#include "staffops.h"
#include "utils.h"

struct callbackdata
{
  struct scoreinfo *si;
  GtkWidget *combobox;
};

/* FIXME: Duplicate code with lyparserfuncs.c here... */

gint clefnumfromname (gchar * thetext)
{
  if (g_strcasecmp (thetext, _("Treble")) == 0)
    return TREBLE;
  else if (g_strcasecmp (thetext, _("Bass")) == 0)
    return BASS;
  else if (g_strcasecmp (thetext, _("Alto")) == 0)
    return ALTO;
  else if (g_strcasecmp (thetext, _("G_8")) == 0)
    return G_8;
  else if (g_strcasecmp (thetext, _("Tenor")) == 0)
    return TENOR;
  else if (g_strcasecmp (thetext, _("Soprano")) == 0)
    return SOPRANO;
  else				/* Default */
    return TREBLE;
}

static void
set_clef (GtkWidget * widget, gpointer data)
{
  struct callbackdata *cbdata = data;
  struct scoreinfo *si = cbdata->si;
  staff *curstaffstruct = si->currentstaff->data;
  gchar *thetext =
    gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (cbdata->combobox)->entry));

  curstaffstruct->sclef = clefnumfromname (thetext);
  find_leftmost_staffcontext (curstaffstruct, si);
  fixnoteheights (curstaffstruct);
  find_xes_in_all_measures (si);
  si->haschanged = TRUE;
  gtk_widget_draw (si->scorearea, NULL);
}

static void
insert_clef (GtkWidget * widget, gpointer data)
{
  struct callbackdata *cbdata = data;
  struct scoreinfo *si = cbdata->si;
  gchar *thetext =
    gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (cbdata->combobox)->entry));
  mudelaobject *curmudelaobj = si->currentobject ? si->currentobject->data
    : NULL;

  /* Identical code to insert chord in commandfuncs.c - should probably
   * be split off into a separate function */
  if (curmudelaobj && curmudelaobj->type == TIMESIG && !si->cursor_appending)
    {
      si->cursor_x++;
      if (si->currentobject->next)
	si->currentobject = si->currentobject->next;
      else
	si->cursor_appending = TRUE;
    }

  si->currentmeasure->data =
    g_list_insert (si->currentmeasure->data,
		   newclefobj (clefnumfromname (thetext)), si->cursor_x);
  si->cursor_x++;
  if (si->cursor_appending)
    si->currentobject = g_list_last (si->currentmeasure->data);
  else
    si->currentobject = g_list_nth (si->currentmeasure->data, si->cursor_x);
  fixnoteheights (si->currentstaff->data);
  beamsandstemdirswholestaff (si->currentstaff->data);
  find_xes_in_all_measures (si);
  nudgerightward (si);
  si->haschanged = TRUE;
  gtk_widget_draw (si->scorearea, NULL);
}

void
clef_change (gpointer callback_data, guint callback_action,
	     GtkWidget * widget)
{
  GtkWidget *dialog;
  GtkWidget *label;
  GList *glist = NULL;
  GtkWidget *combobox;
  GtkWidget *okbutton;
  GtkWidget *cancelbutton;
  static struct callbackdata cbdata;
  struct scoreinfo *si = callback_data;
  staff *curstaffstruct = si->currentstaff->data;

  dialog = gtk_dialog_new ();

  if (callback_action == CHANGEINITIAL)
    gtk_window_set_title (GTK_WINDOW (dialog), _("Change initial clef"));
  else
    gtk_window_set_title (GTK_WINDOW (dialog), _("Insert clef change"));

  label = gtk_label_new (_("Select desired clef"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
		      label, TRUE, TRUE, 0);
  gtk_widget_show (label);

  glist = g_list_append (glist, _("Treble"));
  glist = g_list_append (glist, _("Bass"));
  glist = g_list_append (glist, _("Alto"));
  glist = g_list_append (glist, _("G_8"));
  glist = g_list_append (glist, _("Tenor"));
  glist = g_list_append (glist, _("Soprano"));

  combobox = gtk_combo_new ();
  gtk_combo_set_popdown_strings (GTK_COMBO (combobox), glist);
  switch (curstaffstruct->sclef)
    {
    case TREBLE:
      gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combobox)->entry),
			  _("Treble"));
      break;
    case BASS:
      gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combobox)->entry), _("Bass"));
      break;
    case ALTO:
      gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combobox)->entry), _("Alto"));
      break;
    case G_8:
      gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combobox)->entry), "G_8");
      break;
    case TENOR:
      gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combobox)->entry),
			  _("Tenor"));
      break;
    case SOPRANO:
      gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combobox)->entry),
			  _("Soprano"));
      break;
    }

  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
		      combobox, TRUE, TRUE, 0);
  gtk_widget_show (combobox);

  okbutton = gtk_button_new_with_label (_("OK"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		      okbutton, TRUE, TRUE, 0);
  cbdata.si = si;
  cbdata.combobox = combobox;
  if (callback_action == CHANGEINITIAL)
    {
      processenter (GTK_COMBO (combobox)->entry, set_clef, cbdata, dialog);
      gtk_signal_connect (GTK_OBJECT (okbutton), _("clicked"),
			  GTK_SIGNAL_FUNC (set_clef), &cbdata);

    }
  else
    {
      processenter (GTK_COMBO (combobox)->entry, insert_clef, cbdata, dialog);
      gtk_signal_connect (GTK_OBJECT (okbutton), _("clicked"),
			  GTK_SIGNAL_FUNC (insert_clef), &cbdata);
    }
  gtk_signal_connect_object (GTK_OBJECT (okbutton), _("clicked"),
			     gtk_widget_destroy, GTK_OBJECT (dialog));
  gtk_widget_show (okbutton);

  cancelbutton = gtk_button_new_with_label (_("Cancel"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		      cancelbutton, TRUE, TRUE, 0);
  gtk_signal_connect_object (GTK_OBJECT (cancelbutton), _("clicked"),
			     gtk_widget_destroy, GTK_OBJECT (dialog));
  gtk_widget_show (cancelbutton);

  gtk_widget_grab_focus (combobox);
  gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
  gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_MOUSE);
  gtk_widget_show (dialog);
}
