/*
 * Detect a Library for hardware detection
 *
 * Copyright (C) 1998-2000 MandrakeSoft
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <fcntl.h>

#include "detect.h"
#include "utils.h"


extern struct pci_info *pci_detect(struct cards_lst *lst){
  FILE *f;
  struct cards_lst *bkup_lst;
  struct pci_info *result = (struct pci_info *)NULL;
  static struct pci_info *first = (struct pci_info *)NULL;
  int devbusfn, irq, class;
  unsigned long id;
  unsigned long vendor;
  int fd;
  int found = 0;
  char tmp[2];
  char *buff;
  char *line;
  size_t len = 0;


  if(first){
    return first;
  }/*endif*/

  if(debug){
    fprintf(stdout, "\nProbing PCI cards...\n");
  }/*endif*/
  /********************************************************************/
  /********************* PCI CARD DETECTION ***************************/
  /********************************************************************/
  if((f = fopen(PATH_PROC_PCI, "r"))){
    while(getline(&line, &len, f) >= 0){
      if(line[0] == '\n' || line[0] == '#'){
        continue;
      }/*endif*/
      sscanf(line, "%04x\t%08lx\t%x", &devbusfn, &id, &irq); 
      vendor = (id >> 16);
      if(!first){
        first = result = (struct pci_info *) 
                                     my_malloc(sizeof(struct pci_info));
      }else{
        result->next = (struct pci_info *) 
                                     my_malloc(sizeof(struct pci_info));
        result = result->next;
      }/*endif*/
      result->next = (struct pci_info *)NULL;
      result->options = 0;
      found = 0;
      
      buff = (char *)malloc(25);
      sprintf(buff, "/proc/bus/pci/%02x/%02x.%x", 
              devbusfn >> 8, 
              (devbusfn & 0xff) >> 3, 
              (devbusfn & 0xff) & 0x7);
      if((fd = open(buff, O_RDONLY)) != -1){
        lseek(fd, 10, SEEK_SET);
        read(fd, tmp, 2);
        class = (tmp[1] * 0x100) + tmp[0];
        close(fd);
      }else{
        class = 0x0000;
      }/*endif*/
      free(buff);
      
      result->vendor = s_unknown;
      result->type = pciclass2device(class);
      for(bkup_lst = lst; bkup_lst; bkup_lst = bkup_lst->next){
        if((vendor == (bkup_lst->long_id >> 16)) && 
                                                (bkup_lst->bus == PCI)){
          result->vendor = bkup_lst->vendor;
          if(id == bkup_lst->long_id){
            result->id = bkup_lst->long_id;
            result->model = bkup_lst->model;
            result->modulename = bkup_lst->modulename;
            /* Priority if for lst->type if available */
            if(bkup_lst->type != UNKNOWN_DEVICE){
              result->type = bkup_lst->type;
            }/*endif*/
            found = 1;
          }/*endif*/
        }/*endif*/
      }/*next bkup_lst*/
        
      if(!found){
        result->id = id;
        result->model = s_unknown;
        result->modulename = s_unknown;
        result->type = UNKNOWN_DEVICE;
      }/*endif*/
      if(debug){
        fprintf(stdout, "\tFound %s %s (%s)\n", 
               result->vendor, result->model, device2str(result->type));
      }/*endif*/
    }/*endwhile*/
    len = 0;
    free(line);
    fclose(f);  
  }/*endif*/
  
  return first;
}/*endfunc pci_detect*/
