/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/frame/logging_mutex.cpp
 *
 * @brief [LEVEL: beta] Implementation of @ref diagnostics::internal::Lock_Guard
 *
 * $Id: logging_mutex.cpp,v 1.6 2005/06/23 09:54:29 esdentem Exp $
 *
 * @author Christian Schallhart
 */

#include <diagnostics/frame/logging_mutex.hpp>


////////////////////////////////////////////////////////////////////////////////
//
// check for recursion but no mutex
//
#if DIAGNOSTICS_INTERNAL_SWITCH_MUTEX == 3
DIAGNOSTICS_NAMESPACE_BEGIN;
INTERNAL_NAMESPACE_BEGIN;
int Lock_Guard::m_nesting_count=0;
INTERNAL_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;
#endif




#if DIAGNOSTICS_INTERNAL_SWITCH_USE_ACE == 1

////////////////////////////////////////////////////////////////////////////////
//
// Use ACE for non-recursive, multithreaded solution
//
#  if DIAGNOSTICS_INTERNAL_SWITCH_MUTEX == 1
DIAGNOSTICS_NAMESPACE_BEGIN;
INTERNAL_NAMESPACE_BEGIN;
Lock_Guard::Mutex_t * Lock_Guard::m_mutex=NULL;
INTERNAL_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;
#  endif


////////////////////////////////////////////////////////////////////////////////
//
// Use ACE for recursive, multithreaded solution
//
#  if DIAGNOSTICS_INTERNAL_SWITCH_MUTEX == 2
DIAGNOSTICS_NAMESPACE_BEGIN;
INTERNAL_NAMESPACE_BEGIN;
Lock_Guard::Mutex_t * Lock_Guard::m_mutex=NULL;
int Lock_Guard::m_nesting_count=0;
INTERNAL_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;
#  endif
#endif



// vim:ts=4:sw=4
