/*****************************************************************

  ddj.h

  Copyright (c) 1999-2002 by Mike Oliphant - oliphant@gtk.org

    http://www.nostatic.org/ddj

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

*****************************************************************/

#include <gtk/gtk.h>
#include "idlist.h"

#define CURRENT_DB_VERSION 2

/* Song orders */
#define SONG_ORDER_RANDOM 0
#define SONG_ORDER_DISC 1
#define SONG_ORDER_OLDEST 2
#define SONG_ORDER_SLOWEST 3

/* List types */
#define LIST_TYPE_PLAYLIST 0
#define LIST_TYPE_SONG 1
#define LIST_TYPE_ARTIST 2
#define LIST_TYPE_DISC 3
#define LIST_TYPE_GENRE 4

typedef struct {
  GtkWidget *window;
  GtkWidget *clist;
  IDList *idlist;
  gint list_type;
} ListWindow;


/* BPM range */
#define LOW_BPM 0
#define HIGH_BPM 300

/* Speed catagories */
#define SLOW_BPM 60
#define MEDIUM_BPM 130
#define FAST_BPM 170

/* Commands */
enum {DDJ_PLAY,DDJ_STOP,DDJ_NEXT_SONG,DDJ_PREV_SONG,DDJ_VOL_UP,
      DDJ_VOL_DN,DDJ_MUTE,DDJ_DESCRIBE,DDJ_DISPLAY,DDJ_EXIT,DDJ_ALL_SONGS,
      DDJ_ARTIST_SONGS,DDJ_DISC_SONGS,DDJ_GENRE_SONGS,DDJ_TITLE_SONGS,
      DDJ_YEAR_SONGS,DDJ_2YEAR_SONGS,DDJ_DECADE_SONGS,DDJ_RECENT_SONGS,
      DDJ_RECALL,DDJ_RANDOMIZE,DDJ_JUKE_ADD_SONG,DDJ_LOAD_PLAYLIST
};

/* Structure for mapping command names to values */
typedef struct {
  char cmd_name[40];
  int cmd_num;
} CmdMap;

