/*
 * Decompiled with CFR 0.152.
 */
package de.xeinfach.kafenio.component.dialogs;

import de.xeinfach.kafenio.KafenioPanel;
import de.xeinfach.kafenio.component.dialogs.AbstractKafenioDialog;
import de.xeinfach.kafenio.util.LeanLogger;
import javax.swing.JTextField;

public class TableInputDialog
extends AbstractKafenioDialog {
    private static LeanLogger log = new LeanLogger("TableInputDialog.class");
    private String inputRows = new String();
    private String inputCols = new String();
    private String inputBorder = new String();
    private String inputSpace = new String();
    private String inputPad = new String();
    private final JTextField jtxfRows = new JTextField(3);
    private final JTextField jtxfCols = new JTextField(3);
    private final JTextField jtxfBorder = new JTextField(3);
    private final JTextField jtxfSpace = new JTextField(3);
    private final JTextField jtxfPad = new JTextField(3);
    private final Object[] panelContents;

    public TableInputDialog(KafenioPanel kafenioPanel, String string, boolean bl) {
        super(kafenioPanel, string, bl);
        this.panelContents = new Object[]{kafenioPanel.getTranslation("TableRows"), this.jtxfRows, kafenioPanel.getTranslation("TableColumns"), this.jtxfCols, kafenioPanel.getTranslation("TableBorder"), this.jtxfBorder, kafenioPanel.getTranslation("TableCellSpacing"), this.jtxfSpace, kafenioPanel.getTranslation("TableCellPadding"), this.jtxfPad};
        this.init(this.panelContents);
    }

    public void setDefaultValues(Object object) {
        if (object.equals(this.getButtonLabels()[0])) {
            this.inputRows = this.jtxfRows.getText();
            this.inputCols = this.jtxfCols.getText();
            this.inputBorder = this.jtxfBorder.getText();
            this.inputSpace = this.jtxfSpace.getText();
            this.inputPad = this.jtxfPad.getText();
            this.setVisible(false);
        } else {
            this.inputRows = "";
            this.inputCols = "";
            this.inputBorder = "";
            this.inputSpace = "";
            this.inputPad = "";
            this.setVisible(false);
        }
    }

    public int getRows() {
        try {
            return Integer.parseInt(this.inputRows);
        }
        catch (NumberFormatException numberFormatException) {
            log.error("not a number: " + numberFormatException.fillInStackTrace());
            return -1;
        }
    }

    public int getCols() {
        try {
            return Integer.parseInt(this.inputCols);
        }
        catch (NumberFormatException numberFormatException) {
            log.error("not a number: " + numberFormatException.fillInStackTrace());
            return -1;
        }
    }

    public int getBorder() {
        try {
            return Integer.parseInt(this.inputBorder);
        }
        catch (NumberFormatException numberFormatException) {
            log.error("not a number: " + numberFormatException.fillInStackTrace());
            return -1;
        }
    }

    public int getSpacing() {
        try {
            return Integer.parseInt(this.inputSpace);
        }
        catch (NumberFormatException numberFormatException) {
            log.error("not a number: " + numberFormatException.fillInStackTrace());
            return -1;
        }
    }

    public int getPadding() {
        try {
            return Integer.parseInt(this.inputPad);
        }
        catch (NumberFormatException numberFormatException) {
            log.error("not a number: " + numberFormatException.fillInStackTrace());
            return -1;
        }
    }
}

