/*
 * Decompiled with CFR 0.152.
 */
package com.hexidec.ekit;

import com.hexidec.ekit.action.CustomAction;
import com.hexidec.ekit.action.FormatAction;
import com.hexidec.ekit.action.ListAutomationAction;
import com.hexidec.ekit.action.StylesAction;
import com.hexidec.ekit.component.ExtendedHTMLDocument;
import com.hexidec.ekit.component.ExtendedHTMLEditorKit;
import com.hexidec.ekit.component.FileDialog;
import com.hexidec.ekit.component.HTMLUtilities;
import com.hexidec.ekit.component.ImageDialog;
import com.hexidec.ekit.component.ImageFileChooser;
import com.hexidec.ekit.component.JButtonNoFocus;
import com.hexidec.ekit.component.JComboBoxNoFocus;
import com.hexidec.ekit.component.JToggleButtonNoFocus;
import com.hexidec.ekit.component.MutableFilter;
import com.hexidec.ekit.component.PropertiesDialog;
import com.hexidec.ekit.component.SearchDialog;
import com.hexidec.ekit.component.SimpleInfoDialog;
import com.hexidec.util.Base64Codec;
import com.hexidec.util.Translatrix;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Style;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.text.rtf.RTFEditorKit;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class EkitCore
extends JPanel
implements ActionListener,
KeyListener,
DocumentListener {
    private JSplitPane jspltDisplay;
    private JTextPane jtpMain;
    private ExtendedHTMLEditorKit htmlKit;
    private ExtendedHTMLDocument htmlDoc;
    private StyleSheet styleSheet;
    private JTextPane jtpSource;
    private JScrollPane jspSource;
    private JToolBar jToolBar;
    private JCheckBoxMenuItem jcbmiViewToolbar;
    private JCheckBoxMenuItem jcbmiViewSource;
    private JButtonNoFocus jbtnNewHTML;
    private JButtonNoFocus jbtnOpenHTML;
    private JButtonNoFocus jbtnSaveHTML;
    private JButtonNoFocus jbtnCut;
    private JButtonNoFocus jbtnCopy;
    private JButtonNoFocus jbtnPaste;
    private JButtonNoFocus jbtnBold;
    private JButtonNoFocus jbtnItalic;
    private JButtonNoFocus jbtnUnderline;
    private JButtonNoFocus jbtnStrike;
    private JButtonNoFocus jbtnSuperscript;
    private JButtonNoFocus jbtnSubscript;
    private JButtonNoFocus jbtnUList;
    private JButtonNoFocus jbtnOList;
    private JButtonNoFocus jbtnClearFormat;
    private JButtonNoFocus jbtnAnchor;
    private JToggleButtonNoFocus jtbtnViewSource;
    private JComboBoxNoFocus jcmbStyleSelector;
    private Frame frameHandler;
    private HTMLUtilities htmlUtilities = new HTMLUtilities(this);
    private StyledEditorKit.BoldAction actionFontBold;
    private StyledEditorKit.ItalicAction actionFontItalic;
    private StyledEditorKit.UnderlineAction actionFontUnderline;
    private FormatAction actionFontStrike;
    private FormatAction actionFontSuperscript;
    private FormatAction actionFontSubscript;
    private ListAutomationAction actionListUnordered;
    private ListAutomationAction actionListOrdered;
    private CustomAction actionSelectFont;
    private CustomAction actionClearFormat;
    private CustomAction actionInsertAnchor;
    protected UndoManager undoMngr;
    protected UndoAction undoAction;
    protected RedoAction redoAction;
    private JMenuBar jMenuBar;
    private JMenu jMenuFile;
    private JMenu jMenuEdit;
    private JMenu jMenuView;
    private JMenu jMenuFont;
    private JMenu jMenuFormat;
    private JMenu jMenuInsert;
    private JMenu jMenuTable;
    private JMenu jMenuForms;
    private JMenu jMenuSearch;
    private JMenu jMenuHelp;
    private JMenu jMenuDebug;
    public static final String KEY_MENU_FILE = "file";
    public static final String KEY_MENU_EDIT = "edit";
    public static final String KEY_MENU_VIEW = "view";
    public static final String KEY_MENU_FONT = "font";
    public static final String KEY_MENU_FORMAT = "format";
    public static final String KEY_MENU_INSERT = "insert";
    public static final String KEY_MENU_TABLE = "table";
    public static final String KEY_MENU_FORMS = "forms";
    public static final String KEY_MENU_SEARCH = "search";
    public static final String KEY_MENU_TOOLS = "tools";
    public static final String KEY_MENU_HELP = "help";
    public static final String KEY_MENU_DEBUG = "debug";
    public static final String KEY_TOOL_SEP = "separator";
    public static final String KEY_TOOL_NEW = "new";
    public static final String KEY_TOOL_OPEN = "open";
    public static final String KEY_TOOL_SAVE = "save";
    public static final String KEY_TOOL_CUT = "cut";
    public static final String KEY_TOOL_COPY = "copy";
    public static final String KEY_TOOL_PASTE = "paste";
    public static final String KEY_TOOL_BOLD = "bold";
    public static final String KEY_TOOL_ITALIC = "italic";
    public static final String KEY_TOOL_UNDERLINE = "underline";
    public static final String KEY_TOOL_STRIKE = "strike";
    public static final String KEY_TOOL_SUPER = "superscript";
    public static final String KEY_TOOL_SUB = "subscript";
    public static final String KEY_TOOL_ULIST = "ulist";
    public static final String KEY_TOOL_OLIST = "olist";
    public static final String KEY_TOOL_CLEAR = "clearformats";
    public static final String KEY_TOOL_ANCHOR = "anchor";
    public static final String KEY_TOOL_SOURCE = "viewsource";
    public static final String KEY_TOOL_STYLES = "styleselect";
    private static Hashtable htMenus = new Hashtable();
    private static Hashtable htTools = new Hashtable();
    private final String appName = "Ekit";
    private final String menuDialog = "...";
    private final boolean useFormIndicator = true;
    private final String clrFormIndicator = "#cccccc";
    private Clipboard sysClipboard;
    private SecurityManager secManager;
    private int iSplitPos = 0;
    private boolean exclusiveEdit = true;
    private String lastSearchFindTerm = null;
    private String lastSearchReplaceTerm = null;
    private boolean lastSearchCaseSetting = false;
    private boolean lastSearchTopSetting = false;
    private File currentFile = null;
    private int indent = 0;
    private final int indentStep = 4;
    private final String[] extsHTML = new String[]{"html", "htm", "shtml"};
    private final String[] extsCSS = new String[]{"css"};
    private final String[] extsIMG = new String[]{"gif", "jpg", "jpeg", "png"};
    private final String[] extsRTF = new String[]{"rtf"};
    private final String[] extsB64 = new String[]{"b64"};
    private final String[] extsSer = new String[]{"ser"};
    private String ServletURL = null;
    private String TreePilotSystemID = "";
    private String ImageDir = "";
    private static ResourceBundle TreePilotProperties;

    public EkitCore(String string, String string2, String string3, URL uRL, boolean bl, boolean bl2, boolean bl3, String string4, String string5, boolean bl4, boolean bl5, String string6) {
        JMenuItem jMenuItem;
        JMenuItem jMenuItem2;
        JMenuItem jMenuItem3;
        Hashtable<String, String> hashtable;
        Object object;
        Serializable serializable;
        this.exclusiveEdit = bl3;
        this.frameHandler = new Frame();
        this.secManager = System.getSecurityManager();
        if (this.secManager != null) {
            try {
                this.secManager.checkSystemClipboardAccess();
                this.sysClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            }
            catch (SecurityException securityException) {
                this.sysClipboard = null;
            }
        }
        Translatrix.setBundleName("com.hexidec.ekit.LanguageResources");
        Locale locale = null;
        if (string4 != null && string5 != null) {
            locale = new Locale(string4, string5);
        }
        Translatrix.setLocale(locale);
        try {
            TreePilotProperties = ResourceBundle.getBundle("com.hexidec.ekit.TreePilot");
        }
        catch (MissingResourceException missingResourceException) {
            this.logException("MissingResourceException while loading treepilot file", missingResourceException);
        }
        this.jtpMain = new JTextPane();
        this.htmlKit = new ExtendedHTMLEditorKit(string6);
        this.htmlDoc = (ExtendedHTMLDocument)this.htmlKit.createDefaultDocument();
        this.styleSheet = this.htmlDoc.getStyleSheet();
        this.htmlKit.setDefaultCursor(new Cursor(2));
        this.jtpMain.setEditorKit(this.htmlKit);
        this.jtpMain.setDocument(this.htmlDoc);
        this.jtpMain.setMargin(new Insets(4, 4, 4, 4));
        this.jtpMain.addKeyListener(this);
        this.jtpSource = new JTextPane();
        this.jtpSource.setBackground(new Color(212, 212, 212));
        this.jtpSource.setSelectionColor(new Color(255, 192, 192));
        this.jtpSource.setText(this.jtpMain.getText());
        this.jtpSource.getDocument().addDocumentListener(this);
        this.jtpMain.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                EkitCore.this.handleCaretPositionChange(caretEvent);
            }
        });
        this.undoMngr = new UndoManager();
        this.undoAction = new UndoAction();
        this.redoAction = new RedoAction();
        this.jtpMain.getDocument().addUndoableEditListener(new CustomUndoableEditListener());
        if (string3 != null && string3.length() > 0) {
            if (bl4) {
                this.jtpMain.setText(Base64Codec.decode(string3));
            } else {
                this.jtpMain.setText(string3);
            }
        }
        this.jtpMain.setCaretPosition(0);
        this.jtpMain.getDocument().addDocumentListener(this);
        if (uRL != null) {
            try {
                serializable = this.jtpMain.getText();
                this.htmlDoc = (ExtendedHTMLDocument)this.htmlKit.createDefaultDocument();
                this.styleSheet = this.htmlDoc.getStyleSheet();
                object = new BufferedReader(new InputStreamReader(uRL.openStream()));
                this.styleSheet.loadRules((Reader)object, uRL);
                ((BufferedReader)object).close();
                this.htmlDoc = new ExtendedHTMLDocument(this.styleSheet);
                this.registerDocument(this.htmlDoc);
                this.jtpMain.setText((String)((Object)serializable));
                this.jtpSource.setText(this.jtpMain.getText());
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
        }
        if (string != null && ((File)(serializable = new File(string))).exists()) {
            try {
                this.openDocument((File)serializable);
            }
            catch (Exception exception) {
                this.logException("Exception in preloading HTML document", exception);
            }
        }
        if (string2 != null && ((File)(serializable = new File(string2))).exists()) {
            try {
                this.openStyleSheet((File)serializable);
            }
            catch (Exception exception) {
                this.logException("Exception in preloading CSS stylesheet", exception);
            }
        }
        serializable = new Hashtable();
        object = this.jtpMain.getActions();
        int n = 0;
        while (n < ((Action[])object).length) {
            hashtable = object[n];
            ((Hashtable)serializable).put(hashtable.getValue("Name"), hashtable);
            ++n;
        }
        this.actionFontBold = new StyledEditorKit.BoldAction();
        this.actionFontItalic = new StyledEditorKit.ItalicAction();
        this.actionFontUnderline = new StyledEditorKit.UnderlineAction();
        this.actionFontStrike = new FormatAction(this, Translatrix.getTranslationString("FontStrike"), HTML.Tag.STRIKE);
        this.actionFontSuperscript = new FormatAction(this, Translatrix.getTranslationString("FontSuperscript"), HTML.Tag.SUP);
        this.actionFontSubscript = new FormatAction(this, Translatrix.getTranslationString("FontSubscript"), HTML.Tag.SUB);
        this.actionListUnordered = new ListAutomationAction(this, Translatrix.getTranslationString("ListUnordered"), HTML.Tag.UL);
        this.actionListOrdered = new ListAutomationAction(this, Translatrix.getTranslationString("ListOrdered"), HTML.Tag.OL);
        hashtable = new Hashtable();
        hashtable.put("face", "");
        this.actionSelectFont = new CustomAction(this, Translatrix.getTranslationString("FontSelect") + "...", HTML.Tag.FONT, hashtable);
        this.actionClearFormat = new CustomAction(this, Translatrix.getTranslationString("FormatClear"), new HTML.UnknownTag(""));
        this.actionInsertAnchor = new CustomAction(this, Translatrix.getTranslationString("InsertAnchor") + "...", HTML.Tag.A);
        this.jMenuFile = new JMenu(Translatrix.getTranslationString("File"));
        htMenus.put(KEY_MENU_FILE, this.jMenuFile);
        JMenuItem jMenuItem4 = new JMenuItem(Translatrix.getTranslationString("NewDocument"));
        jMenuItem4.setActionCommand("newdoc");
        jMenuItem4.addActionListener(this);
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(78, 2, false));
        if (bl2) {
            jMenuItem4.setIcon(this.getEkitIcon("New"));
        }
        this.jMenuFile.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem(Translatrix.getTranslationString("OpenDocument") + "...");
        jMenuItem5.setActionCommand("openhtml");
        jMenuItem5.addActionListener(this);
        jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(79, 2, false));
        if (bl2) {
            jMenuItem5.setIcon(this.getEkitIcon("Open"));
        }
        this.jMenuFile.add(jMenuItem5);
        JMenuItem jMenuItem6 = new JMenuItem(Translatrix.getTranslationString("OpenStyle") + "...");
        jMenuItem6.setActionCommand("opencss");
        jMenuItem6.addActionListener(this);
        this.jMenuFile.add(jMenuItem6);
        JMenuItem jMenuItem7 = new JMenuItem(Translatrix.getTranslationString("OpenBase64Document") + "...");
        jMenuItem7.setActionCommand("openb64");
        jMenuItem7.addActionListener(this);
        this.jMenuFile.add(jMenuItem7);
        this.jMenuFile.addSeparator();
        JMenuItem jMenuItem8 = new JMenuItem(Translatrix.getTranslationString("Save"));
        jMenuItem8.setActionCommand(KEY_TOOL_SAVE);
        jMenuItem8.addActionListener(this);
        jMenuItem8.setAccelerator(KeyStroke.getKeyStroke(83, 2, false));
        if (bl2) {
            jMenuItem8.setIcon(this.getEkitIcon("Save"));
        }
        this.jMenuFile.add(jMenuItem8);
        JMenuItem jMenuItem9 = new JMenuItem(Translatrix.getTranslationString("SaveAs") + "...");
        jMenuItem9.setActionCommand("saveas");
        jMenuItem9.addActionListener(this);
        this.jMenuFile.add(jMenuItem9);
        JMenuItem jMenuItem10 = new JMenuItem(Translatrix.getTranslationString("SaveBody") + "...");
        jMenuItem10.setActionCommand("savebody");
        jMenuItem10.addActionListener(this);
        this.jMenuFile.add(jMenuItem10);
        JMenuItem jMenuItem11 = new JMenuItem(Translatrix.getTranslationString("SaveRTF") + "...");
        jMenuItem11.setActionCommand("savertf");
        jMenuItem11.addActionListener(this);
        this.jMenuFile.add(jMenuItem11);
        JMenuItem jMenuItem12 = new JMenuItem(Translatrix.getTranslationString("SaveB64") + "...");
        jMenuItem12.setActionCommand("saveb64");
        jMenuItem12.addActionListener(this);
        this.jMenuFile.add(jMenuItem12);
        this.jMenuFile.addSeparator();
        JMenuItem jMenuItem13 = new JMenuItem(Translatrix.getTranslationString("Serialize") + "...");
        jMenuItem13.setActionCommand("serialize");
        jMenuItem13.addActionListener(this);
        this.jMenuFile.add(jMenuItem13);
        JMenuItem jMenuItem14 = new JMenuItem(Translatrix.getTranslationString("ReadFromSer") + "...");
        jMenuItem14.setActionCommand("readfromser");
        jMenuItem14.addActionListener(this);
        this.jMenuFile.add(jMenuItem14);
        this.jMenuFile.addSeparator();
        JMenuItem jMenuItem15 = new JMenuItem(Translatrix.getTranslationString("Exit"));
        jMenuItem15.setActionCommand("exit");
        jMenuItem15.addActionListener(this);
        this.jMenuFile.add(jMenuItem15);
        this.jMenuEdit = new JMenu(Translatrix.getTranslationString("Edit"));
        htMenus.put(KEY_MENU_EDIT, this.jMenuEdit);
        if (this.sysClipboard != null) {
            jMenuItem3 = new JMenuItem(Translatrix.getTranslationString("Cut"));
            jMenuItem3.setActionCommand("textcut");
            jMenuItem3.addActionListener(this);
            jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(88, 2, false));
            if (bl2) {
                jMenuItem3.setIcon(this.getEkitIcon("Cut"));
            }
            this.jMenuEdit.add(jMenuItem3);
            jMenuItem2 = new JMenuItem(Translatrix.getTranslationString("Copy"));
            jMenuItem2.setActionCommand("textcopy");
            jMenuItem2.addActionListener(this);
            jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(67, 2, false));
            if (bl2) {
                jMenuItem2.setIcon(this.getEkitIcon("Copy"));
            }
            this.jMenuEdit.add(jMenuItem2);
            jMenuItem = new JMenuItem(Translatrix.getTranslationString("Paste"));
            jMenuItem.setActionCommand("textpaste");
            jMenuItem.addActionListener(this);
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2, false));
            if (bl2) {
                jMenuItem.setIcon(this.getEkitIcon("Paste"));
            }
            this.jMenuEdit.add(jMenuItem);
        } else {
            jMenuItem3 = new JMenuItem(new DefaultEditorKit.CutAction());
            jMenuItem3.setText(Translatrix.getTranslationString("Cut"));
            jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(88, 2, false));
            if (bl2) {
                jMenuItem3.setIcon(this.getEkitIcon("Cut"));
            }
            this.jMenuEdit.add(jMenuItem3);
            jMenuItem2 = new JMenuItem(new DefaultEditorKit.CopyAction());
            jMenuItem2.setText(Translatrix.getTranslationString("Copy"));
            jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(67, 2, false));
            if (bl2) {
                jMenuItem2.setIcon(this.getEkitIcon("Copy"));
            }
            this.jMenuEdit.add(jMenuItem2);
            jMenuItem = new JMenuItem(new DefaultEditorKit.PasteAction());
            jMenuItem.setText(Translatrix.getTranslationString("Paste"));
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2, false));
            if (bl2) {
                jMenuItem.setIcon(this.getEkitIcon("Paste"));
            }
            this.jMenuEdit.add(jMenuItem);
        }
        this.jMenuEdit.addSeparator();
        jMenuItem3 = new JMenuItem(this.undoAction);
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(90, 2, false));
        this.jMenuEdit.add(jMenuItem3);
        jMenuItem2 = new JMenuItem(this.redoAction);
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(89, 2, false));
        this.jMenuEdit.add(jMenuItem2);
        this.jMenuEdit.addSeparator();
        jMenuItem = new JMenuItem((Action)((Hashtable)serializable).get("select-all"));
        jMenuItem.setText(Translatrix.getTranslationString("SelectAll"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2, false));
        this.jMenuEdit.add(jMenuItem);
        JMenuItem jMenuItem16 = new JMenuItem((Action)((Hashtable)serializable).get("select-paragraph"));
        jMenuItem16.setText(Translatrix.getTranslationString("SelectParagraph"));
        this.jMenuEdit.add(jMenuItem16);
        JMenuItem jMenuItem17 = new JMenuItem((Action)((Hashtable)serializable).get("select-line"));
        jMenuItem17.setText(Translatrix.getTranslationString("SelectLine"));
        this.jMenuEdit.add(jMenuItem17);
        JMenuItem jMenuItem18 = new JMenuItem((Action)((Hashtable)serializable).get("select-word"));
        jMenuItem18.setText(Translatrix.getTranslationString("SelectWord"));
        this.jMenuEdit.add(jMenuItem18);
        this.jMenuView = new JMenu(Translatrix.getTranslationString("View"));
        htMenus.put(KEY_MENU_VIEW, this.jMenuView);
        this.jcbmiViewToolbar = new JCheckBoxMenuItem(Translatrix.getTranslationString("ViewToolbar"), false);
        this.jcbmiViewToolbar.setActionCommand("toggletoolbar");
        this.jcbmiViewToolbar.addActionListener(this);
        this.jMenuView.add(this.jcbmiViewToolbar);
        this.jcbmiViewSource = new JCheckBoxMenuItem(Translatrix.getTranslationString("ViewSource"), false);
        this.jcbmiViewSource.setActionCommand(KEY_TOOL_SOURCE);
        this.jcbmiViewSource.addActionListener(this);
        this.jMenuView.add(this.jcbmiViewSource);
        this.jMenuFont = new JMenu(Translatrix.getTranslationString("Font"));
        htMenus.put(KEY_MENU_FONT, this.jMenuFont);
        JMenuItem jMenuItem19 = new JMenuItem(this.actionFontBold);
        jMenuItem19.setText(Translatrix.getTranslationString("FontBold"));
        jMenuItem19.setAccelerator(KeyStroke.getKeyStroke(66, 2, false));
        if (bl2) {
            jMenuItem19.setIcon(this.getEkitIcon("Bold"));
        }
        this.jMenuFont.add(jMenuItem19);
        JMenuItem jMenuItem20 = new JMenuItem(this.actionFontItalic);
        jMenuItem20.setText(Translatrix.getTranslationString("FontItalic"));
        jMenuItem20.setAccelerator(KeyStroke.getKeyStroke(73, 2, false));
        if (bl2) {
            jMenuItem20.setIcon(this.getEkitIcon("Italic"));
        }
        this.jMenuFont.add(jMenuItem20);
        JMenuItem jMenuItem21 = new JMenuItem(this.actionFontUnderline);
        jMenuItem21.setText(Translatrix.getTranslationString("FontUnderline"));
        jMenuItem21.setAccelerator(KeyStroke.getKeyStroke(85, 2, false));
        if (bl2) {
            jMenuItem21.setIcon(this.getEkitIcon("Underline"));
        }
        this.jMenuFont.add(jMenuItem21);
        JMenuItem jMenuItem22 = new JMenuItem(this.actionFontStrike);
        jMenuItem22.setText(Translatrix.getTranslationString("FontStrike"));
        if (bl2) {
            jMenuItem22.setIcon(this.getEkitIcon("Strike"));
        }
        this.jMenuFont.add(jMenuItem22);
        this.jMenuFont.addSeparator();
        this.jMenuFont.add(new JMenuItem(new FormatAction(this, Translatrix.getTranslationString("FormatBig"), HTML.Tag.BIG)));
        this.jMenuFont.add(new JMenuItem(new FormatAction(this, Translatrix.getTranslationString("FormatSmall"), HTML.Tag.SMALL)));
        JMenu jMenu = new JMenu(Translatrix.getTranslationString("FontSize"));
        String string7 = "size";
        hashtable = new Hashtable<String, String>();
        hashtable.put(string7, "1");
        jMenu.add(new JMenuItem(new CustomAction(this, Translatrix.getTranslationString("FontSize1"), HTML.Tag.FONT, hashtable)));
        hashtable = new Hashtable();
        hashtable.put(string7, "2");
        jMenu.add(new JMenuItem(new CustomAction(this, Translatrix.getTranslationString("FontSize2"), HTML.Tag.FONT, hashtable)));
        hashtable = new Hashtable();
        hashtable.put(string7, "3");
        jMenu.add(new JMenuItem(new CustomAction(this, Translatrix.getTranslationString("FontSize3"), HTML.Tag.FONT, hashtable)));
        hashtable = new Hashtable();
        hashtable.put(string7, "4");
        jMenu.add(new JMenuItem(new CustomAction(this, Translatrix.getTranslationString("FontSize4"), HTML.Tag.FONT, hashtable)));
        hashtable = new Hashtable();
        hashtable.put(string7, "5");
        jMenu.add(new JMenuItem(new CustomAction(this, Translatrix.getTranslationString("FontSize5"), HTML.Tag.FONT, hashtable)));
        hashtable = new Hashtable();
        hashtable.put(string7, "6");
        jMenu.add(new JMenuItem(new CustomAction(this, Translatrix.getTranslationString("FontSize6"), HTML.Tag.FONT, hashtable)));
        hashtable = new Hashtable();
        hashtable.put(string7, "7");
        jMenu.add(new JMenuItem(new CustomAction(this, Translatrix.getTranslationString("FontSize7"), HTML.Tag.FONT, hashtable)));
        this.jMenuFont.add(jMenu);
        this.jMenuFont.addSeparator();
        JMenuItem jMenuItem23 = new JMenuItem(this.actionFontSuperscript);
        if (bl2) {
            jMenuItem23.setIcon(this.getEkitIcon("Super"));
        }
        this.jMenuFont.add(jMenuItem23);
        JMenuItem jMenuItem24 = new JMenuItem(this.actionFontSubscript);
        if (bl2) {
            jMenuItem24.setIcon(this.getEkitIcon("Sub"));
        }
        this.jMenuFont.add(jMenuItem24);
        this.jMenuFont.addSeparator();
        JMenuItem jMenuItem25 = new JMenuItem((Action)((Hashtable)serializable).get("font-family-Serif"));
        jMenuItem25.setText(Translatrix.getTranslationString("FontSerif"));
        this.jMenuFont.add(jMenuItem25);
        JMenuItem jMenuItem26 = new JMenuItem((Action)((Hashtable)serializable).get("font-family-SansSerif"));
        jMenuItem26.setText(Translatrix.getTranslationString("FontSansserif"));
        this.jMenuFont.add(jMenuItem26);
        JMenuItem jMenuItem27 = new JMenuItem((Action)((Hashtable)serializable).get("font-family-Monospaced"));
        jMenuItem27.setText(Translatrix.getTranslationString("FontMonospaced"));
        this.jMenuFont.add(jMenuItem27);
        JMenuItem jMenuItem28 = new JMenuItem(this.actionSelectFont);
        this.jMenuFont.add(jMenuItem28);
        this.jMenuFont.addSeparator();
        JMenu jMenu2 = new JMenu(Translatrix.getTranslationString("Color"));
        hashtable = new Hashtable();
        hashtable.put("color", "black");
        jMenu2.add(new JMenuItem(new CustomAction(this, Translatrix.getTranslationString("CustomColor") + "...", HTML.Tag.FONT, hashtable)));
        jMenu2.add(new JMenuItem(new StyledEditorKit.ForegroundAction(Translatrix.getTranslationString("ColorAqua"), new Color(0, 255, 255))));
        jMenu2.add(new JMenuItem(new StyledEditorKit.ForegroundAction(Translatrix.getTranslationString("ColorBlack"), new Color(0, 0, 0))));
        jMenu2.add(new JMenuItem(new StyledEditorKit.ForegroundAction(Translatrix.getTranslationString("ColorBlue"), new Color(0, 0, 255))));
        jMenu2.add(new JMenuItem(new StyledEditorKit.ForegroundAction(Translatrix.getTranslationString("ColorFuschia"), new Color(255, 0, 255))));
        jMenu2.add(new JMenuItem(new StyledEditorKit.ForegroundAction(Translatrix.getTranslationString("ColorGray"), new Color(128, 128, 128))));
        jMenu2.add(new JMenuItem(new StyledEditorKit.ForegroundAction(Translatrix.getTranslationString("ColorGreen"), new Color(0, 128, 0))));
        jMenu2.add(new JMenuItem(new StyledEditorKit.ForegroundAction(Translatrix.getTranslationString("ColorLime"), new Color(0, 255, 0))));
        jMenu2.add(new JMenuItem(new StyledEditorKit.ForegroundAction(Translatrix.getTranslationString("ColorMaroon"), new Color(128, 0, 0))));
        jMenu2.add(new JMenuItem(new StyledEditorKit.ForegroundAction(Translatrix.getTranslationString("ColorNavy"), new Color(0, 0, 128))));
        jMenu2.add(new JMenuItem(new StyledEditorKit.ForegroundAction(Translatrix.getTranslationString("ColorOlive"), new Color(128, 128, 0))));
        jMenu2.add(new JMenuItem(new StyledEditorKit.ForegroundAction(Translatrix.getTranslationString("ColorPurple"), new Color(128, 0, 128))));
        jMenu2.add(new JMenuItem(new StyledEditorKit.ForegroundAction(Translatrix.getTranslationString("ColorRed"), new Color(255, 0, 0))));
        jMenu2.add(new JMenuItem(new StyledEditorKit.ForegroundAction(Translatrix.getTranslationString("ColorSilver"), new Color(192, 192, 192))));
        jMenu2.add(new JMenuItem(new StyledEditorKit.ForegroundAction(Translatrix.getTranslationString("ColorTeal"), new Color(0, 128, 128))));
        jMenu2.add(new JMenuItem(new StyledEditorKit.ForegroundAction(Translatrix.getTranslationString("ColorWhite"), new Color(255, 255, 255))));
        jMenu2.add(new JMenuItem(new StyledEditorKit.ForegroundAction(Translatrix.getTranslationString("ColorYellow"), new Color(255, 255, 0))));
        this.jMenuFont.add(jMenu2);
        this.jMenuFormat = new JMenu(Translatrix.getTranslationString("Format"));
        htMenus.put(KEY_MENU_FORMAT, this.jMenuFormat);
        JMenu jMenu3 = new JMenu(Translatrix.getTranslationString("Align"));
        jMenu3.add(new JMenuItem(new StyledEditorKit.AlignmentAction(Translatrix.getTranslationString("AlignLeft"), 0)));
        jMenu3.add(new JMenuItem(new StyledEditorKit.AlignmentAction(Translatrix.getTranslationString("AlignCenter"), 1)));
        jMenu3.add(new JMenuItem(new StyledEditorKit.AlignmentAction(Translatrix.getTranslationString("AlignRight"), 2)));
        jMenu3.add(new JMenuItem(new StyledEditorKit.AlignmentAction(Translatrix.getTranslationString("AlignJustified"), 3)));
        this.jMenuFormat.add(jMenu3);
        this.jMenuFormat.addSeparator();
        JMenu jMenu4 = new JMenu(Translatrix.getTranslationString("Heading"));
        jMenu4.add(new JMenuItem(new FormatAction(this, Translatrix.getTranslationString("Heading1"), HTML.Tag.H1)));
        jMenu4.add(new JMenuItem(new FormatAction(this, Translatrix.getTranslationString("Heading2"), HTML.Tag.H2)));
        jMenu4.add(new JMenuItem(new FormatAction(this, Translatrix.getTranslationString("Heading3"), HTML.Tag.H3)));
        jMenu4.add(new JMenuItem(new FormatAction(this, Translatrix.getTranslationString("Heading4"), HTML.Tag.H4)));
        jMenu4.add(new JMenuItem(new FormatAction(this, Translatrix.getTranslationString("Heading5"), HTML.Tag.H5)));
        jMenu4.add(new JMenuItem(new FormatAction(this, Translatrix.getTranslationString("Heading6"), HTML.Tag.H6)));
        this.jMenuFormat.add(jMenu4);
        this.jMenuFormat.addSeparator();
        JMenuItem jMenuItem29 = new JMenuItem(this.actionListUnordered);
        if (bl2) {
            jMenuItem29.setIcon(this.getEkitIcon("UList"));
        }
        this.jMenuFormat.add(jMenuItem29);
        JMenuItem jMenuItem30 = new JMenuItem(this.actionListOrdered);
        if (bl2) {
            jMenuItem30.setIcon(this.getEkitIcon("OList"));
        }
        this.jMenuFormat.add(jMenuItem30);
        this.jMenuFormat.add(new JMenuItem(new FormatAction(this, Translatrix.getTranslationString("ListItem"), HTML.Tag.LI)));
        this.jMenuFormat.addSeparator();
        this.jMenuFormat.add(new JMenuItem(new FormatAction(this, Translatrix.getTranslationString("FormatBlockquote"), HTML.Tag.BLOCKQUOTE)));
        this.jMenuFormat.add(new JMenuItem(new FormatAction(this, Translatrix.getTranslationString("FormatPre"), HTML.Tag.PRE)));
        this.jMenuFormat.add(new JMenuItem(new FormatAction(this, Translatrix.getTranslationString("FormatStrong"), HTML.Tag.STRONG)));
        this.jMenuFormat.add(new JMenuItem(new FormatAction(this, Translatrix.getTranslationString("FormatEmphasis"), HTML.Tag.EM)));
        this.jMenuFormat.add(new JMenuItem(new FormatAction(this, Translatrix.getTranslationString("FormatTT"), HTML.Tag.TT)));
        this.jMenuFormat.add(new JMenuItem(new FormatAction(this, Translatrix.getTranslationString("FormatSpan"), HTML.Tag.SPAN)));
        this.jMenuFormat.addSeparator();
        JMenuItem jMenuItem31 = new JMenuItem(this.actionClearFormat);
        if (bl2) {
            jMenuItem31.setIcon(this.getEkitIcon("ClearFormat"));
        }
        this.jMenuFormat.add(jMenuItem31);
        this.jMenuInsert = new JMenu(Translatrix.getTranslationString("Insert"));
        htMenus.put(KEY_MENU_INSERT, this.jMenuInsert);
        this.jMenuInsert.add(new JMenuItem(this.actionInsertAnchor));
        JMenuItem jMenuItem32 = new JMenuItem(Translatrix.getTranslationString("InsertBreak"));
        jMenuItem32.setActionCommand("insertbreak");
        jMenuItem32.addActionListener(this);
        jMenuItem32.setAccelerator(KeyStroke.getKeyStroke(10, 1, false));
        this.jMenuInsert.add(jMenuItem32);
        JMenuItem jMenuItem33 = new JMenuItem(Translatrix.getTranslationString("InsertNBSP"));
        jMenuItem33.setActionCommand("insertnbsp");
        jMenuItem33.addActionListener(this);
        this.jMenuInsert.add(jMenuItem33);
        JMenuItem jMenuItem34 = new JMenuItem((Action)((Hashtable)serializable).get("InsertHR"));
        jMenuItem34.setText(Translatrix.getTranslationString("InsertHorizontalRule"));
        this.jMenuInsert.add(jMenuItem34);
        this.jMenuInsert.addSeparator();
        JMenuItem jMenuItem35 = new JMenuItem(Translatrix.getTranslationString("InsertLocalImage") + "...");
        jMenuItem35.setActionCommand("insertlocalimage");
        jMenuItem35.addActionListener(this);
        this.jMenuInsert.add(jMenuItem35);
        JMenuItem jMenuItem36 = new JMenuItem(Translatrix.getTranslationString("InsertServerImage") + "...");
        jMenuItem36.setActionCommand("insertserverimage");
        jMenuItem36.addActionListener(this);
        this.jMenuInsert.add(jMenuItem36);
        this.jMenuTable = new JMenu(Translatrix.getTranslationString("Table"));
        htMenus.put(KEY_MENU_TABLE, this.jMenuTable);
        JMenuItem jMenuItem37 = new JMenuItem(Translatrix.getTranslationString("InsertTable") + "...");
        jMenuItem37.setActionCommand("inserttable");
        jMenuItem37.addActionListener(this);
        this.jMenuTable.add(jMenuItem37);
        this.jMenuTable.addSeparator();
        JMenuItem jMenuItem38 = new JMenuItem(Translatrix.getTranslationString("InsertTableRow"));
        jMenuItem38.setActionCommand("inserttablerow");
        jMenuItem38.addActionListener(this);
        this.jMenuTable.add(jMenuItem38);
        JMenuItem jMenuItem39 = new JMenuItem(Translatrix.getTranslationString("InsertTableColumn"));
        jMenuItem39.setActionCommand("inserttablecolumn");
        jMenuItem39.addActionListener(this);
        this.jMenuTable.add(jMenuItem39);
        this.jMenuTable.addSeparator();
        JMenuItem jMenuItem40 = new JMenuItem(Translatrix.getTranslationString("DeleteTableRow"));
        jMenuItem40.setActionCommand("deletetablerow");
        jMenuItem40.addActionListener(this);
        this.jMenuTable.add(jMenuItem40);
        JMenuItem jMenuItem41 = new JMenuItem(Translatrix.getTranslationString("DeleteTableColumn"));
        jMenuItem41.setActionCommand("deletetablecolumn");
        jMenuItem41.addActionListener(this);
        this.jMenuTable.add(jMenuItem41);
        this.jMenuForms = new JMenu(Translatrix.getTranslationString("Forms"));
        htMenus.put(KEY_MENU_FORMS, this.jMenuForms);
        JMenuItem jMenuItem42 = new JMenuItem(Translatrix.getTranslationString("FormInsertForm"));
        jMenuItem42.setActionCommand("insertform");
        jMenuItem42.addActionListener(this);
        this.jMenuForms.add(jMenuItem42);
        this.jMenuForms.addSeparator();
        JMenuItem jMenuItem43 = new JMenuItem(Translatrix.getTranslationString("FormTextfield"));
        jMenuItem43.setActionCommand("inserttextfield");
        jMenuItem43.addActionListener(this);
        this.jMenuForms.add(jMenuItem43);
        JMenuItem jMenuItem44 = new JMenuItem(Translatrix.getTranslationString("FormTextarea"));
        jMenuItem44.setActionCommand("inserttextarea");
        jMenuItem44.addActionListener(this);
        this.jMenuForms.add(jMenuItem44);
        JMenuItem jMenuItem45 = new JMenuItem(Translatrix.getTranslationString("FormCheckbox"));
        jMenuItem45.setActionCommand("insertcheckbox");
        jMenuItem45.addActionListener(this);
        this.jMenuForms.add(jMenuItem45);
        JMenuItem jMenuItem46 = new JMenuItem(Translatrix.getTranslationString("FormRadio"));
        jMenuItem46.setActionCommand("insertradiobutton");
        jMenuItem46.addActionListener(this);
        this.jMenuForms.add(jMenuItem46);
        JMenuItem jMenuItem47 = new JMenuItem(Translatrix.getTranslationString("FormPassword"));
        jMenuItem47.setActionCommand("insertpassword");
        jMenuItem47.addActionListener(this);
        this.jMenuForms.add(jMenuItem47);
        this.jMenuForms.addSeparator();
        JMenuItem jMenuItem48 = new JMenuItem(Translatrix.getTranslationString("FormButton"));
        jMenuItem48.setActionCommand("insertbutton");
        jMenuItem48.addActionListener(this);
        this.jMenuForms.add(jMenuItem48);
        JMenuItem jMenuItem49 = new JMenuItem(Translatrix.getTranslationString("FormButtonSubmit"));
        jMenuItem49.setActionCommand("insertbuttonsubmit");
        jMenuItem49.addActionListener(this);
        this.jMenuForms.add(jMenuItem49);
        JMenuItem jMenuItem50 = new JMenuItem(Translatrix.getTranslationString("FormButtonReset"));
        jMenuItem50.setActionCommand("insertbuttonreset");
        jMenuItem50.addActionListener(this);
        this.jMenuForms.add(jMenuItem50);
        this.jMenuSearch = new JMenu(Translatrix.getTranslationString("Search"));
        htMenus.put(KEY_MENU_SEARCH, this.jMenuSearch);
        JMenuItem jMenuItem51 = new JMenuItem(Translatrix.getTranslationString("SearchFind"));
        jMenuItem51.setActionCommand("find");
        jMenuItem51.addActionListener(this);
        jMenuItem51.setAccelerator(KeyStroke.getKeyStroke(70, 2, false));
        this.jMenuSearch.add(jMenuItem51);
        JMenuItem jMenuItem52 = new JMenuItem(Translatrix.getTranslationString("SearchFindAgain"));
        jMenuItem52.setActionCommand("findagain");
        jMenuItem52.addActionListener(this);
        jMenuItem52.setAccelerator(KeyStroke.getKeyStroke(71, 2, false));
        this.jMenuSearch.add(jMenuItem52);
        JMenuItem jMenuItem53 = new JMenuItem(Translatrix.getTranslationString("SearchReplace"));
        jMenuItem53.setActionCommand("replace");
        jMenuItem53.addActionListener(this);
        jMenuItem53.setAccelerator(KeyStroke.getKeyStroke(82, 2, false));
        this.jMenuSearch.add(jMenuItem53);
        this.jMenuHelp = new JMenu(Translatrix.getTranslationString("Help"));
        htMenus.put(KEY_MENU_HELP, this.jMenuHelp);
        JMenuItem jMenuItem54 = new JMenuItem(Translatrix.getTranslationString("About"));
        jMenuItem54.setActionCommand("helpabout");
        jMenuItem54.addActionListener(this);
        this.jMenuHelp.add(jMenuItem54);
        this.jMenuDebug = new JMenu(Translatrix.getTranslationString("Debug"));
        htMenus.put(KEY_MENU_DEBUG, this.jMenuDebug);
        JMenuItem jMenuItem55 = new JMenuItem(Translatrix.getTranslationString("DescribeDoc"));
        jMenuItem55.setActionCommand("describe");
        jMenuItem55.addActionListener(this);
        this.jMenuDebug.add(jMenuItem55);
        JMenuItem jMenuItem56 = new JMenuItem(Translatrix.getTranslationString("DescribeCSS"));
        jMenuItem56.setActionCommand("describecss");
        jMenuItem56.addActionListener(this);
        this.jMenuDebug.add(jMenuItem56);
        JMenuItem jMenuItem57 = new JMenuItem(Translatrix.getTranslationString("WhatTags"));
        jMenuItem57.setActionCommand("whattags");
        jMenuItem57.addActionListener(this);
        this.jMenuDebug.add(jMenuItem57);
        this.jMenuBar = new JMenuBar();
        this.jMenuBar.add(this.jMenuFile);
        this.jMenuBar.add(this.jMenuEdit);
        this.jMenuBar.add(this.jMenuView);
        this.jMenuBar.add(this.jMenuFont);
        this.jMenuBar.add(this.jMenuFormat);
        this.jMenuBar.add(this.jMenuSearch);
        this.jMenuBar.add(this.jMenuInsert);
        this.jMenuBar.add(this.jMenuTable);
        this.jMenuBar.add(this.jMenuForms);
        this.jMenuBar.add(this.jMenuHelp);
        if (bl5) {
            this.jMenuBar.add(this.jMenuDebug);
        }
        this.jToolBar = new JToolBar(0);
        this.jToolBar.setFloatable(false);
        this.jbtnNewHTML = new JButtonNoFocus(this.getEkitIcon("New"));
        this.jbtnNewHTML.setToolTipText(Translatrix.getTranslationString("NewDocument"));
        this.jbtnNewHTML.setActionCommand("newdoc");
        this.jbtnNewHTML.addActionListener(this);
        this.jToolBar.add(this.jbtnNewHTML);
        htTools.put(KEY_TOOL_NEW, this.jbtnNewHTML);
        this.jbtnOpenHTML = new JButtonNoFocus(this.getEkitIcon("Open"));
        this.jbtnOpenHTML.setToolTipText(Translatrix.getTranslationString("OpenDocument"));
        this.jbtnOpenHTML.setActionCommand("openhtml");
        this.jbtnOpenHTML.addActionListener(this);
        this.jToolBar.add(this.jbtnOpenHTML);
        htTools.put(KEY_TOOL_OPEN, this.jbtnOpenHTML);
        this.jbtnSaveHTML = new JButtonNoFocus(this.getEkitIcon("Save"));
        this.jbtnSaveHTML.setToolTipText(Translatrix.getTranslationString("SaveDocument"));
        this.jbtnSaveHTML.setActionCommand("saveas");
        this.jbtnSaveHTML.addActionListener(this);
        this.jToolBar.add(this.jbtnSaveHTML);
        htTools.put(KEY_TOOL_SAVE, this.jbtnSaveHTML);
        this.jToolBar.add(new JToolBar.Separator());
        this.jbtnCut = new JButtonNoFocus(new DefaultEditorKit.CutAction());
        this.jbtnCut.setIcon(this.getEkitIcon("Cut"));
        this.jbtnCut.setText(null);
        this.jbtnCut.setToolTipText(Translatrix.getTranslationString("Cut"));
        this.jToolBar.add(this.jbtnCut);
        htTools.put(KEY_TOOL_CUT, this.jbtnCut);
        this.jbtnCopy = new JButtonNoFocus(new DefaultEditorKit.CopyAction());
        this.jbtnCopy.setIcon(this.getEkitIcon("Copy"));
        this.jbtnCopy.setText(null);
        this.jbtnCopy.setToolTipText(Translatrix.getTranslationString("Copy"));
        this.jToolBar.add(this.jbtnCopy);
        htTools.put(KEY_TOOL_COPY, this.jbtnCopy);
        this.jbtnPaste = new JButtonNoFocus(new DefaultEditorKit.PasteAction());
        this.jbtnPaste.setIcon(this.getEkitIcon("Paste"));
        this.jbtnPaste.setText(null);
        this.jbtnPaste.setToolTipText(Translatrix.getTranslationString("Paste"));
        this.jToolBar.add(this.jbtnPaste);
        htTools.put(KEY_TOOL_PASTE, this.jbtnPaste);
        this.jToolBar.add(new JToolBar.Separator());
        this.jbtnBold = new JButtonNoFocus(this.actionFontBold);
        this.jbtnBold.setIcon(this.getEkitIcon("Bold"));
        this.jbtnBold.setText(null);
        this.jbtnBold.setToolTipText(Translatrix.getTranslationString("FontBold"));
        this.jToolBar.add(this.jbtnBold);
        htTools.put(KEY_TOOL_BOLD, this.jbtnBold);
        this.jbtnItalic = new JButtonNoFocus(this.actionFontItalic);
        this.jbtnItalic.setIcon(this.getEkitIcon("Italic"));
        this.jbtnItalic.setText(null);
        this.jbtnItalic.setToolTipText(Translatrix.getTranslationString("FontItalic"));
        this.jToolBar.add(this.jbtnItalic);
        htTools.put(KEY_TOOL_ITALIC, this.jbtnItalic);
        this.jbtnUnderline = new JButtonNoFocus(this.actionFontUnderline);
        this.jbtnUnderline.setIcon(this.getEkitIcon("Underline"));
        this.jbtnUnderline.setText(null);
        this.jbtnUnderline.setToolTipText(Translatrix.getTranslationString("FontUnderline"));
        this.jToolBar.add(this.jbtnUnderline);
        htTools.put(KEY_TOOL_UNDERLINE, this.jbtnUnderline);
        this.jbtnStrike = new JButtonNoFocus(this.actionFontStrike);
        this.jbtnStrike.setIcon(this.getEkitIcon("Strike"));
        this.jbtnStrike.setText(null);
        this.jbtnStrike.setToolTipText(Translatrix.getTranslationString("FontStrike"));
        this.jToolBar.add(this.jbtnStrike);
        htTools.put(KEY_TOOL_STRIKE, this.jbtnStrike);
        this.jbtnSuperscript = new JButtonNoFocus(this.actionFontSuperscript);
        this.jbtnSuperscript.setIcon(this.getEkitIcon("Super"));
        this.jbtnSuperscript.setText(null);
        this.jbtnSuperscript.setToolTipText(Translatrix.getTranslationString("FontSuperscript"));
        this.jToolBar.add(this.jbtnSuperscript);
        htTools.put(KEY_TOOL_SUPER, this.jbtnSuperscript);
        this.jbtnSubscript = new JButtonNoFocus(this.actionFontSubscript);
        this.jbtnSubscript.setIcon(this.getEkitIcon("Sub"));
        this.jbtnSubscript.setText(null);
        this.jbtnSubscript.setToolTipText(Translatrix.getTranslationString("FontSubscript"));
        this.jToolBar.add(this.jbtnSubscript);
        htTools.put(KEY_TOOL_SUB, this.jbtnSubscript);
        this.jbtnUList = new JButtonNoFocus(this.actionListUnordered);
        this.jbtnUList.setIcon(this.getEkitIcon("UList"));
        this.jbtnUList.setText(null);
        this.jbtnUList.setToolTipText(Translatrix.getTranslationString("ListUnordered"));
        this.jToolBar.add(this.jbtnUList);
        htTools.put(KEY_TOOL_ULIST, this.jbtnUList);
        this.jbtnOList = new JButtonNoFocus(this.actionListOrdered);
        this.jbtnOList.setIcon(this.getEkitIcon("OList"));
        this.jbtnOList.setText(null);
        this.jbtnOList.setToolTipText(Translatrix.getTranslationString("ListOrdered"));
        this.jToolBar.add(this.jbtnOList);
        htTools.put(KEY_TOOL_OLIST, this.jbtnOList);
        this.jbtnClearFormat = new JButtonNoFocus(this.actionClearFormat);
        this.jbtnClearFormat.setIcon(this.getEkitIcon("ClearFormat"));
        this.jbtnClearFormat.setText(null);
        this.jbtnClearFormat.setToolTipText(Translatrix.getTranslationString("FormatClear"));
        this.jToolBar.add(this.jbtnClearFormat);
        htTools.put(KEY_TOOL_CLEAR, this.jbtnClearFormat);
        this.jToolBar.add(new JToolBar.Separator());
        this.jbtnAnchor = new JButtonNoFocus(this.actionInsertAnchor);
        this.jbtnAnchor.setIcon(this.getEkitIcon("Anchor"));
        this.jbtnAnchor.setText(null);
        this.jbtnAnchor.setToolTipText(Translatrix.getTranslationString("ToolAnchor"));
        this.jToolBar.add(this.jbtnAnchor);
        htTools.put(KEY_TOOL_ANCHOR, this.jbtnAnchor);
        this.jToolBar.add(new JToolBar.Separator());
        this.jtbtnViewSource = new JToggleButtonNoFocus(this.getEkitIcon("Source"));
        this.jtbtnViewSource.setText(null);
        this.jtbtnViewSource.setToolTipText(Translatrix.getTranslationString("ViewSource"));
        this.jtbtnViewSource.setActionCommand(KEY_TOOL_SOURCE);
        this.jtbtnViewSource.addActionListener(this);
        this.jtbtnViewSource.setPreferredSize(this.jbtnAnchor.getPreferredSize());
        this.jtbtnViewSource.setMinimumSize(this.jbtnAnchor.getMinimumSize());
        this.jtbtnViewSource.setMaximumSize(this.jbtnAnchor.getMaximumSize());
        this.jToolBar.add(this.jtbtnViewSource);
        htTools.put(KEY_TOOL_SOURCE, this.jtbtnViewSource);
        this.jToolBar.add(new JToolBar.Separator());
        this.jcmbStyleSelector = new JComboBoxNoFocus();
        this.jToolBar.add(this.jcmbStyleSelector);
        this.jcmbStyleSelector.setAction(new StylesAction(this.jcmbStyleSelector));
        htTools.put(KEY_TOOL_STYLES, this.jcmbStyleSelector);
        JScrollPane jScrollPane = new JScrollPane(this.jtpMain);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setPreferredSize(new Dimension(400, 400));
        jScrollPane.setMinimumSize(new Dimension(32, 32));
        this.jspSource = new JScrollPane(this.jtpSource);
        this.jspSource.setPreferredSize(new Dimension(400, 100));
        this.jspSource.setMinimumSize(new Dimension(32, 32));
        this.jspltDisplay = new JSplitPane(0);
        this.jspltDisplay.setTopComponent(jScrollPane);
        if (bl) {
            this.jspltDisplay.setBottomComponent(this.jspSource);
        } else {
            this.jspltDisplay.setBottomComponent(null);
        }
        this.iSplitPos = this.jspltDisplay.getDividerLocation();
        this.registerDocumentStyles();
        this.setLayout(new BorderLayout());
        this.add((Component)this.jspltDisplay, "Center");
    }

    public EkitCore(String string, String string2, boolean bl, boolean bl2, boolean bl3, String string3, String string4, boolean bl4) {
        this(string, string2, null, null, bl, bl2, bl3, string3, string4, bl4, false, "");
    }

    public EkitCore(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(string, string2, null, null, bl, bl2, bl3, null, null, bl4, false, "");
    }

    public EkitCore(String string, URL uRL, boolean bl, boolean bl2, boolean bl3, String string2, String string3, boolean bl4, String string4) {
        this(null, null, string, uRL, bl, bl2, bl3, string2, string3, bl4, false, string4);
    }

    public EkitCore(String string, boolean bl, boolean bl2, boolean bl3, String string2, String string3, boolean bl4) {
        this(null, null, string, null, bl, bl2, bl3, string2, string3, bl4, false, "");
    }

    public EkitCore(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(null, null, string, null, bl, bl2, bl3, null, null, bl4, false, "");
    }

    public EkitCore(boolean bl, boolean bl2, boolean bl3, String string, String string2) {
        this(null, null, null, null, bl, bl2, bl3, string, string2, false, false, "");
    }

    public EkitCore(boolean bl, boolean bl2, boolean bl3) {
        this(null, null, null, null, bl, bl2, bl3, null, null, false, false, "");
    }

    public EkitCore(String string, String string2, boolean bl) {
        this(null, null, null, null, false, true, true, string, string2, false, bl, "");
    }

    public EkitCore(String string, String string2) {
        this(null, null, null, null, false, true, true, string, string2, false, false, "");
    }

    public EkitCore(boolean bl) {
        this(null, null, null, null, false, true, true, null, null, false, bl, "");
    }

    public EkitCore() {
        this(null, null, null, null, false, true, true, null, null, false, false, "");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block55: {
            try {
                String string = actionEvent.getActionCommand();
                if (string.equals("newdoc")) {
                    SimpleInfoDialog simpleInfoDialog = new SimpleInfoDialog(this.getFrame(), "", true, Translatrix.getTranslationString("AskNewDocument"), 3);
                    String string2 = simpleInfoDialog.getDecisionValue();
                    if (!string2.equals(Translatrix.getTranslationString("DialogAccept"))) break block55;
                    this.htmlDoc = this.styleSheet != null ? new ExtendedHTMLDocument(this.styleSheet) : (ExtendedHTMLDocument)this.htmlKit.createDefaultDocument();
                    this.jtpMain.setText("<HTML><BODY></BODY></HTML>");
                    this.jtpSource.setText(this.jtpMain.getText());
                    this.registerDocument(this.htmlDoc);
                    this.currentFile = null;
                    this.updateTitle();
                    break block55;
                }
                if (string.equals("openhtml")) {
                    this.openDocument(null);
                    break block55;
                }
                if (string.equals("opencss")) {
                    this.openStyleSheet(null);
                    break block55;
                }
                if (string.equals("openb64")) {
                    this.openDocumentBase64(null);
                    break block55;
                }
                if (string.equals(KEY_TOOL_SAVE)) {
                    this.writeOut((HTMLDocument)this.jtpMain.getDocument(), this.currentFile);
                    this.updateTitle();
                    break block55;
                }
                if (string.equals("saveas")) {
                    this.writeOut((HTMLDocument)this.jtpMain.getDocument(), null);
                    break block55;
                }
                if (string.equals("savebody")) {
                    this.writeOutFragment((HTMLDocument)this.jtpMain.getDocument(), "body");
                    break block55;
                }
                if (string.equals("savertf")) {
                    this.writeOutRTF(this.jtpMain.getStyledDocument());
                    break block55;
                }
                if (string.equals("saveb64")) {
                    this.writeOutBase64(this.jtpSource.getText());
                    break block55;
                }
                if (string.equals("textcut")) {
                    if (this.jspSource.isShowing() && this.jtpSource.hasFocus()) {
                        this.jtpSource.cut();
                    } else {
                        this.jtpMain.cut();
                    }
                    break block55;
                }
                if (string.equals("textcopy")) {
                    if (this.jspSource.isShowing() && this.jtpSource.hasFocus()) {
                        this.jtpSource.copy();
                    } else {
                        this.jtpMain.copy();
                    }
                    break block55;
                }
                if (string.equals("textpaste")) {
                    if (this.jspSource.isShowing() && this.jtpSource.hasFocus()) {
                        this.jtpSource.paste();
                    } else {
                        this.jtpMain.paste();
                    }
                    break block55;
                }
                if (string.equals("describe")) {
                    System.out.println("------------DOCUMENT------------");
                    System.out.println("Content Type : " + this.jtpMain.getContentType());
                    System.out.println("Editor Kit   : " + this.jtpMain.getEditorKit());
                    System.out.println("Doc Tree     :");
                    System.out.println("");
                    this.describeDocument(this.jtpMain.getStyledDocument());
                    System.out.println("--------------------------------");
                    System.out.println("");
                    break block55;
                }
                if (string.equals("describecss")) {
                    System.out.println("-----------STYLESHEET-----------");
                    System.out.println("Stylesheet Rules");
                    Enumeration<?> enumeration = this.styleSheet.getStyleNames();
                    while (enumeration.hasMoreElements()) {
                        String string3 = (String)enumeration.nextElement();
                        Style style = this.styleSheet.getStyle(string3);
                        System.out.println(style.toString());
                    }
                    System.out.println("--------------------------------");
                    System.out.println("");
                    break block55;
                }
                if (string.equals("whattags")) {
                    System.out.println("Caret Position : " + this.jtpMain.getCaretPosition());
                    AttributeSet attributeSet = this.jtpMain.getCharacterAttributes();
                    Enumeration<?> enumeration = attributeSet.getAttributeNames();
                    System.out.println("Attributes     : ");
                    while (enumeration.hasMoreElements()) {
                        String string4 = enumeration.nextElement().toString();
                        System.out.println("                 " + string4 + " | " + attributeSet.getAttribute(string4));
                    }
                    break block55;
                }
                if (string.equals("toggletoolbar")) {
                    this.jToolBar.setVisible(this.jcbmiViewToolbar.isSelected());
                    break block55;
                }
                if (string.equals(KEY_TOOL_SOURCE)) {
                    this.toggleSourceWindow();
                    break block55;
                }
                if (string.equals("serialize")) {
                    this.serializeOut((HTMLDocument)this.jtpMain.getDocument());
                    break block55;
                }
                if (string.equals("readfromser")) {
                    this.serializeIn();
                    break block55;
                }
                if (string.equals("inserttable")) {
                    String[] stringArray = new String[]{"rows", "cols", "border", "cellspacing", "cellpadding", "width"};
                    String[] stringArray2 = new String[]{"text", "text", "text", "text", "text", "text"};
                    this.insertTable(null, stringArray, stringArray2);
                    break block55;
                }
                if (string.equals("inserttablerow")) {
                    this.insertTableRow();
                    break block55;
                }
                if (string.equals("inserttablecolumn")) {
                    this.insertTableColumn();
                    break block55;
                }
                if (string.equals("deletetablerow")) {
                    this.deleteTableRow();
                    break block55;
                }
                if (string.equals("deletetablecolumn")) {
                    this.deleteTableColumn();
                    break block55;
                }
                if (string.equals("insertbreak")) {
                    this.insertBreak();
                    break block55;
                }
                if (string.equals("insertlocalimage")) {
                    this.insertLocalImage(null);
                    break block55;
                }
                if (string.equals("insertserverimage")) {
                    this.insertServerImage();
                    break block55;
                }
                if (string.equals("insertnbsp")) {
                    this.insertNonbreakingSpace();
                    break block55;
                }
                if (string.equals("insertform")) {
                    String[] stringArray = new String[]{"name", "method", "enctype"};
                    String[] stringArray3 = new String[]{"text", "combo", "text"};
                    String[] stringArray4 = new String[]{"", "POST,GET", "text"};
                    this.insertFormElement(HTML.Tag.FORM, "form", null, stringArray, stringArray3, stringArray4, true);
                    break block55;
                }
                if (string.equals("inserttextfield")) {
                    Hashtable<String, String> hashtable = new Hashtable<String, String>();
                    hashtable.put("type", "text");
                    String[] stringArray = new String[]{"name", "value", "size", "maxlength"};
                    String[] stringArray5 = new String[]{"text", "text", "text", "text"};
                    this.insertFormElement(HTML.Tag.INPUT, "input", hashtable, stringArray, stringArray5, false);
                    break block55;
                }
                if (string.equals("inserttextarea")) {
                    String[] stringArray = new String[]{"name", "rows", "cols"};
                    String[] stringArray6 = new String[]{"text", "text", "text"};
                    this.insertFormElement(HTML.Tag.TEXTAREA, "textarea", null, stringArray, stringArray6, true);
                    break block55;
                }
                if (string.equals("insertcheckbox")) {
                    Hashtable<String, String> hashtable = new Hashtable<String, String>();
                    hashtable.put("type", "checkbox");
                    String[] stringArray = new String[]{"name", "checked"};
                    String[] stringArray7 = new String[]{"text", "bool"};
                    this.insertFormElement(HTML.Tag.INPUT, "input", hashtable, stringArray, stringArray7, false);
                    break block55;
                }
                if (string.equals("insertradiobutton")) {
                    Hashtable<String, String> hashtable = new Hashtable<String, String>();
                    hashtable.put("type", "radio");
                    String[] stringArray = new String[]{"name", "checked"};
                    String[] stringArray8 = new String[]{"text", "bool"};
                    this.insertFormElement(HTML.Tag.INPUT, "input", hashtable, stringArray, stringArray8, false);
                    break block55;
                }
                if (string.equals("insertpassword")) {
                    Hashtable<String, String> hashtable = new Hashtable<String, String>();
                    hashtable.put("type", "password");
                    String[] stringArray = new String[]{"name", "value", "size", "maxlength"};
                    String[] stringArray9 = new String[]{"text", "text", "text", "text"};
                    this.insertFormElement(HTML.Tag.INPUT, "input", hashtable, stringArray, stringArray9, false);
                    break block55;
                }
                if (string.equals("insertbutton")) {
                    Hashtable<String, String> hashtable = new Hashtable<String, String>();
                    hashtable.put("type", "button");
                    String[] stringArray = new String[]{"name", "value"};
                    String[] stringArray10 = new String[]{"text", "text"};
                    this.insertFormElement(HTML.Tag.INPUT, "input", hashtable, stringArray, stringArray10, false);
                    break block55;
                }
                if (string.equals("insertbuttonsubmit")) {
                    Hashtable<String, String> hashtable = new Hashtable<String, String>();
                    hashtable.put("type", "submit");
                    String[] stringArray = new String[]{"name", "value"};
                    String[] stringArray11 = new String[]{"text", "text"};
                    this.insertFormElement(HTML.Tag.INPUT, "input", hashtable, stringArray, stringArray11, false);
                    break block55;
                }
                if (string.equals("insertbuttonreset")) {
                    Hashtable<String, String> hashtable = new Hashtable<String, String>();
                    hashtable.put("type", "reset");
                    String[] stringArray = new String[]{"name", "value"};
                    String[] stringArray12 = new String[]{"text", "text"};
                    this.insertFormElement(HTML.Tag.INPUT, "input", hashtable, stringArray, stringArray12, false);
                    break block55;
                }
                if (string.equals("find")) {
                    this.doSearch(null, null, false, this.lastSearchCaseSetting, this.lastSearchTopSetting);
                    break block55;
                }
                if (string.equals("findagain")) {
                    this.doSearch(this.lastSearchFindTerm, null, false, this.lastSearchCaseSetting, false);
                    break block55;
                }
                if (string.equals("replace")) {
                    this.doSearch(null, null, true, this.lastSearchCaseSetting, this.lastSearchTopSetting);
                    break block55;
                }
                if (string.equals("exit")) {
                    this.dispose();
                    break block55;
                }
                if (!string.equals("helpabout")) break block55;
                SimpleInfoDialog simpleInfoDialog = new SimpleInfoDialog(this.getFrame(), Translatrix.getTranslationString("About"), true, Translatrix.getTranslationString("AboutMessage"), 1);
            }
            catch (IOException iOException) {
                this.logException("IOException in actionPerformed method", iOException);
                SimpleInfoDialog simpleInfoDialog = new SimpleInfoDialog(this.getFrame(), Translatrix.getTranslationString("Error"), true, Translatrix.getTranslationString("ErrorIOException"), 0);
            }
            catch (BadLocationException badLocationException) {
                this.logException("BadLocationException in actionPerformed method", badLocationException);
                SimpleInfoDialog simpleInfoDialog = new SimpleInfoDialog(this.getFrame(), Translatrix.getTranslationString("Error"), true, Translatrix.getTranslationString("ErrorBadLocationException"), 0);
            }
            catch (NumberFormatException numberFormatException) {
                this.logException("NumberFormatException in actionPerformed method", numberFormatException);
                SimpleInfoDialog simpleInfoDialog = new SimpleInfoDialog(this.getFrame(), Translatrix.getTranslationString("Error"), true, Translatrix.getTranslationString("ErrorNumberFormatException"), 0);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.logException("ClassNotFound Exception in actionPerformed method", classNotFoundException);
                SimpleInfoDialog simpleInfoDialog = new SimpleInfoDialog(this.getFrame(), Translatrix.getTranslationString("Error"), true, Translatrix.getTranslationString("ErrorClassNotFoundException "), 0);
            }
            catch (RuntimeException runtimeException) {
                this.logException("RuntimeException in actionPerformed method", runtimeException);
                SimpleInfoDialog simpleInfoDialog = new SimpleInfoDialog(this.getFrame(), Translatrix.getTranslationString("Error"), true, Translatrix.getTranslationString("ErrorRuntimeException"), 0);
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        block23: {
            int n;
            int n2;
            block24: {
                n2 = this.getCaretPosition();
                n = -1;
                if (keyEvent.getKeyChar() != '\b') break block24;
                try {
                    if (n2 > 0) {
                        String string = this.jtpMain.getSelectedText();
                        if (string != null) {
                            this.htmlUtilities.delete();
                            return;
                        }
                        int n3 = this.htmlDoc.getParagraphElement(n2).getStartOffset();
                        if (n3 == this.jtpMain.getSelectionStart()) {
                            boolean bl = true;
                            if (this.htmlUtilities.checkParentsTag(HTML.Tag.LI)) {
                                Object object;
                                int n4;
                                Element element = this.htmlUtilities.getListItemParent();
                                bl = false;
                                int n5 = element.getStartOffset();
                                if (n5 + 1 < (n4 = element.getEndOffset())) {
                                    object = this.jtpMain.getText(n5, n4 - n5).toCharArray();
                                    int n6 = 0;
                                    while (n6 < ((Object)object).length) {
                                        new Character((char)object[n6]);
                                        if (!Character.isWhitespace((char)object[n6])) {
                                            bl = true;
                                        }
                                        ++n6;
                                    }
                                }
                                if (!bl) {
                                    object = element.getParentElement();
                                    this.htmlUtilities.removeTag(element, true);
                                    this.setCaretPosition(n3 - 1);
                                    return;
                                }
                                this.jtpMain.setCaretPosition(this.jtpMain.getCaretPosition() - 1);
                                this.jtpMain.moveCaretPosition(this.jtpMain.getCaretPosition() - 2);
                                this.jtpMain.replaceSelection("");
                                return;
                            }
                            if (this.htmlUtilities.checkParentsTag(HTML.Tag.TABLE)) {
                                this.jtpMain.setCaretPosition(this.jtpMain.getCaretPosition() - 1);
                                keyEvent.consume();
                                return;
                            }
                        }
                        this.jtpMain.replaceSelection("");
                        return;
                    }
                    break block23;
                }
                catch (BadLocationException badLocationException) {
                    this.logException("BadLocationException in keyTyped method", badLocationException);
                    SimpleInfoDialog simpleInfoDialog = new SimpleInfoDialog(this.getFrame(), Translatrix.getTranslationString("Error"), true, Translatrix.getTranslationString("ErrorBadLocationException"), 0);
                }
                catch (IOException iOException) {
                    this.logException("IOException in keyTyped method", iOException);
                    SimpleInfoDialog simpleInfoDialog = new SimpleInfoDialog(this.getFrame(), Translatrix.getTranslationString("Error"), true, Translatrix.getTranslationString("ErrorIOException"), 0);
                }
                break block23;
            }
            if (keyEvent.getKeyChar() != '\n') break block23;
            try {
                int n7;
                if (!(this.htmlUtilities.checkParentsTag(HTML.Tag.UL) | this.htmlUtilities.checkParentsTag(HTML.Tag.OL))) break block23;
                Element element = this.htmlUtilities.getListItemParent();
                int n8 = element.getStartOffset();
                int n9 = element.getEndOffset();
                char[] cArray = this.getTextPane().getText(n8, n9 - n8).toCharArray();
                boolean bl = false;
                int n10 = 0;
                while (n10 < cArray.length) {
                    new Character(cArray[n10]);
                    if (!Character.isWhitespace(cArray[n10])) {
                        bl = true;
                    }
                    ++n10;
                }
                if (bl) {
                    n7 = -1;
                    int n11 = cArray.length;
                    do {
                        new Character(cArray[--n11]);
                        if (!Character.isLetterOrDigit(cArray[n11])) continue;
                        n7 = n11;
                    } while (n7 == -1 && n11 >= 0);
                    n11 = n7;
                    do {
                        new Character(cArray[++n11]);
                        if (Character.isSpaceChar(cArray[n11])) continue;
                        n = n11 - n7 - 1;
                    } while (n == -1 && n11 < cArray.length);
                    if (n == -1) {
                        n = 0;
                    }
                }
                if (element.getStartOffset() == element.getEndOffset() || !bl) {
                    this.manageListElement(element);
                    break block23;
                }
                if (this.getCaretPosition() + 1 == element.getEndOffset()) {
                    this.insertListStyle(element);
                    this.setCaretPosition(n2 - n);
                    break block23;
                }
                n7 = this.getCaretPosition();
                String string = this.getTextPane().getText(n7, n9 - n7);
                this.getTextPane().select(n7, n9 - 1);
                this.getTextPane().replaceSelection("");
                this.htmlUtilities.insertListElement(string);
                Element element2 = this.htmlUtilities.getListItemParent();
                this.setCaretPosition(element2.getEndOffset() - 1);
            }
            catch (BadLocationException badLocationException) {
                this.logException("BadLocationException in keyTyped method", badLocationException);
                SimpleInfoDialog simpleInfoDialog = new SimpleInfoDialog(this.getFrame(), Translatrix.getTranslationString("Error"), true, Translatrix.getTranslationString("ErrorBadLocationException"), 0);
            }
            catch (IOException iOException) {
                this.logException("IOException in keyTyped method", iOException);
                SimpleInfoDialog simpleInfoDialog = new SimpleInfoDialog(this.getFrame(), Translatrix.getTranslationString("Error"), true, Translatrix.getTranslationString("ErrorIOException"), 0);
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void insertListStyle(Element element) throws BadLocationException, IOException {
        if (element.getParentElement().getName() == "ol") {
            this.actionListOrdered.actionPerformed(new ActionEvent(new Object(), 0, "newListPoint"));
        } else {
            this.actionListUnordered.actionPerformed(new ActionEvent(new Object(), 0, "newListPoint"));
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.handleDocumentChange(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.handleDocumentChange(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.handleDocumentChange(documentEvent);
    }

    public void handleDocumentChange(DocumentEvent documentEvent) {
        if (!this.exclusiveEdit && this.jspSource.isShowing()) {
            if (documentEvent.getDocument() instanceof HTMLDocument || documentEvent.getDocument() instanceof ExtendedHTMLDocument) {
                this.jtpSource.getDocument().removeDocumentListener(this);
                this.jtpSource.setText(this.jtpMain.getText());
                this.jtpSource.getDocument().addDocumentListener(this);
            } else if (documentEvent.getDocument() instanceof PlainDocument || documentEvent.getDocument() instanceof DefaultStyledDocument) {
                this.jtpMain.getDocument().removeDocumentListener(this);
                this.jtpMain.setText(this.jtpSource.getText());
                this.jtpMain.getDocument().addDocumentListener(this);
            }
        }
    }

    public void registerDocument(ExtendedHTMLDocument extendedHTMLDocument) {
        this.jtpMain.setDocument(extendedHTMLDocument);
        this.jtpMain.getDocument().addUndoableEditListener(new CustomUndoableEditListener());
        this.jtpMain.getDocument().addDocumentListener(this);
        this.purgeUndos();
        this.registerDocumentStyles();
    }

    public void registerDocumentStyles() {
        if (this.jcmbStyleSelector == null || this.htmlDoc == null) {
            return;
        }
        this.jcmbStyleSelector.setEnabled(false);
        this.jcmbStyleSelector.removeAllItems();
        this.jcmbStyleSelector.addItem(Translatrix.getTranslationString("NoCSSStyle"));
        Enumeration<?> enumeration = this.htmlDoc.getStyleNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.length() <= 0 || string.charAt(0) != '.') continue;
            this.jcmbStyleSelector.addItem(string.substring(1));
        }
        this.jcmbStyleSelector.setEnabled(true);
    }

    private void insertTable(Hashtable hashtable, String[] stringArray, String[] stringArray2) throws IOException, BadLocationException, RuntimeException, NumberFormatException {
        Object object;
        int n = this.jtpMain.getCaretPosition();
        StringBuffer stringBuffer = new StringBuffer("<TABLE");
        if (hashtable != null && hashtable.size() > 0) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                object = hashtable.get(k);
                if (object == null || object == "") continue;
                stringBuffer.append(" " + k + "=" + '\"' + object + '\"');
            }
        }
        int n2 = 0;
        int n3 = 0;
        if (stringArray != null && stringArray.length > 0) {
            object = new PropertiesDialog(this.getFrame(), stringArray, stringArray2, Translatrix.getTranslationString("FormDialogTitle"), true);
            ((Dialog)object).show();
            String string = ((PropertiesDialog)object).getDecisionValue();
            if (string.equals(Translatrix.getTranslationString("DialogCancel"))) {
                ((Window)object).dispose();
                object = null;
                return;
            }
            int n4 = 0;
            while (n4 < stringArray.length) {
                String string2 = stringArray[n4];
                String string3 = ((PropertiesDialog)object).getFieldValue(string2);
                if (string3 != null && string3 != "" && string3.length() > 0) {
                    if (string2.equals("rows")) {
                        n2 = Integer.parseInt(string3);
                    } else if (string2.equals("cols")) {
                        n3 = Integer.parseInt(string3);
                    } else {
                        stringBuffer.append(" " + string2 + "=" + '\"' + string3 + '\"');
                    }
                }
                ++n4;
            }
            ((Window)object).dispose();
            object = null;
        }
        stringBuffer.append(">");
        int n5 = 0;
        while (n5 < n2) {
            stringBuffer.append("<TR>");
            int n6 = 0;
            while (n6 < n3) {
                stringBuffer.append("<TD></TD>");
                ++n6;
            }
            stringBuffer.append("</TR>");
            ++n5;
        }
        stringBuffer.append("</TABLE><P>&nbsp;<P>");
        this.htmlKit.insertHTML(this.htmlDoc, n, stringBuffer.toString(), 0, 0, HTML.Tag.TABLE);
        this.jtpMain.setCaretPosition(n + 1);
        this.refreshOnUpdate();
    }

    private void insertTableRow() {
        int n = this.jtpMain.getCaretPosition();
        Element element = this.htmlDoc.getCharacterElement(this.jtpMain.getCaretPosition());
        Element element2 = element.getParentElement();
        int n2 = -1;
        int n3 = -1;
        while (element2 != null && !element2.getName().equals("body")) {
            if (element2.getName().equals("tr")) {
                n2 = element2.getStartOffset();
                n3 = element2.getElementCount();
                break;
            }
            element2 = element2.getParentElement();
        }
        if (n2 > -1 && n3 > -1) {
            this.jtpMain.setCaretPosition(n2);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<TR>");
            int n4 = 0;
            while (n4 < n3) {
                stringBuffer.append("<TD></TD>");
                ++n4;
            }
            stringBuffer.append("</TR>");
            ActionEvent actionEvent = new ActionEvent(this.jtpMain, 0, "insertTableRow");
            new HTMLEditorKit.InsertHTMLTextAction("insertTableRow", stringBuffer.toString(), HTML.Tag.TABLE, HTML.Tag.TR).actionPerformed(actionEvent);
            this.refreshOnUpdate();
            this.jtpMain.setCaretPosition(n);
        }
    }

    private void insertTableColumn() {
        Element element;
        int n;
        int n2 = this.jtpMain.getCaretPosition();
        Element element2 = this.htmlDoc.getCharacterElement(this.jtpMain.getCaretPosition());
        Element element3 = element2.getParentElement();
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        while (element3 != null && !element3.getName().equals("body")) {
            if (element3.getName().equals(KEY_MENU_TABLE)) {
                n3 = element3.getStartOffset();
                n4 = element3.getElementCount();
                break;
            }
            if (element3.getName().equals("tr")) {
                int n6 = element3.getStartOffset();
                int n7 = element3.getElementCount();
                n = 0;
                while (n < n7) {
                    element = element3.getElement(n);
                    if (this.jtpMain.getCaretPosition() >= element.getStartOffset() && this.jtpMain.getCaretPosition() <= element.getEndOffset()) {
                        n5 = n;
                    }
                    ++n;
                }
                element3 = element3.getParentElement();
                continue;
            }
            element3 = element3.getParentElement();
        }
        if (n3 > -1 && n4 > -1) {
            this.jtpMain.setCaretPosition(n3);
            String string = "<TD></TD>";
            ActionEvent actionEvent = new ActionEvent(this.jtpMain, 0, "insertTableCell");
            n = 0;
            while (n < n4) {
                element = element3.getElement(n);
                Element element4 = element.getElement(n5);
                this.jtpMain.setCaretPosition(element4.getStartOffset());
                new HTMLEditorKit.InsertHTMLTextAction("insertTableCell", string, HTML.Tag.TR, HTML.Tag.TD, HTML.Tag.TH, HTML.Tag.TD).actionPerformed(actionEvent);
                ++n;
            }
            this.refreshOnUpdate();
            this.jtpMain.setCaretPosition(n2);
        }
    }

    private void insertTableCell() {
        String string = "<TD></TD>";
        ActionEvent actionEvent = new ActionEvent(this.jtpMain, 0, "insertTableCell");
        new HTMLEditorKit.InsertHTMLTextAction("insertTableCell", string, HTML.Tag.TR, HTML.Tag.TD, HTML.Tag.TH, HTML.Tag.TD).actionPerformed(actionEvent);
        this.refreshOnUpdate();
    }

    private void deleteTableRow() throws BadLocationException {
        int n = this.jtpMain.getCaretPosition();
        Element element = this.htmlDoc.getCharacterElement(this.jtpMain.getCaretPosition());
        Element element2 = element.getParentElement();
        int n2 = -1;
        int n3 = -1;
        while (element2 != null && !element2.getName().equals("body")) {
            if (element2.getName().equals("tr")) {
                n2 = element2.getStartOffset();
                n3 = element2.getEndOffset();
                break;
            }
            element2 = element2.getParentElement();
        }
        if (n2 > -1 && n3 > n2) {
            this.htmlDoc.remove(n2, n3 - n2);
            this.jtpMain.setDocument(this.htmlDoc);
            this.registerDocument(this.htmlDoc);
            this.refreshOnUpdate();
            if (n >= this.htmlDoc.getLength()) {
                n = this.htmlDoc.getLength() - 1;
            }
            this.jtpMain.setCaretPosition(n);
        }
    }

    private void deleteTableColumn() throws BadLocationException {
        int n = this.jtpMain.getCaretPosition();
        Element element = this.htmlDoc.getCharacterElement(this.jtpMain.getCaretPosition());
        Element element2 = element.getParentElement();
        Element element3 = null;
        Element element4 = null;
        Element element5 = null;
        while (element2 != null && !element2.getName().equals("body")) {
            if (element2.getName().equals("td")) {
                element3 = element2;
            } else if (element2.getName().equals("tr")) {
                element4 = element2;
            } else if (element2.getName().equals(KEY_MENU_TABLE)) {
                element5 = element2;
            }
            element2 = element2.getParentElement();
        }
        int n2 = -1;
        if (element3 != null && element4 != null && element5 != null) {
            int n3 = 0;
            while (n3 < element4.getElementCount()) {
                if (element3 == element4.getElement(n3)) {
                    n2 = n3;
                }
                ++n3;
            }
            if (n2 > -1) {
                int n4 = 0;
                while (n4 < element5.getElementCount()) {
                    element4 = element5.getElement(n4);
                    element3 = element4.getElementCount() > n2 ? element4.getElement(n2) : element4.getElement(element4.getElementCount() - 1);
                    int n5 = element3.getStartOffset();
                    int n6 = element3.getEndOffset();
                    this.htmlDoc.remove(n5, n6 - n5);
                    ++n4;
                }
                this.jtpMain.setDocument(this.htmlDoc);
                this.registerDocument(this.htmlDoc);
                this.refreshOnUpdate();
                if (n >= this.htmlDoc.getLength()) {
                    n = this.htmlDoc.getLength() - 1;
                }
                this.jtpMain.setCaretPosition(n);
            }
        }
    }

    private void insertBreak() throws IOException, BadLocationException, RuntimeException {
        int n = this.jtpMain.getCaretPosition();
        this.htmlKit.insertHTML(this.htmlDoc, n, "<BR>", 0, 0, HTML.Tag.BR);
        this.jtpMain.setCaretPosition(n + 1);
    }

    private void insertNonbreakingSpace() throws IOException, BadLocationException, RuntimeException {
        int n = this.jtpMain.getCaretPosition();
        this.htmlDoc.insertString(n, "\u00a0", this.jtpMain.getInputAttributes());
        this.jtpMain.setCaretPosition(n + 1);
    }

    private void insertFormElement(HTML.Tag tag, String string, Hashtable hashtable, String[] stringArray, String[] stringArray2, String[] stringArray3, boolean bl) throws IOException, BadLocationException, RuntimeException {
        Object object;
        Object object2;
        int n = this.jtpMain.getCaretPosition();
        StringBuffer stringBuffer = new StringBuffer("<" + string);
        if (hashtable != null && hashtable.size() > 0) {
            object2 = hashtable.keys();
            while (object2.hasMoreElements()) {
                object = object2.nextElement();
                Object v = hashtable.get(object);
                if (v == null || v == "") continue;
                stringBuffer.append(" " + object + "=" + '\"' + v + '\"');
            }
        }
        if (stringArray != null && stringArray.length > 0) {
            object2 = new PropertiesDialog(this.getFrame(), stringArray, stringArray2, stringArray3, Translatrix.getTranslationString("FormDialogTitle"), true);
            ((Dialog)object2).show();
            object = ((PropertiesDialog)object2).getDecisionValue();
            if (((String)object).equals(Translatrix.getTranslationString("DialogCancel"))) {
                ((Window)object2).dispose();
                object2 = null;
                return;
            }
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string2 = stringArray[n2];
                String string3 = ((PropertiesDialog)object2).getFieldValue(string2);
                if (string3 != null && string3.length() > 0) {
                    if (string2.equals("checked")) {
                        if (string3.equals("true")) {
                            stringBuffer.append(" " + string2 + "=" + '\"' + string3 + '\"');
                        }
                    } else {
                        stringBuffer.append(" " + string2 + "=" + '\"' + string3 + '\"');
                    }
                }
                ++n2;
            }
            ((Window)object2).dispose();
            object2 = null;
        }
        if (string.equals("form")) {
            stringBuffer.append(" bgcolor=\"#cccccc\"");
        }
        stringBuffer.append(">");
        if (bl) {
            stringBuffer.append("</" + string + ">");
        }
        if (tag == HTML.Tag.FORM) {
            stringBuffer.append("<P>&nbsp;</P>");
        }
        this.htmlKit.insertHTML(this.htmlDoc, n, stringBuffer.toString(), 0, 0, tag);
        this.refreshOnUpdate();
    }

    private void insertFormElement(HTML.Tag tag, String string, Hashtable hashtable, String[] stringArray, String[] stringArray2, boolean bl) throws IOException, BadLocationException, RuntimeException {
        this.insertFormElement(tag, string, hashtable, stringArray, stringArray2, new String[stringArray.length], bl);
    }

    public void manageListElement(Element element) {
        Element element2 = this.htmlUtilities.getListItemParent();
        Element element3 = element2.getParentElement();
        if (element2 != null) {
            this.htmlUtilities.removeTag(element2, true);
        }
    }

    private void doSearch(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = false;
        JTextPane jTextPane = this.jtpMain;
        if (this.jspSource.isShowing() || this.jtpSource.hasFocus()) {
            jTextPane = this.jtpSource;
        }
        if (string == null || bl && string2 == null) {
            SearchDialog searchDialog = new SearchDialog(this.getFrame(), Translatrix.getTranslationString("SearchDialogTitle"), true, bl, bl2, bl3);
            string = searchDialog.getFindTerm();
            string2 = searchDialog.getReplaceTerm();
            bl2 = searchDialog.getCaseSensitive();
            bl3 = searchDialog.getStartAtTop();
            bl4 = searchDialog.getReplaceAll();
        }
        if (!(string == null || bl && string2 == null)) {
            if (bl4) {
                int n = this.findText(string, string2, bl2, 0);
                int n2 = 0;
                if (n > -1) {
                    while (n > -1) {
                        n = this.findText(string, string2, bl2, n2 += string2.length());
                    }
                } else {
                    SimpleInfoDialog simpleInfoDialog = new SimpleInfoDialog(this.getFrame(), "", true, Translatrix.getTranslationString("ErrorNoOccurencesFound") + ":\n" + string, 2);
                }
            } else {
                int n = this.findText(string, string2, bl2, bl3 ? 0 : jTextPane.getCaretPosition());
                if (n == -1) {
                    SimpleInfoDialog simpleInfoDialog = new SimpleInfoDialog(this.getFrame(), "", true, Translatrix.getTranslationString("ErrorNoMatchFound") + ":\n" + string, 2);
                }
            }
            this.lastSearchFindTerm = new String(string);
            this.lastSearchReplaceTerm = string2 != null ? new String(string2) : (String)null;
            this.lastSearchCaseSetting = bl2;
            this.lastSearchTopSetting = bl3;
        }
    }

    private int findText(String string, String string2, boolean bl, int n) {
        int n2;
        block4: {
            JTextPane jTextPane = this.jspSource.isShowing() || this.jtpSource.hasFocus() ? this.jtpSource : this.jtpMain;
            n2 = -1;
            try {
                Document document = jTextPane.getDocument();
                int n3 = n2 = bl ? document.getText(0, document.getLength()).indexOf(string, n) : document.getText(0, document.getLength()).toLowerCase().indexOf(string.toLowerCase(), n);
                if (n2 <= -1) break block4;
                if (string2 != null) {
                    AttributeSet attributeSet = null;
                    if (document instanceof HTMLDocument) {
                        Element element = ((HTMLDocument)document).getCharacterElement(n2);
                        attributeSet = element.getAttributes();
                    }
                    document.remove(n2, string.length());
                    document.insertString(n2, string2, attributeSet);
                    jTextPane.setCaretPosition(n2 + string2.length());
                    jTextPane.requestFocus();
                    jTextPane.select(n2, n2 + string2.length());
                    break block4;
                }
                jTextPane.setCaretPosition(n2 + string.length());
                jTextPane.requestFocus();
                jTextPane.select(n2, n2 + string.length());
            }
            catch (BadLocationException badLocationException) {
                this.logException("BadLocationException in actionPerformed method", badLocationException);
                SimpleInfoDialog simpleInfoDialog = new SimpleInfoDialog(this.getFrame(), Translatrix.getTranslationString("Error"), true, Translatrix.getTranslationString("ErrorBadLocationException"), 0);
            }
        }
        return n2;
    }

    private void insertLocalImage(File file) throws IOException, BadLocationException, RuntimeException {
        if (file == null) {
            file = this.getImageFromChooser(".", this.extsIMG, Translatrix.getTranslationString("FiletypeIMG"));
        }
        if (file != null) {
            int n = this.jtpMain.getCaretPosition();
            this.htmlKit.insertHTML(this.htmlDoc, n, "<IMG SRC=\"" + file + "\">", 0, 0, HTML.Tag.IMG);
            this.jtpMain.setCaretPosition(n + 1);
            this.refreshOnUpdate();
        }
    }

    private void insertServerImage() throws BadLocationException {
        block5: {
            if (this.ServletURL == null) break block5;
            try {
                URL uRL = new URL(this.ServletURL + "?GetImages=" + this.TreePilotSystemID + "&ImageExtensions=" + TreePilotProperties.getString("ValidImageExtensions"));
                URLConnection uRLConnection = uRL.openConnection();
                ObjectInputStream objectInputStream = new ObjectInputStream(uRLConnection.getInputStream());
                String[] stringArray = (String[])objectInputStream.readObject();
                int n = this.jtpMain.getCaretPosition();
                ImageDialog imageDialog = new ImageDialog(this, this.ImageDir + this.TreePilotSystemID, stringArray, "Image Chooser", true);
                String string = imageDialog.getSelectedImage();
                imageDialog.dispose();
                if (string != null && !string.equals("")) {
                    this.htmlKit.insertHTML(this.htmlDoc, n, string, 0, 0, HTML.Tag.IMG);
                    this.jtpMain.setCaretPosition(n + 1);
                }
                this.jtpMain.requestFocus();
                objectInputStream.close();
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("MalFormedURLException during insertImage " + malformedURLException);
            }
            catch (IOException iOException) {
                System.err.println("IOException during insertImage " + iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("ClassNotFoundException during insertImage" + classNotFoundException);
            }
        }
    }

    public String insertFile() {
        String string;
        block4: {
            string = null;
            if (this.ServletURL == null) break block4;
            try {
                URL uRL = new URL(this.ServletURL + "?GetFiles=" + this.TreePilotSystemID + "&FileExtensions=" + TreePilotProperties.getString("ValidFileExtensions"));
                URLConnection uRLConnection = uRL.openConnection();
                ObjectInputStream objectInputStream = new ObjectInputStream(uRLConnection.getInputStream());
                String[] stringArray = (String[])objectInputStream.readObject();
                FileDialog fileDialog = new FileDialog(this, this.ImageDir + this.TreePilotSystemID, stringArray, "File Chooser", true);
                string = fileDialog.getSelectedFile();
                fileDialog.dispose();
                objectInputStream.close();
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("MalFormedURLException during insertFile " + malformedURLException);
            }
            catch (IOException iOException) {
                System.err.println("IOException during insertFile " + iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("ClassNotFoundException during insertFile" + classNotFoundException);
            }
        }
        return string;
    }

    private void writeOut(HTMLDocument hTMLDocument, File file) throws IOException, BadLocationException {
        if (file == null) {
            file = this.getFileFromChooser(".", 1, this.extsHTML, Translatrix.getTranslationString("FiletypeHTML"));
        }
        if (file != null) {
            FileWriter fileWriter = new FileWriter(file);
            this.htmlKit.write(fileWriter, (Document)hTMLDocument, 0, hTMLDocument.getLength());
            fileWriter.flush();
            fileWriter.close();
            this.currentFile = file;
            this.updateTitle();
        }
        this.refreshOnUpdate();
    }

    private void writeOutFragment(HTMLDocument hTMLDocument, String string) throws IOException, BadLocationException {
        File file = this.getFileFromChooser(".", 1, this.extsHTML, Translatrix.getTranslationString("FiletypeHTML"));
        if (file != null) {
            FileWriter fileWriter = new FileWriter(file);
            String string2 = this.jtpSource.getText().toLowerCase();
            int n = string2.indexOf("<" + string.toLowerCase());
            int n2 = string2.indexOf(">", n) + 1;
            String string3 = "</" + string.toLowerCase() + ">";
            int n3 = string2.indexOf(string3);
            if (n2 < 0) {
                n2 = 0;
            }
            if (n3 < 0 || n3 > string2.length()) {
                n3 = string2.length();
            }
            String string4 = this.jtpSource.getText().substring(n2, n3);
            fileWriter.write(string4, 0, string4.length());
            fileWriter.flush();
            fileWriter.close();
        }
        this.refreshOnUpdate();
    }

    private void writeOutRTF(StyledDocument styledDocument) throws IOException, BadLocationException {
        File file = this.getFileFromChooser(".", 1, this.extsRTF, Translatrix.getTranslationString("FiletypeRTF"));
        if (file != null) {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            RTFEditorKit rTFEditorKit = new RTFEditorKit();
            rTFEditorKit.write(fileOutputStream, (Document)styledDocument, 0, styledDocument.getLength());
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        this.refreshOnUpdate();
    }

    private void writeOutBase64(String string) throws IOException, BadLocationException {
        File file = this.getFileFromChooser(".", 1, this.extsB64, Translatrix.getTranslationString("FiletypeB64"));
        if (file != null) {
            String string2 = Base64Codec.encode(string);
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(string2, 0, string2.length());
            fileWriter.flush();
            fileWriter.close();
        }
        this.refreshOnUpdate();
    }

    /*
     * Unable to fully structure code
     */
    private void openDocument(File var1_1) throws IOException, BadLocationException {
        block5: {
            if (var1_1 == null) {
                var1_1 = this.getFileFromChooser(".", 0, this.extsHTML, Translatrix.getTranslationString("FiletypeHTML"));
            }
            if (var1_1 == null) break block5;
            try {
                this.loadDocument(var1_1, null);
            }
            catch (ChangedCharSetException var2_2) {
                var3_3 = var2_2.getCharSetSpec().toLowerCase();
                var4_4 = var3_3.indexOf("charset");
                if (var4_4 == -1) {
                    throw var2_2;
                }
                ** GOTO lbl14
            }
lbl-1000:
            // 1 sources

            {
                ++var4_4;
lbl14:
                // 2 sources

                ** while (var4_4 < var3_3.length() && var3_3.charAt((int)var4_4) != '=')
            }
lbl15:
            // 1 sources

            var5_5 = var3_3.substring(++var4_4).trim();
            this.loadDocument(var1_1, var5_5);
        }
        this.refreshOnUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadDocument(File file, String string) throws IOException, BadLocationException {
        Reader reader = null;
        this.htmlDoc = (ExtendedHTMLDocument)this.htmlKit.createDefaultDocument();
        try {
            if (string == null) {
                reader = new InputStreamReader(new FileInputStream(file));
            } else {
                reader = new InputStreamReader((InputStream)new FileInputStream(file), string);
                this.htmlDoc.putProperty("IgnoreCharsetDirective", new Boolean(true));
            }
            this.htmlKit.read(reader, (Document)this.htmlDoc, 0);
            reader.close();
            this.registerDocument(this.htmlDoc);
            this.jtpSource.setText(this.jtpMain.getText());
            this.currentFile = file;
            this.updateTitle();
            Object var5_4 = null;
            if (reader == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (reader == null) throw throwable;
            reader.close();
            throw throwable;
        }
        reader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void openDocumentBase64(File file) throws IOException, BadLocationException {
        if (file == null) {
            file = this.getFileFromChooser(".", 0, this.extsB64, Translatrix.getTranslationString("FiletypeB64"));
        }
        if (file == null) return;
        FileReader fileReader = new FileReader(file);
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            while ((n = fileReader.read()) != -1) {
                stringBuffer.append((char)n);
            }
            fileReader.close();
            this.jtpSource.setText(Base64Codec.decode(stringBuffer.toString()));
            this.jtpMain.setText(this.jtpSource.getText());
            this.registerDocument((ExtendedHTMLDocument)this.jtpMain.getDocument());
            Object var6_5 = null;
            if (fileReader == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (fileReader == null) throw throwable;
            fileReader.close();
            throw throwable;
        }
        fileReader.close();
    }

    private void openStyleSheet(File file) throws IOException {
        if (file == null) {
            file = this.getFileFromChooser(".", 0, this.extsCSS, Translatrix.getTranslationString("FiletypeCSS"));
        }
        if (file != null) {
            String string = this.jtpMain.getText();
            this.htmlDoc = (ExtendedHTMLDocument)this.htmlKit.createDefaultDocument();
            this.styleSheet = this.htmlDoc.getStyleSheet();
            URL uRL = file.toURL();
            InputStream inputStream = uRL.openStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            this.styleSheet.loadRules(bufferedReader, uRL);
            bufferedReader.close();
            this.htmlDoc = new ExtendedHTMLDocument(this.styleSheet);
            this.registerDocument(this.htmlDoc);
            this.jtpMain.setText(string);
            this.jtpSource.setText(this.jtpMain.getText());
        }
        this.refreshOnUpdate();
    }

    public void serializeOut(HTMLDocument hTMLDocument) throws IOException {
        File file = this.getFileFromChooser(".", 1, this.extsSer, Translatrix.getTranslationString("FiletypeSer"));
        if (file != null) {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            objectOutputStream.writeObject(hTMLDocument);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        this.refreshOnUpdate();
    }

    public void serializeIn() throws IOException, ClassNotFoundException {
        File file = this.getFileFromChooser(".", 0, this.extsSer, Translatrix.getTranslationString("FiletypeSer"));
        if (file != null) {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
            this.htmlDoc = (ExtendedHTMLDocument)objectInputStream.readObject();
            objectInputStream.close();
            this.registerDocument(this.htmlDoc);
            this.validate();
        }
        this.refreshOnUpdate();
    }

    private File getFileFromChooser(String string, int n, String[] stringArray, String string2) {
        JFileChooser jFileChooser = new JFileChooser(string);
        jFileChooser.setDialogType(n);
        jFileChooser.setFileFilter(new MutableFilter(stringArray, string2));
        int n2 = 1;
        n2 = n == 0 ? jFileChooser.showOpenDialog(this) : (n == 1 ? jFileChooser.showSaveDialog(this) : jFileChooser.showOpenDialog(this));
        if (n2 == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    private File getImageFromChooser(String string, String[] stringArray, String string2) {
        ImageFileChooser imageFileChooser = new ImageFileChooser(string);
        imageFileChooser.setDialogType(2);
        imageFileChooser.setFileFilter(new MutableFilter(stringArray, string2));
        imageFileChooser.setDialogTitle(Translatrix.getTranslationString("ImageDialogTitle"));
        int n = 1;
        n = imageFileChooser.showDialog(this, Translatrix.getTranslationString("Insert"));
        if (n == 0) {
            return imageFileChooser.getSelectedFile();
        }
        return null;
    }

    private void describeDocument(StyledDocument styledDocument) {
        Element[] elementArray = styledDocument.getRootElements();
        int n = 0;
        while (n < elementArray.length) {
            this.indent = 4;
            int n2 = 0;
            while (n2 < this.indent) {
                System.out.print(" ");
                ++n2;
            }
            System.out.print(elementArray[n]);
            this.traverseElement(elementArray[n]);
            System.out.println("");
            ++n;
        }
    }

    private void traverseElement(Element element) {
        this.indent += 4;
        int n = 0;
        while (n < element.getElementCount()) {
            int n2 = 0;
            while (n2 < this.indent) {
                System.out.print(" ");
                ++n2;
            }
            System.out.print(element.getElement(n));
            this.traverseElement(element.getElement(n));
            ++n;
        }
        this.indent -= 4;
    }

    private Element locateElementInDocument(StyledDocument styledDocument, String string) {
        Element[] elementArray = styledDocument.getRootElements();
        int n = 0;
        while (n < elementArray.length) {
            if (elementArray[n].getName().equalsIgnoreCase(string)) {
                return elementArray[n];
            }
            Element element = this.locateChildElementInDocument(elementArray[n], string);
            if (element != null) {
                return element;
            }
            ++n;
        }
        return null;
    }

    private Element locateChildElementInDocument(Element element, String string) {
        int n = 0;
        while (n < element.getElementCount()) {
            if (element.getElement(n).getName().equalsIgnoreCase(string)) {
                return element.getElement(n);
            }
            ++n;
        }
        return null;
    }

    public JTextPane getTextPane() {
        return this.jtpMain;
    }

    public JTextPane getSourcePane() {
        return this.jtpSource;
    }

    public Frame getFrame() {
        return this.frameHandler;
    }

    public void setFrame(Frame frame) {
        this.frameHandler = frame;
    }

    public JMenuBar getMenuBar() {
        return this.jMenuBar;
    }

    public JMenuBar getCustomMenuBar(Vector vector) {
        this.jMenuBar = new JMenuBar();
        int n = 0;
        while (n < vector.size()) {
            String string = ((String)vector.elementAt(n)).toLowerCase();
            if (htMenus.containsKey(string)) {
                this.jMenuBar.add((JMenu)htMenus.get(string));
            }
            ++n;
        }
        return this.jMenuBar;
    }

    public JToolBar getToolBar(boolean bl) {
        this.jcbmiViewToolbar.setState(bl);
        return this.jToolBar;
    }

    public JToolBar getCustomToolBar(Vector vector, boolean bl) {
        this.jcbmiViewToolbar.setState(bl);
        this.jToolBar = new JToolBar(0);
        this.jToolBar.setFloatable(false);
        int n = 0;
        while (n < vector.size()) {
            String string = ((String)vector.elementAt(n)).toLowerCase();
            if (string.equals(KEY_TOOL_SEP)) {
                this.jToolBar.add(new JToolBar.Separator());
            } else if (htTools.containsKey(string)) {
                if (htTools.get(string) instanceof JButtonNoFocus) {
                    this.jToolBar.add((JButtonNoFocus)htTools.get(string));
                } else if (htTools.get(string) instanceof JToggleButtonNoFocus) {
                    this.jToolBar.add((JToggleButtonNoFocus)htTools.get(string));
                } else if (htTools.get(string) instanceof JComboBoxNoFocus) {
                    this.jToolBar.add((JComboBoxNoFocus)htTools.get(string));
                } else {
                    this.jToolBar.add((JComponent)htTools.get(string));
                }
            }
            ++n;
        }
        return this.jToolBar;
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    public String getAppName() {
        return "Ekit";
    }

    public String getDocumentText() {
        return this.jtpMain.getText();
    }

    public String getDocumentSubText(String string) {
        return this.getSubText(string);
    }

    private String getSubText(String string) {
        this.jtpSource.setText(this.jtpMain.getText());
        String string2 = this.jtpSource.getText().toLowerCase();
        int n = string2.indexOf("<" + string.toLowerCase());
        int n2 = string2.indexOf(">", n) + 1;
        String string3 = "</" + string.toLowerCase() + ">";
        int n3 = string2.indexOf(string3);
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0 || n3 > string2.length()) {
            n3 = string2.length();
        }
        return this.jtpSource.getText().substring(n2, n3);
    }

    public String getDocumentBody() {
        return this.getSubText("body");
    }

    public void setDocumentText(String string) {
        this.jtpMain.setText(string);
        ((HTMLEditorKit)this.jtpMain.getEditorKit()).setDefaultCursor(new Cursor(2));
        this.jtpSource.setText(this.jtpMain.getText());
        ((HTMLEditorKit)this.jtpSource.getEditorKit()).setDefaultCursor(new Cursor(2));
    }

    private void updateTitle() {
        this.frameHandler.setTitle("Ekit" + (this.currentFile == null ? "" : " - " + this.currentFile.getName()));
    }

    public void purgeUndos() {
        if (this.undoMngr != null) {
            this.undoMngr.discardAllEdits();
            this.undoAction.updateUndoState();
            this.redoAction.updateRedoState();
        }
    }

    public void refreshOnUpdate() {
        this.jtpMain.setText(this.jtpMain.getText());
        this.jtpSource.setText(this.jtpMain.getText());
        this.purgeUndos();
        this.repaint();
    }

    public void dispose() {
        this.frameHandler.dispose();
        System.exit(0);
    }

    private ImageIcon getEkitIcon(String string) {
        return new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("icons/" + string + "HK.gif")));
    }

    private void logException(String string, Exception exception) {
        System.err.println(string);
        exception.printStackTrace(System.err);
    }

    private void toggleSourceWindow() {
        if (!this.jspSource.isShowing()) {
            this.jtpSource.setText(this.jtpMain.getText());
            this.jspltDisplay.setRightComponent(this.jspSource);
            if (this.exclusiveEdit) {
                this.jspltDisplay.setDividerLocation(0);
                this.jspltDisplay.setEnabled(false);
            } else {
                this.jspltDisplay.setDividerLocation(this.iSplitPos);
                this.jspltDisplay.setEnabled(true);
            }
        } else {
            this.jtpMain.setText(this.jtpSource.getText());
            this.iSplitPos = this.jspltDisplay.getDividerLocation();
            this.jspltDisplay.remove(this.jspSource);
            this.jtpMain.requestFocus();
        }
        this.validate();
        this.jcbmiViewSource.setSelected(this.jspSource.isShowing());
        this.jtbtnViewSource.setSelected(this.jspSource.isShowing());
    }

    private String findStyle(Element element) {
        AttributeSet attributeSet = element.getAttributes();
        if (attributeSet == null) {
            return null;
        }
        Object object = attributeSet.getAttribute(HTML.Attribute.CLASS);
        if (object != null && object instanceof String) {
            return (String)object;
        }
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            AttributeSet attributeSet2;
            Object obj = enumeration.nextElement();
            if (!(obj instanceof HTML.Tag) || (attributeSet2 = (AttributeSet)attributeSet.getAttribute(obj)) == null || (object = attributeSet2.getAttribute(HTML.Attribute.CLASS)) == null) continue;
            return (String)object;
        }
        return null;
    }

    private void handleCaretPositionChange(CaretEvent caretEvent) {
        int n = caretEvent.getDot();
        Element element = this.htmlDoc.getCharacterElement(n);
        if (element == null) {
            return;
        }
        String string = null;
        Vector<Element> vector = new Vector<Element>();
        while (element != null) {
            if (string == null) {
                string = this.findStyle(element);
            }
            vector.add(element);
            element = element.getParentElement();
        }
        int n2 = -1;
        if (string != null) {
            int n3 = 0;
            while (n3 < this.jcmbStyleSelector.getItemCount()) {
                String string2 = (String)this.jcmbStyleSelector.getItemAt(n3);
                if (string2.equalsIgnoreCase(string)) {
                    n2 = n3;
                    break;
                }
                ++n3;
            }
        }
        if (n2 > -1) {
            Action action = this.jcmbStyleSelector.getAction();
            action.setEnabled(false);
            this.jcmbStyleSelector.setSelectedIndex(n2);
            action.setEnabled(true);
        } else {
            this.jcmbStyleSelector.setSelectedIndex(0);
        }
    }

    protected void setServletURL(String string) {
        this.ServletURL = string;
    }

    protected void setImageDir(String string) {
        this.ImageDir = string;
    }

    public void setTreePilotSystemID(String string) {
        this.TreePilotSystemID = string;
    }

    public ExtendedHTMLDocument getExtendedHtmlDoc() {
        return this.htmlDoc;
    }

    public int getCaretPosition() {
        return this.jtpMain.getCaretPosition();
    }

    public void setCaretPosition(int n) {
        boolean bl = true;
        do {
            bl = true;
            try {
                this.jtpMain.setCaretPosition(n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                bl = false;
                --n;
            }
        } while (!bl && n >= 0);
    }

    class CustomUndoableEditListener
    implements UndoableEditListener {
        CustomUndoableEditListener() {
        }

        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            EkitCore.this.undoMngr.addEdit(undoableEditEvent.getEdit());
            EkitCore.this.undoAction.updateUndoState();
            EkitCore.this.redoAction.updateRedoState();
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super(Translatrix.getTranslationString("Redo"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                EkitCore.this.undoMngr.redo();
            }
            catch (CannotUndoException cannotUndoException) {
                cannotUndoException.printStackTrace();
            }
            this.updateRedoState();
            EkitCore.this.undoAction.updateUndoState();
        }

        protected void updateRedoState() {
            if (EkitCore.this.undoMngr.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", EkitCore.this.undoMngr.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", Translatrix.getTranslationString("Redo"));
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super(Translatrix.getTranslationString("Undo"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                EkitCore.this.undoMngr.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                cannotUndoException.printStackTrace();
            }
            this.updateUndoState();
            EkitCore.this.redoAction.updateRedoState();
        }

        protected void updateUndoState() {
            if (EkitCore.this.undoMngr.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", EkitCore.this.undoMngr.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", Translatrix.getTranslationString("Undo"));
            }
        }
    }
}

