/*
 * Decompiled with CFR 0.152.
 */
package com.hexidec.ekit.component;

import com.hexidec.ekit.EkitCore;
import com.hexidec.ekit.component.ExtendedHTMLEditorKit;
import com.hexidec.ekit.component.SimpleInfoDialog;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;

public class ImageDialog
extends JDialog
implements ActionListener {
    private final String[] Borders = new String[]{"none", "solid", "dotted", "dashed", "double", "groove", "ridge", "inset", "outset"};
    private String[] BorderColors = new String[]{"aqua", "black", "blue", "fuschia", "gray", "green", "lime", "maroon", "navy", "olive", "purple", "red", "silver", "teal", "white", "yellow"};
    private String[] BorderSizes = new String[]{"none", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    private final String[] Wraps = new String[]{"none", "left", "right", "top", "middle", "bottom"};
    private EkitCore ParentEkit;
    private ExtendedHTMLEditorKit ImageHtmlKit;
    private HTMLDocument ImageHtmlDoc;
    private JList WrapList;
    private JList BorderList;
    private JList BorderSizeList;
    private JList BorderColorList;
    private JList ImageList;
    private JTextField ImageAltText;
    private JTextField ImageWidth;
    private JTextField ImageHeight;
    private JEditorPane PreviewPane;
    private String ImageDir;
    private String[] Images;
    private String PreviewImage;
    private String SelectedImage;

    public ImageDialog(EkitCore ekitCore, String string, String[] stringArray, String string2, boolean bl) {
        super(ekitCore.getFrame(), string2, bl);
        this.ImageDir = string;
        this.Images = stringArray;
        this.ParentEkit = ekitCore;
        this.SelectedImage = null;
        this.init();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        SimpleInfoDialog simpleInfoDialog;
        ListSelectionModel listSelectionModel;
        if (actionEvent.getActionCommand().equals("apply")) {
            listSelectionModel = this.ImageList.getSelectionModel();
            if (listSelectionModel.isSelectionEmpty()) {
                simpleInfoDialog = new SimpleInfoDialog(this.ParentEkit.getFrame(), "Error", true, "No image selected", 0);
                this.ImageList.requestFocus();
            } else if (this.validateControls()) {
                this.previewSelectedImage();
            }
        }
        if (actionEvent.getActionCommand().equals("save")) {
            listSelectionModel = this.ImageList.getSelectionModel();
            if (listSelectionModel.isSelectionEmpty()) {
                simpleInfoDialog = new SimpleInfoDialog(this.ParentEkit.getFrame(), "Error", true, "No image selected", 0);
                this.ImageList.requestFocus();
            } else if (this.validateControls()) {
                this.previewSelectedImage();
                this.SelectedImage = this.PreviewImage;
                this.hide();
            }
        } else if (actionEvent.getActionCommand().equals("cancel")) {
            this.hide();
        }
    }

    public void init() {
        this.SelectedImage = "";
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        this.setDefaultCloseOperation(1);
        this.ImageList = new JList<String>(this.Images);
        this.ImageList.setSelectionMode(0);
        this.ImageList.clearSelection();
        ListSelectionModel listSelectionModel = this.ImageList.getSelectionModel();
        this.PreviewPane = new JEditorPane();
        this.PreviewPane.setEditable(false);
        this.ImageHtmlKit = new ExtendedHTMLEditorKit();
        this.ImageHtmlDoc = (HTMLDocument)this.ImageHtmlKit.createDefaultDocument();
        this.ImageHtmlKit.setDefaultCursor(new Cursor(2));
        this.PreviewPane.setCaretPosition(0);
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting() && ImageDialog.this.validateControls()) {
                    ImageDialog.this.previewSelectedImage();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.ImageList);
        jScrollPane.setPreferredSize(new Dimension(200, 250));
        jScrollPane.setMaximumSize(new Dimension(200, 250));
        jScrollPane.setAlignmentX(0.0f);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(jScrollPane);
        jPanel.setBorder(BorderFactory.createTitledBorder("Server Images"));
        this.PreviewPane.setEditorKit(this.ImageHtmlKit);
        this.PreviewPane.setDocument(this.ImageHtmlDoc);
        this.PreviewPane.setMargin(new Insets(4, 4, 4, 4));
        JScrollPane jScrollPane2 = new JScrollPane(this.PreviewPane);
        jScrollPane2.setVerticalScrollBarPolicy(22);
        jScrollPane2.setPreferredSize(new Dimension(250, 250));
        jPanel.add(jScrollPane2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(Box.createHorizontalStrut(10));
        JLabel jLabel = new JLabel("Alternate Text:", 2);
        jPanel3.add(jLabel);
        this.ImageAltText = new JTextField("");
        this.ImageAltText.addActionListener(this);
        this.ImageAltText.setPreferredSize(new Dimension(300, 25));
        this.ImageAltText.setMaximumSize(new Dimension(600, 25));
        jPanel3.add(this.ImageAltText);
        jPanel3.add(Box.createHorizontalStrut(10));
        jPanel2.add(jPanel3);
        jPanel2.add(Box.createVerticalStrut(5));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(Box.createHorizontalStrut(10));
        JLabel jLabel2 = new JLabel("Width:", 2);
        jPanel4.add(jLabel2);
        this.ImageWidth = new JTextField("");
        this.ImageWidth.setPreferredSize(new Dimension(40, 25));
        this.ImageWidth.setMaximumSize(new Dimension(40, 25));
        jPanel4.add(this.ImageWidth);
        JLabel jLabel3 = new JLabel("pix", 2);
        jLabel3.setPreferredSize(new Dimension(20, 10));
        jPanel4.add(jLabel3);
        jPanel4.add(Box.createHorizontalStrut(10));
        JLabel jLabel4 = new JLabel("Height:", 2);
        jPanel4.add(jLabel4);
        this.ImageHeight = new JTextField("");
        this.ImageHeight.setPreferredSize(new Dimension(40, 25));
        this.ImageHeight.setMaximumSize(new Dimension(40, 25));
        jPanel4.add(this.ImageHeight);
        JLabel jLabel5 = new JLabel("pix", 2);
        jLabel5.setPreferredSize(new Dimension(20, 10));
        jPanel4.add(jLabel5);
        jPanel4.add(Box.createHorizontalStrut(10));
        JLabel jLabel6 = new JLabel("Wrap:", 2);
        jPanel4.add(jLabel6);
        this.WrapList = new JList<String>(this.Wraps);
        this.WrapList.setSelectionMode(0);
        this.WrapList.getSelectionModel().setSelectionInterval(0, 0);
        JScrollPane jScrollPane3 = new JScrollPane(this.WrapList);
        jScrollPane3.setAlignmentX(0.0f);
        jScrollPane3.setPreferredSize(new Dimension(80, 40));
        jScrollPane3.setMaximumSize(new Dimension(80, 100));
        jPanel4.add(jScrollPane3);
        jPanel2.add(jPanel4);
        jPanel4.add(Box.createHorizontalStrut(5));
        JLabel jLabel7 = new JLabel("Border Size:", 2);
        jPanel4.add(jLabel7);
        this.BorderSizeList = new JList<String>(this.BorderSizes);
        this.BorderSizeList.setSelectionMode(0);
        this.BorderSizeList.getSelectionModel().setSelectionInterval(0, 0);
        JScrollPane jScrollPane4 = new JScrollPane(this.BorderSizeList);
        jScrollPane4.setAlignmentX(0.0f);
        jScrollPane4.setPreferredSize(new Dimension(80, 40));
        jScrollPane4.setMaximumSize(new Dimension(80, 100));
        jPanel4.add(jScrollPane4);
        jPanel4.add(Box.createHorizontalStrut(10));
        jPanel4.add(Box.createVerticalStrut(10));
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(new SoftBevelBorder(1));
        JButton jButton = new JButton("Apply");
        jButton.setActionCommand("apply");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Accept");
        jButton2.setActionCommand("save");
        jButton2.addActionListener(this);
        JButton jButton3 = new JButton("Cancel");
        jButton3.setActionCommand("cancel");
        jButton3.addActionListener(this);
        jPanel5.add(jButton);
        jPanel5.add(jButton2);
        jPanel5.add(jButton3);
        container.add(jPanel);
        container.add(jPanel2);
        container.add(jPanel5);
        this.pack();
        this.setVisible(true);
    }

    private void previewSelectedImage() {
        block9: {
            ListSelectionModel listSelectionModel = this.ImageList.getSelectionModel();
            if (listSelectionModel.isSelectionEmpty()) break block9;
            String string = this.Images[listSelectionModel.getMinSelectionIndex()];
            try {
                String string2;
                this.PreviewPane.setText("");
                StringBuffer stringBuffer = new StringBuffer();
                if (!this.ImageHeight.getText().equals("")) {
                    stringBuffer.append("HEIGHT=\"" + this.ImageHeight.getText() + "\" ");
                }
                if (!this.ImageWidth.getText().equals("")) {
                    stringBuffer.append("WIDTH=\"" + this.ImageWidth.getText() + "\" ");
                }
                if (!this.ImageAltText.getText().equals("")) {
                    stringBuffer.append("ALT=\"" + this.ImageAltText.getText() + "\" ");
                }
                if (!this.WrapList.getSelectionModel().isSelectionEmpty() && !(string2 = this.Wraps[this.WrapList.getSelectionModel().getMinSelectionIndex()]).equals("none")) {
                    stringBuffer.append("ALIGN=\"" + string2 + "\" ");
                }
                string2 = null;
                Object var5_6 = null;
                if (!this.BorderSizeList.getSelectionModel().isSelectionEmpty()) {
                    string2 = this.BorderSizes[this.BorderSizeList.getSelectionModel().getMinSelectionIndex()];
                    if (!string2.equals("none")) {
                        stringBuffer.append("BORDER=" + string2);
                    }
                } else {
                    string2 = this.BorderSizes[0];
                }
                this.PreviewImage = "<IMG SRC=" + this.ImageDir + "/" + string + " " + stringBuffer.toString() + ">";
                this.ImageHtmlKit.insertHTML(this.ImageHtmlDoc, 0, this.PreviewImage, 0, 0, HTML.Tag.IMG);
                this.repaint();
            }
            catch (Exception exception) {
                System.err.println("Exception previewing image");
            }
        }
    }

    private boolean validateControls() {
        boolean bl;
        block5: {
            SimpleInfoDialog simpleInfoDialog;
            bl = true;
            if (!this.ImageWidth.getText().equals("")) {
                try {
                    Integer.parseInt(this.ImageWidth.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                    simpleInfoDialog = new SimpleInfoDialog(this.ParentEkit.getFrame(), "Error", true, "Image Width is not an integer", 0);
                    this.ImageWidth.requestFocus();
                }
            }
            if (!bl || this.ImageHeight.getText().equals("")) break block5;
            try {
                Integer.parseInt(this.ImageHeight.getText());
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
                simpleInfoDialog = new SimpleInfoDialog(this.ParentEkit.getFrame(), "Error", true, "Image Height is not an integer", 0);
                this.ImageHeight.requestFocus();
            }
        }
        return bl;
    }

    public String getSelectedImage() {
        return this.SelectedImage;
    }
}

