<?php
if (empty($_REQUEST['dir']))
  exit;

require_once 'diogenes.common.inc.php';
require_once 'diogenes.admin.inc.php';

$page = new DiogenesAdmin;
$page->assign('post',$page->script_self());

// rcs handle
$rcs = $page->getRcs();

/* 5Mb limit */
$maxsize=5000000;

$action = (isset($_REQUEST["action"])) ? $_REQUEST["action"] : "";
$target = isset($_REQUEST["target"]) ? $_REQUEST["target"] : "";
$dir = $_REQUEST["dir"];
$res = $globals->db->query("select wperms,location from {$page->table_page} where PID='$dir'");
list($wperms,$dirloc) = mysql_fetch_row($res);
$canedit = $_SESSION['session']->hasPerms($wperms);
$page->assign('canedit', $canedit);

// toolbar
$topbar = array (
  array( __("pages catalog"), "pages"),
  array( __("page properties"), "pages?PID=$dir" ),
  array( __("view page"), $page->urlSite($dirloc ? "$dirloc/" : ""))
);

// filebar
$filebar = array();
if ($canedit) {
  array_push($filebar, array( __("raw editor"), "edit?dir=$dir&amp;file=$target"));
  array_push($filebar, array( __("HTML editor"), "compose?dir=$dir&amp;file=$target"));
}

// translations
$page->assign('msg_files', __("Files in current directory"));
$page->assign('msg_import',__("Import file"));
$page->assign('msg_send',__("Send"));
$page->assign('msg_upload',__("File to upload"));
$page->assign('msg_file',__("file"));
$page->assign('msg_log',__("log"));
$page->assign('msg_version',__("version"));
$page->assign('msg_date',__("date"));
$page->assign('msg_author',__("author"));
$page->assign('msg_size',__("size"));
$page->assign('msg_actions',__("actions"));

switch ($action) {
case "upload":
  if (!$canedit) break;
  $userfile = $_FILES['userfile']['name'];
  if ( is_uploaded_file($_FILES['userfile']['tmp_name'])
    && (filesize($_FILES['userfile']['tmp_name']) <= $maxsize) )
  {
    $rcs->commit($dir, $userfile,
                          file_get_contents($_FILES['userfile']['tmp_name']),
                          "file manager upload of $userfile" );
  } else {
    $page->info(__("Error during file transfer!"));
  }
  break;

case "delete":
  if (!$canedit) break;
  $page->info(__("Deleting file")." $dirloc/$target");
  $rcs->del($dir,$target);
  break;
case "restore":
  if (!$canedit) break;
  $rev = $_REQUEST["rev"];
  $page->info("restore : $target,$rev");
  $path = $rcs->checkout($dir,$target,$rev,System::mktemp("-d"));
  $contents = file_get_contents($path);
  $rcs->commit($dir,$target,$contents,"restored revision $rev");
  break;
case "diff":
  $page->assign('greeting', __("Revision differences"). " - $dirloc/$target");
  $page->assign('diff',$rcs->dispDiff($dir,$target,$_REQUEST["r1"],$_REQUEST["r2"]));
  array_push($topbar, array( __("browse files"), "?dir=$dir" ));
  $page->toolbar(__("Page"), $topbar);
  array_push($filebar, array( __("file revisions"), "files?action=revs&amp;dir=$dir&amp;target=$target" ));
  $page->toolbar(__("File"), $filebar);
  $page->display('admin-revs.tpl');
  exit;
case "revs":
  $page->assign('greeting', __("File revisions"). " - $dirloc/$target");
  $page->assign('entries',$rcs->dispRevs($dir,$dirloc,$target,$canedit));
  array_push($topbar, array( __("browse files"), "?dir=$dir" ));
  $page->toolbar(__("Page"), $topbar);
  array_push($filebar, array( __("file revisions") ));
  $page->toolbar(__("File"), $filebar);
  $page->display('admin-revs.tpl');
  exit;
}

// directory listing
array_push($topbar, array( __("browse files")) );
$page->toolbar(__("Page"), $topbar);
$page->assign('greeting', __("File manager"). " - $dirloc");
$page->assign('maxsize',$maxsize);
$page->assign('entries',$rcs->dispDir($dir,$dirloc,$canedit));

$page->display('admin-files.tpl');
?>
