/*
   (c) Copyright 2000-2002  convergence integrated media GmbH.
   (c) Copyright 2002-2004  convergence GmbH.

   All rights reserved.

   Written by Denis Oliver Kropp <dok@directfb.org>,
              Andreas Hundt <andi@fischlustig.de>,
              Sven Neumann <neo@directfb.org> and
              Ville Syrjl <syrjala@sci.fi>.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef __VOODOO__TYPES_H__
#define __VOODOO__TYPES_H__

#include <direct/types.h>


typedef __u32 VoodooInstanceID;
typedef __u32 VoodooMethodID;
typedef __u64 VoodooMessageSerial;

#define VOODOO_INSTANCE_NONE  ((VoodooInstanceID) 0)


typedef struct __V_VoodooMessageHeader   VoodooMessageHeader;
typedef struct __V_VoodooSuperMessage    VoodooSuperMessage;
typedef struct __V_VoodooRequestMessage  VoodooRequestMessage;
typedef struct __V_VoodooResponseMessage VoodooResponseMessage;


typedef struct __V_VoodooClient          VoodooClient;
typedef struct __V_VoodooConfig          VoodooConfig;
typedef struct __V_VoodooManager         VoodooManager;
typedef struct __V_VoodooServer          VoodooServer;


typedef DirectResult (*VoodooSuperConstruct)( VoodooServer         *server,
                                              VoodooManager        *manager,
                                              const char           *name,
                                              void                 *ctx,
                                              VoodooInstanceID     *ret_instance );

typedef DirectResult (*VoodooDispatch)      ( void                 *dispatcher,
                                              void                 *real,
                                              VoodooManager        *manager,
                                              VoodooRequestMessage *msg );

#endif

