#ifndef __groups
#define __groups 1

#include <glib.h>
#include <lber.h>
#include <ldap.h>
#include "profile.h"
#include "pairs.h"

typedef struct _diradmin_group
{
  pairs_list *diradmin_group_data;
  GList *diradmin_group_members;
  GList *diradmin_group_objectclasses;
}
diradmin_group;


diradmin_group *diradmin_group_new (gchar * dn,
				    gchar * cn,
				    gchar * gidnumber, GList * memberlist);

diradmin_group *diradmin_group_duplicate (diradmin_group * tobeduped);

void diradmin_group_destroy (diradmin_group * todestroy);


gchar *diradmin_group_get_attribute (diradmin_group * conn, gchar * attr);

void diradmin_group_set_attribute (diradmin_group * conn, gchar * attr,
				   gchar * to);

void diradmin_group_remove_attribute (diradmin_group * conn, gchar * attr);

void diradmin_group_add_member (diradmin_group * conn, gchar * member);
void diradmin_group_remove_member (diradmin_group * conn, gchar * member);

GList *diradmin_group_get_members (diradmin_group * conn);

void diradmin_group_set_members (diradmin_group * conn, GList * memberlist);

diradmin_group *diradmin_group_new_from_ldap (connection_profile * usethisone,
					      char *userdn);

void g_debug_free (gpointer data);

gchar *gidnumber_to_cn (connection_profile * usethisone, gchar * gidnumber);

gchar *cn_to_gidnumber (connection_profile * usethisone, gchar * cn);

LDAPMod **diradmin_group_generate_ldapdiff (diradmin_group * oldone,
					    diradmin_group * newone);

diradmin_group *create_group_struct_from_dialogbox (connection_profile * conn,
						    GtkWidget * dialogbox,
						    gchar * dn);

LDAPMod **diradmin_group_create_ldapdiff (diradmin_group * newone);

GList *diradmin_group_get_objectclasses (diradmin_group * conn);

void diradmin_group_add_objectclass (diradmin_group * conn,
				     gchar * allowedserver);

void diradmin_group_remove_objectclass (diradmin_group * conn,
					gchar * allowedserver);

void diradmin_group_set_objectclasses (diradmin_group * conn,
				       GList * allowedserverlist);

gboolean diradmin_group_has_objectclass (diradmin_group * conn,
					 gchar * allowedserver);


gboolean
diradmin_group_has_member (diradmin_group * conn, gchar * allowedserver);
void diradmin_group_dump_objectclasses (diradmin_group * conn);
#endif
