#include "appsupport.h"
#include "profile.h"
#include "users.h"
#include "groups.h"
#include "appglobals.h"
#include "appfunctions.h"
#include "modifydialogs.h"
#include "defaults.h"

void
fill_modifyuser (GtkWidget * modifyuserdialog, char *userdn)
{

  connection_profile *usethisone = NULL;
  gchar *gidnumber = NULL;

  GList *attributes2fill = NULL;
  GList *loopix = NULL;
  char *row[2];

  time_t the_time;

  diradmin_user *user = NULL;

  row[0] = NULL;
  row[1] = NULL;

  usethisone = current_connection_profile;

  user = diradmin_user_new_from_ldap (usethisone, userdn);

//attributes to fill - bound to change upon full compliance with schemas
  attributes2fill = g_list_append (attributes2fill, "dn");
  attributes2fill = g_list_append (attributes2fill, "uid");
  attributes2fill = g_list_append (attributes2fill, "givenname");
  attributes2fill = g_list_append (attributes2fill, "initials");
  attributes2fill = g_list_append (attributes2fill, "sn");
  attributes2fill = g_list_append (attributes2fill, "cn");
  attributes2fill = g_list_append (attributes2fill, "uidnumber");
  attributes2fill = g_list_append (attributes2fill, "homedirectory");
  attributes2fill = g_list_append (attributes2fill, "loginshell");
  attributes2fill = g_list_append (attributes2fill, "mail");
  attributes2fill = g_list_append (attributes2fill, "mailhost");
  attributes2fill = g_list_append (attributes2fill, "mailroutingaddress");
  attributes2fill = g_list_append (attributes2fill, "shadowmin");
  attributes2fill = g_list_append (attributes2fill, "shadowmax");
  attributes2fill = g_list_append (attributes2fill, "shadowwarning");
  attributes2fill = g_list_append (attributes2fill, "shadowinactive");
  attributes2fill = g_list_append (attributes2fill, "title");
  attributes2fill = g_list_append (attributes2fill, "ou");
  attributes2fill =
    g_list_append (attributes2fill, "physicaldeliveryofficename");
  attributes2fill = g_list_append (attributes2fill, "l");
  attributes2fill = g_list_append (attributes2fill, "o");
  attributes2fill = g_list_append (attributes2fill, "telephonenumber");
  attributes2fill =
    g_list_append (attributes2fill, "facsimiletelephonenumber");
  attributes2fill = g_list_append (attributes2fill, "homephone");
  attributes2fill = g_list_append (attributes2fill, "mobile");
  loopix = g_list_first (attributes2fill);


  // loop thru attribute values
  while (loopix)
    {

      if (diradmin_user_get_attribute (user, loopix->data))
	gtk_entry_set_text (GTK_ENTRY
			    (lookup_widget (modifyuserdialog, loopix->data)),
			    g_strdup (diradmin_user_get_attribute
				      (user, loopix->data)));
      loopix = g_list_next (loopix);
    }

  //the gidnumber requires special treatment due to its placement on
  //a drop down box

  fill_groups_dropdown (lookup_widget
			(modifyuserdialog, "gidnumberdropdown"));
  gidnumber =
    gidnumber_to_cn (usethisone,
		     diradmin_user_get_attribute (user, "gidnumber"));
  if (gidnumber)
    gtk_entry_set_text (GTK_ENTRY
			(lookup_widget (modifyuserdialog, "gidnumber")),
			gidnumber);

  gtk_combo_set_popdown_strings (GTK_COMBO (lookup_widget
					    (modifyuserdialog,
					     "loginshelldropdown")),
				 preferences.logindefaults.shells);
  g_print ("\nSetting loginshell to %s\n",
	   diradmin_user_get_attribute (user, "loginshell"));
  gtk_entry_set_text (GTK_ENTRY
		      (lookup_widget (modifyuserdialog, "loginshell")),
		      diradmin_user_get_attribute (user, "loginshell"));

  loopix = diradmin_user_get_allowedservers (user);
  while (loopix)
    {

      row[0] = loopix->data;
      g_print (row[0]);
      gtk_clist_append (GTK_CLIST
			(lookup_widget (modifyuserdialog, "allowedservers")),
			row);
      loopix = g_list_next (loopix);
    }
#ifdef USE_TRUSTMODE
  if (!g_list_length (diradmin_user_get_allowedservers (user)))
    {
#else
  if ( diradmin_user_get_attribute(user,"trustmodel") != NULL &&
       g_strcasecmp(diradmin_user_get_attribute(user,"trustmodel"),"fullaccess") == 0) {
    //      g_print("Trust model: full access"); g_print(diradmin_user_get_attribute(user,"trustmodel"));
#endif
      gtk_toggle_button_set_active ((GtkToggleButton *)
				    lookup_widget (modifyuserdialog,
						   "logontoallservers"),
				    TRUE);
    }
  if (diradmin_user_has_objectclass (user, "inetlocalmailrecipient"))
    {
      gtk_toggle_button_set_active ((GtkToggleButton *)
				    lookup_widget (modifyuserdialog,
						   "enablemailpolicycontrol"),
				    TRUE);
      if (diradmin_user_get_attribute (user, "mailhost") != NULL)
	gtk_toggle_button_set_active ((GtkToggleButton *)
				      lookup_widget (modifyuserdialog,
						     "mailhostset"), TRUE);
      if (diradmin_user_get_attribute (user, "mailroutingaddress") != NULL)
	gtk_toggle_button_set_active ((GtkToggleButton *)
				      lookup_widget (modifyuserdialog,
						     "mailroutingaddressset"),
				      TRUE);
    }
  if (diradmin_user_get_attribute (user, "shadowexpire") != NULL)
    {
      gtk_toggle_button_set_active ((GtkToggleButton *)
				    lookup_widget (modifyuserdialog,
						   "shadowexpirecheck"),
				    TRUE);
      the_time =
	(1 +
	 atol (diradmin_user_get_attribute (user, "shadowexpire"))) * (60 *
								       60 *
								       24);
      gnome_date_edit_set_time ((GnomeDateEdit *)
				lookup_widget (modifyuserdialog,
					       "shadowexpire"), the_time);
    }


  diradmin_user_destroy (user);
  g_list_free (attributes2fill);

}


void
fill_modifygroup (GtkWidget * modifyuserdialog, char *userdn)
{

  connection_profile *usethisone = NULL;

  GList *attributes2fill = NULL;
  GList *loopix = NULL;
  char *row[3];

  diradmin_group *user = NULL;

  row[0] = NULL;
  row[1] = NULL;
  row[2] = NULL;

  usethisone = current_connection_profile;

  user = diradmin_group_new_from_ldap (usethisone, userdn);


//attributes to fill - bound to change upon full compliance with schemas
  attributes2fill = g_list_append (attributes2fill, "dn");
  attributes2fill = g_list_append (attributes2fill, "cn");
  attributes2fill = g_list_append (attributes2fill, "gidnumber");
  loopix = g_list_first (attributes2fill);

  // loop thru attribute values
  while (loopix)
    {

      gtk_entry_set_text (GTK_ENTRY
			  (lookup_widget (modifyuserdialog, loopix->data)),
			  g_strdup (diradmin_group_get_attribute
				    (user, loopix->data)));
      loopix = g_list_next (loopix);
    }

  loopix = diradmin_group_get_members (user);
  while (loopix)
    {

      row[0] = loopix->data;
      gtk_clist_append (GTK_CLIST
			(lookup_widget (modifyuserdialog, "members")), row);
      loopix = g_list_next (loopix);
    }


  diradmin_group_destroy (user);

  g_list_free (attributes2fill);

}

gboolean modifyuser_check (GtkWidget * window)
{
  gboolean changingpassword;
  gchar *userpassword = NULL;
  gchar *userpasswordconfirm = NULL;

  changingpassword =
    GTK_WIDGET_VISIBLE (lookup_widget (GTK_WIDGET (window), "tablepassword"));
  userpassword =
    gtk_entry_get_text (GTK_ENTRY (lookup_widget (window, "userpassword")));
  userpasswordconfirm =
    gtk_entry_get_text (GTK_ENTRY
			(lookup_widget (window, "userpasswordconfirm")));
  if (gtk_entry_get_text (GTK_ENTRY (lookup_widget (window, "uid"))) == NULL)
    {
      gtk_widget_show (create_messagebox_with_message
		       ("You need to supply a user ID"));
      return ERROR;
    }
  if (gtk_entry_get_text (GTK_ENTRY (lookup_widget (window, "uidnumber"))) ==
      NULL)
    {
      gtk_widget_show (create_messagebox_with_message
		       ("You need to supply a UNIX UID number"));
      return ERROR;
    }
  if (changingpassword)
    {
      if (strlen (userpassword) == 0 && strlen (userpasswordconfirm) == 0)
	{
	  gtk_widget_show (create_messagebox_with_message
			   ("You need to supply a password"));
	  return ERROR;
	}
      if (userpassword
	  &&
	  userpasswordconfirm
	  && strcmp (userpassword, userpasswordconfirm) != 0)
	{
	  gtk_widget_show (create_messagebox_with_message
			   ("Passwords do not match"));
	  return ERROR;
	}
      if (userpassword
	  &&
	  userpasswordconfirm
	  && strlen (userpassword) < preferences.logindefaults.PASS_MIN_LEN)
	{
	  gtk_widget_show (create_messagebox_with_message
			   ("The password is too short"));
	  return ERROR;
	}
    }

  return OK;

}


gboolean modifyuser_commit (GtkWidget * window)
{
  diradmin_user *olduser = NULL;
  diradmin_user *newuser = NULL;
  int ldap_errors = LDAP_SUCCESS;
  LDAPMod **modifications = NULL;
  gchar *dn = NULL;

  if (connection_profile_is_connected (current_connection_profile) == FALSE)
    return ERROR;
  dn = gtk_entry_get_text (GTK_ENTRY (lookup_widget (window, "dn")));

  newuser = create_user_struct_from_dialogbox (current_connection_profile,
					       window, dn);

  //this is a stupid kludge to avoid useing the DN, which is the authoritative source of information
  //for which user I want to edit.  So I'm using the uid of the user corresponding to the dialog box 
  //which isn't correct.  It is not correct, I repeat.  But the uid entry box is non-editable for the
  //time being.
  olduser =
    diradmin_user_new_from_ldap (current_connection_profile,
				 diradmin_user_get_attribute (newuser,
							      "uid"));
  modifications = diradmin_user_generate_ldapdiff (olduser, newuser);
  if (modifications)
    {
      ldap_errors =
	connection_profile_commit_modifications (current_connection_profile,
						 modifications,
						 diradmin_user_get_attribute
						 (olduser, "dn"));
      ldap_mods_free (modifications, 1);
      if (ldap_errors)
	gtk_widget_show (create_messagebox_with_message
			 (ldap_err2string (ldap_errors)));
/* this is commented out becuz currently nothing can happen
      else 
      fill_iconlist (current_connection_profile);
*/
    }
  diradmin_user_destroy (olduser);
  diradmin_user_destroy (newuser);

  if (ldap_errors)
    return ERROR;
  return OK;
}


gboolean modifygroup_check (GtkWidget * window)
{
  if (gtk_entry_get_text (GTK_ENTRY (lookup_widget (window, "cn"))) == NULL)
    {
      gtk_widget_show (create_messagebox_with_message
		       ("You need to supply a group name"));
      return ERROR;
    }
  if (gtk_entry_get_text (GTK_ENTRY (lookup_widget (window, "gidnumber"))) ==
      NULL)
    {
      gtk_widget_show (create_messagebox_with_message
		       ("You need to supply a UNIX GID number"));
      return ERROR;
    }
  return OK;
}

gboolean modifygroup_commit (GtkWidget * window)
{
  LDAPMod **modifications = NULL;
  diradmin_group *olduser = NULL;
  diradmin_group *newuser = NULL;
  int ldap_errors = LDAP_SUCCESS;
  gchar *dn;

  if (connection_profile_is_connected (current_connection_profile) == FALSE)
    return ERROR;
  dn = gtk_entry_get_text (GTK_ENTRY (lookup_widget (window, "dn")));

  newuser = create_group_struct_from_dialogbox (current_connection_profile,
						window, dn);
  //this is a stupid kludge to avoid useing the DN, which is the authoritative source of information
  //for which user I want to edit.  So I'm using the uid of the user corresponding to the dialog box
  //which isn't correct.  It is not correct, I repeat.  But the uid entry box is non-editable for the
  //time being.
  olduser =
    diradmin_group_new_from_ldap (current_connection_profile,
				  diradmin_group_get_attribute (newuser,
								"cn"));
  modifications = diradmin_group_generate_ldapdiff (olduser, newuser);
  if (modifications)
    {
      ldap_errors =
	connection_profile_commit_modifications (current_connection_profile,
						 modifications,
						 diradmin_group_get_attribute
						 (olduser, "dn"));
      ldap_mods_free (modifications, 1);
      if (ldap_errors)
	gtk_widget_show (create_messagebox_with_message
			 (ldap_err2string (ldap_errors)));
/* same deal as up
      else
      fill_iconlist (current_connection_profile);
*/
    }
  diradmin_group_destroy (olduser);
  diradmin_group_destroy (newuser);
  if (ldap_errors)
    return ERROR;
  return OK;
}
