#include <string.h>
#include <glib.h>
#include <lber.h>
#include <ldap.h>

#ifndef __profile_h_defined
#define __profile_h_defined 1

typedef struct _connection_profile
{
  gchar *name;
  gchar *dn;
  gchar *pw;
  gchar *server;
  gchar *treeroot;
  LDAP *connid;
  gchar *lastuserou;
  gchar *lastgroupou;
}
connection_profile;

connection_profile *connection_profile_new (gchar * name, gchar * dn,
					    gchar * pw, gchar * server,
					    gchar * treeroot);
connection_profile *connection_profile_duplicate (connection_profile *
						  tobeduped);
void connection_profile_destroy (connection_profile * todestroy);
void connection_profile_set_name (connection_profile * conn, gchar * name);
void connection_profile_set_dn (connection_profile * conn, gchar * dn);
void connection_profile_set_password (connection_profile * conn, gchar * pw);
void connection_profile_set_server (connection_profile * conn,
				    gchar * server);
void connection_profile_set_treeroot (connection_profile * conn,
				      gchar * treeroot);

gchar *connection_profile_get_name (connection_profile * conn);
gchar *connection_profile_get_server (connection_profile * conn);
gchar *connection_profile_get_dn (connection_profile * conn);
gchar *connection_profile_get_password (connection_profile * conn);
gchar *connection_profile_get_treeroot (connection_profile * conn);
LDAP *connection_profile_get_ldap_handler (connection_profile * conn);
void connection_profile_disconnect (connection_profile * conn);
gboolean connection_profile_is_connected (connection_profile * conn);
int connection_profile_connect (connection_profile * conn);

void connection_profile_set_last_user_ou (connection_profile * conn, gchar * ou);
void connection_profile_set_last_group_ou (connection_profile * conn, gchar * ou);
gchar *connection_profile_get_last_user_ou (connection_profile * conn);
gchar *connection_profile_get_last_group_ou (connection_profile * conn);


connection_profile *connection_profile_list_getbyname (GList * connec,
						       gchar * nombre);
GList *connection_profile_list_remove (GList * connec,
				       connection_profile * nombre);
GList *connection_profile_list_add (GList * connec,
				    connection_profile * nombre);

void dump_mods (LDAPMod ** mods);

int connection_profile_commit_modifications (connection_profile * conn,
					     LDAPMod ** modifications,
					     char *dn);
int connection_profile_create_record (connection_profile * conn,
				      LDAPMod ** modifications, char *dn);
#endif
