/*
 * Detect a Library for hardware detection
 *
 * Copyright (C) 1998-2000 MandrakeSoft
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "discover.h"
#include "utils.h"



extern struct isdn_info *isdn_detect(struct bus_lst *bus){
  struct pci_info *pci = (struct pci_info *)NULL;
  struct isa_info *isa = (struct isa_info *)NULL;
  struct usb_info *usb = (struct usb_info *)NULL;
  struct pcmcia_info *pcmcia = (struct pcmcia_info *)NULL;
  struct isdn_info *result = (struct isdn_info *)NULL;
  static struct isdn_info *first = (struct isdn_info *)NULL;
  
  if(first){
    return first;
  }/*endif*/
  
  if(debug)
    fprintf(stdout, "\nProbing isdn adapter...\n");
  
  /********************************************************************/
  /******************* PCI ISDN CARD DETECTION ********************/
  /********************************************************************/
  if(debug)
    fprintf(stdout, "\tProbing PCI isdn adapater...\n");
  
  for(pci = bus->pci; pci; pci = pci->next){
    if(pci->type == ISDN){
      if(!first){
        first = result = (struct isdn_info *) 
	  my_malloc(sizeof(struct isdn_info));
      }else{
        result->next = (struct isdn_info *) 
	  my_malloc(sizeof(struct isdn_info));
        result = result->next;
      }/*endif*/
      result->next = (struct isdn_info *)NULL;
      result->vendor = pci->vendor;
      result->model = pci->model;
      result->module = pci->modulename;
      result->long_id = pci->id;
      result->bus = PCI;
      if(debug)
	fprintf(stdout, "\t\tFound %s %s\n", 
		result->vendor, result->model);
    }/*endif*/
  }/*next pci*/
  
  /********************************************************************/
  /******************* ISA ISDN CARD DETECTION ********************/
  /********************************************************************/
  if(debug)
    fprintf(stdout, "\tProbing ISA isdn adapter...\n");
  
  for(isa = bus->isa; isa; isa = isa->next){
    if(isa->type == ISDN){
      if(!first){
        first = result = (struct isdn_info *) 
                                my_malloc(sizeof(struct isdn_info));
      }else{
        result->next = (struct isdn_info *) 
                                my_malloc(sizeof(struct isdn_info));
        result = result->next;
      }/*endif*/
      result->next = (struct isdn_info *)NULL;
      
      result->board_num = isa->board_num;
      result->board_id =  isa->board_id;
      result->dev_id = isa->dev_id;
      result->dev_num= isa->dev_num;
      result->vendor = isa->vendor;
      result->model = isa->model;
      result->module = isa->modulename;
      result->io = isa->io;
      result->irq = isa->irq;
      result->bus = ISA;
      
      if(debug)
	fprintf(stdout, "\t\tFound %s %s\n", 
		result->vendor, result->model);
    }/*endif*/
  }/*next isa*/
  
  /********************************************************************/
  /************************** USB ISDN  ******************************/
  /********************************************************************/
  if(debug)
    fprintf(stdout, "\tProbing USB isdn adapter...\n");

  for(usb = bus->usb; usb; usb = usb->next){
    if(usb->type == ISDN){
      if(!first){
        first = result = (struct isdn_info *)
      my_malloc(sizeof(struct isdn_info));
      }else{
        result->next = (struct isdn_info *)
      my_malloc(sizeof(struct isdn_info));
        result = result->next;
      }/*endif*/
      result->next = (struct isdn_info *)NULL;
      result->vendor = usb->vendor;
      result->model = usb->model;
      result->module = usb->modulename;
      result->bus = USB;
      result->io = 0;
      result->irq = 0;
      result->long_id = usb->id;
      if(debug)
      fprintf(stdout, "\t\tFound %s", result->model);
    }/*endif*/
  }/*next usb*/

  
  /********************************************************************/
  /****************** PCMCIA ISDN CARD DETECTION ******************/
  /********************************************************************/
  if(debug)
  fprintf(stdout, "\tProbing PCMCIA isdn card...\n");

  for(pcmcia = bus->pcmcia; pcmcia; pcmcia = pcmcia->next){
    if(pcmcia->type == ISDN){
      if(!first){
        first = result = (struct isdn_info *) 
                                my_malloc(sizeof(struct isdn_info));
      }else{
        result->next = (struct isdn_info *) 
                                my_malloc(sizeof(struct isdn_info));
          result = result->next;
      }/*endif*/
      result->next = (struct isdn_info *)NULL;

      result->vendor = pcmcia->vendor;
      result->model = pcmcia->model;
      result->module = pcmcia->modulename;
      result->long_id = pcmcia->id;	
      result->bus = PCMCIA;
      if(debug)
      fprintf(stdout, "\t\tFound %s %s\n", 
	      result->vendor, result->model);
    }/*endif*/
  }/*next pcmcia*/

  
  return first;
}/*endfunc isdn_detect*/
