#! /usr/bin/env python

#Common imports
import os, sys
import unittest
import DiskSearchTest
sys.path.append(os.path.join(os.path.dirname(os.path.abspath(__file__)), '..'))

#import specific to the test
from libdisksearch import Constants

class TestCase(DiskSearchTest.TestCase):
    def setUp(self):
        self.constants = Constants

    def testValues(self):
        self.assertEqual(self.constants.RESOURCE_DIR, "./resource")
        self.assertEqual(self.constants.LOCALE_APP, "disksearch")
        self.assertEqual(self.constants.LOCALE_DIR, "/usr/local/share/locale")

def suite():
    suite = unittest.TestSuite()
    suite.addTest(unittest.makeSuite(TestCase))
    return suite

if __name__ == '__main__':
    unittest.main()
