#include "config.h"

#ifdef HAVE_LIBCDDA_PARANOIA
#include "cdlist.h"
#include <qlistview.h>
#include <dirent.h>
#include "dirview.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <qpixmap.h>
#include <stdlib.h>
#include <unistd.h>
#include <qtabwidget.h>
#include <ctype.h>
#include <qpopupmenu.h>
#ifdef HAVE_QOBJECTLIST_H
#include <qobjectlist.h>
#else
#ifdef HAVE_QOBJCOLL_H
#include <qobjcoll.h>
#else
#error "Your QT has neither qobjcoll.h nor qobjectlist.h"
#endif
#endif
#include "virlist.h"
#include <stdio.h>
#include "playlist.h"
#include "scanthread.h"
#include <qfileinfo.h>
#include <qmessagebox.h>

extern "C" {
#include <cdda_interface.h>
#include <cdda_paranoia.h>
}

#include "dir.xpm"
#include "file.xpm"
#include "up.xpm"

void CDList::resizeEvent(QResizeEvent *e)
{
	lv->resize(e->size().width()-10, e->size().height()-10);
	lv->setColumnWidth(0, e->size().width()-174);
	lv->setColumnWidth(1, 70);
	lv->setColumnWidth(2, 70);
	lv->repaint();
}

CDList::CDList(QWidget *parent, Playlist *p, const char *name, WFlags f) : List(parent, p, name, f)
{
	pl=p;
	p_dir=new QPixmap((const char **)dir_xpm);
	p_file=new QPixmap((const char **)file_xpm);
	p_up=new QPixmap((const char **)up_xpm);
	dir="";
	lv=new QListView(this);
	lv->move(5, 5);
	lv->addColumn(dir);
	lv->addColumn("");
	lv->addColumn("Time");
	lv->setColumnWidthMode(0, QListView::Manual);
	lv->setColumnWidthMode(0, QListView::Manual);
	lv->setAllColumnsShowFocus(true);
	lv->setColumnAlignment(1, AlignRight);
	lv->setColumnAlignment(2, AlignRight);
	lv->setSelectionMode(QListView::Extended);

	connect(lv, SIGNAL(doubleClicked(QListViewItem *)), this, SLOT(lv_doubleClicked(QListViewItem *)));
	connect(lv, SIGNAL(rightButtonPressed(QListViewItem *, const QPoint&, int)), this, SLOT(lv_rightClicked(QListViewItem *, const QPoint&, int)));
}

void CDList::load()
{
	int initial=1;
	if(lv->firstChild())
		initial=0;
	lv->clear();

	cdrom_drive *d;
	int r;

	d=cdda_identify(dir, CDDA_MESSAGE_FORGETIT, NULL);
	if(d)
	{
		cdda_verbose_set(d, CDDA_MESSAGE_FORGETIT, CDDA_MESSAGE_FORGETIT);
		r=cdda_open(d);
		if(r)
		{
			cdda_close(d);
			QMessageBox::warning(NULL, "Error", "No CD or non-audio CD", "OK", 0, 0, 0, 0);
			return;
		}
	}
	else
	{
		QMessageBox::warning(NULL, "Error", "No CD or non-audio CD", "OK", 0, 0, 0, 0);
		return;
	}

	int i;

	for(i=1; i<= d->tracks;i++)
	{
		if(!cdda_track_audiop(d, i))
			continue;
		int first=cdda_track_firstsector(d, i);
		int last=cdda_track_lastsector(d, i);
		int secs=(last-first)/75;
		QString ttime;
		ttime.sprintf("%d:%02d", secs/60, secs%60);
		QString tname;
		tname.sprintf("Track %02d", i);
		QString turl;
		turl.sprintf("cdda://%s:Track %02d", (const char *)dir, i);
		DirViewItem *it=new DirViewItem(lv, tname, false);
		it->setPixmap(0, *p_file);
		it->setText(2, ttime);
		it->setText(3, turl);
	}

	cdda_close(d);
	if(!lv->firstChild())
	{
		QMessageBox::warning(NULL, "Error", "No CD or non-audio CD", "OK", 0, 0, 0, 0);
	}
}

CDList::~CDList()
{
}

void CDList::lv_doubleClicked(QListViewItem *it)
{
	DirViewItem *dv=(DirViewItem *)it;
	if(!dv->isDir())
	{
		pl->doubleClick();
		return;
	}
}

void CDList::setDir(QString i_dir)
{
	dir=i_dir;
	load();
}

QString CDList::getDir()
{
	return dir;
}

QString CDList::getTitle()
{
	if(tab_name != QString::null && tab_name != "")
		return tab_name;
	return dir;
}

void CDList::setTitle(QString title)
{
	tab_name=title;
}

void CDList::setFile(QString i_file)
{
}

void CDList::lv_rightClicked(QListViewItem *it, const QPoint& pos, int col)
{
	if(!it)
		return;
	DirViewItem *dv=(DirViewItem *)it;
	if(dv->isDir())
		return;
	QPopupMenu *menu=new QPopupMenu(this);
	menu->insertItem("Load left", pl, SLOT(left_clicked()));
	menu->insertItem("Load right", pl, SLOT(right_clicked()));
	QObjectList *ch=parent()->queryList("VirList");
	if(ch)
	{
		if(ch->count())
		{
			menu->insertSeparator();
			QPopupMenu *submenu=new QPopupMenu(menu);

			QObjectListIt i(*ch);
			QObject *obj;
			while((obj=i.current()) != 0)
			{
				++i;
				VirList *list=(VirList *)obj;
				int id=submenu->insertItem(list->getTitle(), this, SLOT(moveToList(int)));
				submenu->setItemParameter(id, (long)list);
			}
			menu->insertItem("Send to", submenu);
		}
	}
	delete ch;

	menu->popup(pos);
}

void CDList::moveToList(int arg)
{
	List *list=(List *)arg;
    if(!list)
        return;

    QListViewItem *it=lv->firstChild();
    while(it)
    {
        if(it->isSelected())
        {
            QString path=it->text(3);
            list->addFile(path);
        }
        it=it->nextSibling();
    }
}

QString CDList::getSelectedFile()
{
    DirViewItem *item=(DirViewItem *)lv->currentItem();
    if(!item)
        return QString::null;
    if(item->isDir())
        return QString::null;
    QString path=item->text(3);
    return path;
}

void CDList::addFile(QString file, bool s)
{
}

#endif /* HAVE_LIBCDDA_PARANOIA */
