<?xml version='1.0'?>
<!-- vim: sw=2 sta et
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version='1.0'
                xml:lang="en">

<!-- ********************************************************************
     $Id: texi-jrefentry.xsl,v 1.2 2003/06/01 21:19:56 stevecheng Exp $
     ********************************************************************

     &copy; 2000 Steve Cheng <stevecheng@users.sourceforge.net>

     This file is part of the docbook2X XSLT stylesheets for
     converting DocBook to Texinfo.

     Derived from files in Norman Walsh's XSL DocBook Stylesheet
     Distribution and Mark Burton's dbtotexi stylesheets.

     ******************************************************************** -->

<!-- ==================================================================== -->

<xsl:include href="../texi/docbook-libxslt.xsl" />

<xsl:template match="refdescription">
  <xsl:call-template name="section">
    <xsl:with-param name="level">
      <xsl:call-template name="get-texinfo-section-level">
        <xsl:with-param name="heading.class" select="'chapheading'" />
      </xsl:call-template>
    </xsl:with-param>
    <xsl:with-param name="title">Description</xsl:with-param>
  </xsl:call-template>
</xsl:template>
  
<xsl:template match="refauthor">
  <xsl:call-template name="section">
    <xsl:with-param name="level">
      <xsl:call-template name="get-texinfo-section-level">
        <xsl:with-param name="heading.class" select="'chapheading'" />
      </xsl:call-template>
    </xsl:with-param>
    <xsl:with-param name="title">Author</xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="refversion">
  <xsl:call-template name="section">
    <xsl:with-param name="level">
      <xsl:call-template name="get-texinfo-section-level">
        <xsl:with-param name="heading.class" select="'chapheading'" />
      </xsl:call-template>
    </xsl:with-param>
    <xsl:with-param name="title">Version</xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="refparameter">
  <xsl:call-template name="section">
    <xsl:with-param name="level">
      <xsl:call-template name="get-texinfo-section-level">
        <xsl:with-param name="heading.class" select="'chapheading'" />
      </xsl:call-template>
    </xsl:with-param>
    <xsl:with-param name="title">Parameters</xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="refreturn">
  <xsl:call-template name="section">
    <xsl:with-param name="level">
      <xsl:call-template name="get-texinfo-section-level">
        <xsl:with-param name="heading.class" select="'chapheading'" />
      </xsl:call-template>
    </xsl:with-param>
    <xsl:with-param name="title">Return value</xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="refexception|refthrows">
  <xsl:call-template name="section">
    <xsl:with-param name="level">
      <xsl:call-template name="get-texinfo-section-level">
        <xsl:with-param name="heading.class" select="'chapheading'" />
      </xsl:call-template>
    </xsl:with-param>
    <xsl:with-param name="title">Exceptions thrown</xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="refsee">
  <xsl:call-template name="section">
    <xsl:with-param name="level">
      <xsl:call-template name="get-texinfo-section-level">
        <xsl:with-param name="heading.class" select="'chapheading'" />
      </xsl:call-template>
    </xsl:with-param>
    <xsl:with-param name="title">See also</xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="refsince">
  <xsl:call-template name="section">
    <xsl:with-param name="level">
      <xsl:call-template name="get-texinfo-section-level">
        <xsl:with-param name="heading.class" select="'chapheading'" />
      </xsl:call-template>
    </xsl:with-param>
    <xsl:with-param name="title">Since</xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="refserial">
  <xsl:call-template name="section">
    <xsl:with-param name="level">
      <xsl:call-template name="get-texinfo-section-level">
        <xsl:with-param name="heading.class" select="'chapheading'" />
      </xsl:call-template>
    </xsl:with-param>
    <xsl:with-param name="title">Serial</xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="refdeprecated">
  <xsl:call-template name="section">
    <xsl:with-param name="level">
      <xsl:call-template name="get-texinfo-section-level">
        <xsl:with-param name="heading.class" select="'chapheading'" />
      </xsl:call-template>
    </xsl:with-param>
    <xsl:with-param name="title">Deprecated</xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!-- ==================================================================== -->

</xsl:stylesheet>
