// This code conforms with the UFC specification version 2016.2.0
// and was automatically generated by FFC version 2016.2.0.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   True
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'dolfin'
//   max_signature_length:           0
//   optimize:                       True
//   precision:                      15
//   quadrature_degree:              -1
//   quadrature_rule:                'auto'
//   representation:                 'uflacs'
//   split:                          True

#include "CahnHilliard3D.h"

cahnhilliard3d_finite_element_0::cahnhilliard3d_finite_element_0() : ufc::finite_element()
{
    // Do nothing
}

cahnhilliard3d_finite_element_0::~cahnhilliard3d_finite_element_0()
{
    // Do nothing
}

const char * cahnhilliard3d_finite_element_0::signature() const
{
    return "FiniteElement('Lagrange', tetrahedron, 1)";
}

ufc::shape cahnhilliard3d_finite_element_0::cell_shape() const
{
    return ufc::shape::tetrahedron;
}

std::size_t cahnhilliard3d_finite_element_0::topological_dimension() const
{
    return 3;
}

std::size_t cahnhilliard3d_finite_element_0::geometric_dimension() const
{
    return 3;
}

std::size_t cahnhilliard3d_finite_element_0::space_dimension() const
{
    return 4;
}

std::size_t cahnhilliard3d_finite_element_0::value_rank() const
{
    return 0;
}

std::size_t cahnhilliard3d_finite_element_0::value_dimension(std::size_t i) const
{
    return 1;
}

std::size_t cahnhilliard3d_finite_element_0::value_size() const
{
    return 1;
}

std::size_t cahnhilliard3d_finite_element_0::reference_value_rank() const
{
    return 0;
}

std::size_t cahnhilliard3d_finite_element_0::reference_value_dimension(std::size_t i) const
{
    return 1;
}

std::size_t cahnhilliard3d_finite_element_0::reference_value_size() const
{
    return 1;
}

std::size_t cahnhilliard3d_finite_element_0::degree() const
{
    return 1;
}

const char * cahnhilliard3d_finite_element_0::family() const
{
    return "Lagrange";
}

void cahnhilliard3d_finite_element_0::_evaluate_basis(std::size_t i,
                                    double * values,
                                    const double * x,
                                    const double * coordinate_dofs,
                                    int cell_orientation)
{
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[9]  + coordinate_dofs[6] + coordinate_dofs[3]  - coordinate_dofs[0];
    const double C1 = coordinate_dofs[10] + coordinate_dofs[7] + coordinate_dofs[4]  - coordinate_dofs[1];
    const double C2 = coordinate_dofs[11] + coordinate_dofs[8] + coordinate_dofs[5]  - coordinate_dofs[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Reset values
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    }
    
}

void cahnhilliard3d_finite_element_0::_evaluate_basis_all(double * values,
                                        const double * x,
                                        const double * coordinate_dofs,
                                        int cell_orientation)
{
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 4; r++)
    {
      _evaluate_basis(r, &dof_values, x, coordinate_dofs, cell_orientation);
      values[r] = dof_values;
    } // end loop over 'r'
}

void cahnhilliard3d_finite_element_0::_evaluate_basis_derivatives(std::size_t i,
                                                std::size_t n,
                                                double * values,
                                                const double * x,
                                                const double * coordinate_dofs,
                                                int cell_orientation)
{
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
    return ;
    }
    
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[9]  + coordinate_dofs[6] + coordinate_dofs[3]  - coordinate_dofs[0];
    const double C1 = coordinate_dofs[10] + coordinate_dofs[7] + coordinate_dofs[4]  - coordinate_dofs[1];
    const double C2 = coordinate_dofs[11] + coordinate_dofs[8] + coordinate_dofs[5]  - coordinate_dofs[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Declare two dimensional array that holds combinations of derivatives and initialise
    unsigned int combinations[3][1];
    for (unsigned int row = 0; row < 3; row++)
    {
      for (unsigned int col = 0; col < 1; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K[0], K[1], K[2]}, {K[3], K[4], K[5]}, {K[6], K[7], K[8]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double transform[3][3];
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    }
    
}

void cahnhilliard3d_finite_element_0::_evaluate_basis_derivatives_all(std::size_t n,
                                                    double * values,
                                                    const double * x,
                                                    const double * coordinate_dofs,
                                                    int cell_orientation)
{
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 4; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = 0.0;
      } // end loop over 's'
    } // end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[3];
    for (unsigned int r = 0; r < 3; r++)
    {
      dof_values[r] = 0.0;
    } // end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 4; r++)
    {
      _evaluate_basis_derivatives(r, n, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
}

double cahnhilliard3d_finite_element_0::evaluate_dof(std::size_t i,
                                   const ufc::function& f,
                                   const double * coordinate_dofs,
                                   int cell_orientation,
                                   const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    switch (i)
    {
    case 0:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      y[2] = coordinate_dofs[2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = coordinate_dofs[3];
      y[1] = coordinate_dofs[4];
      y[2] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = coordinate_dofs[6];
      y[1] = coordinate_dofs[7];
      y[2] = coordinate_dofs[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = coordinate_dofs[9];
      y[1] = coordinate_dofs[10];
      y[2] = coordinate_dofs[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
}

void cahnhilliard3d_finite_element_0::evaluate_dofs(double * values,
                                  const ufc::function& f,
                                  const double * coordinate_dofs,
                                  int cell_orientation,
                                  const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    y[2] = coordinate_dofs[2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = coordinate_dofs[3];
    y[1] = coordinate_dofs[4];
    y[2] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = coordinate_dofs[6];
    y[1] = coordinate_dofs[7];
    y[2] = coordinate_dofs[8];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = coordinate_dofs[9];
    y[1] = coordinate_dofs[10];
    y[2] = coordinate_dofs[11];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
}

void cahnhilliard3d_finite_element_0::interpolate_vertex_values(double * vertex_values,
                                              const double * dof_values,
                                              const double * coordinate_dofs,
                                              int cell_orientation,
                                              const ufc::cell& c) const
{
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
    vertex_values[3] = dof_values[3];
}

void cahnhilliard3d_finite_element_0::tabulate_dof_coordinates(double * dof_coordinates,
                                             const double * coordinate_dofs) const
{
    dof_coordinates[0] = coordinate_dofs[0];
    dof_coordinates[1] = coordinate_dofs[1];
    dof_coordinates[2] = coordinate_dofs[2];
    dof_coordinates[3] = coordinate_dofs[3];
    dof_coordinates[4] = coordinate_dofs[4];
    dof_coordinates[5] = coordinate_dofs[5];
    dof_coordinates[6] = coordinate_dofs[6];
    dof_coordinates[7] = coordinate_dofs[7];
    dof_coordinates[8] = coordinate_dofs[8];
    dof_coordinates[9] = coordinate_dofs[9];
    dof_coordinates[10] = coordinate_dofs[10];
    dof_coordinates[11] = coordinate_dofs[11];
}

std::size_t cahnhilliard3d_finite_element_0::num_sub_elements() const
{
    return 0;
}

ufc::finite_element * cahnhilliard3d_finite_element_0::create_sub_element(std::size_t i) const
{
    return 0;
}

ufc::finite_element * cahnhilliard3d_finite_element_0::create() const
{
    return new cahnhilliard3d_finite_element_0();
}


cahnhilliard3d_finite_element_1::cahnhilliard3d_finite_element_1() : ufc::finite_element()
{
    // Do nothing
}

cahnhilliard3d_finite_element_1::~cahnhilliard3d_finite_element_1()
{
    // Do nothing
}

const char * cahnhilliard3d_finite_element_1::signature() const
{
    return "VectorElement(FiniteElement('Lagrange', tetrahedron, 1), dim=3)";
}

ufc::shape cahnhilliard3d_finite_element_1::cell_shape() const
{
    return ufc::shape::tetrahedron;
}

std::size_t cahnhilliard3d_finite_element_1::topological_dimension() const
{
    return 3;
}

std::size_t cahnhilliard3d_finite_element_1::geometric_dimension() const
{
    return 3;
}

std::size_t cahnhilliard3d_finite_element_1::space_dimension() const
{
    return 12;
}

std::size_t cahnhilliard3d_finite_element_1::value_rank() const
{
    return 1;
}

std::size_t cahnhilliard3d_finite_element_1::value_dimension(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return 3;
        break;
      }
    }
    
    return 0;
}

std::size_t cahnhilliard3d_finite_element_1::value_size() const
{
    return 3;
}

std::size_t cahnhilliard3d_finite_element_1::reference_value_rank() const
{
    return 1;
}

std::size_t cahnhilliard3d_finite_element_1::reference_value_dimension(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return 3;
        break;
      }
    }
    
    return 0;
}

std::size_t cahnhilliard3d_finite_element_1::reference_value_size() const
{
    return 3;
}

std::size_t cahnhilliard3d_finite_element_1::degree() const
{
    return 1;
}

const char * cahnhilliard3d_finite_element_1::family() const
{
    return "Lagrange";
}

void cahnhilliard3d_finite_element_1::_evaluate_basis(std::size_t i,
                                    double * values,
                                    const double * x,
                                    const double * coordinate_dofs,
                                    int cell_orientation)
{
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[9]  + coordinate_dofs[6] + coordinate_dofs[3]  - coordinate_dofs[0];
    const double C1 = coordinate_dofs[10] + coordinate_dofs[7] + coordinate_dofs[4]  - coordinate_dofs[1];
    const double C2 = coordinate_dofs[11] + coordinate_dofs[8] + coordinate_dofs[5]  - coordinate_dofs[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Reset values
    values[0] = 0.0;
    values[1] = 0.0;
    values[2] = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    }
    
}

void cahnhilliard3d_finite_element_1::_evaluate_basis_all(double * values,
                                        const double * x,
                                        const double * coordinate_dofs,
                                        int cell_orientation)
{
    // Helper variable to hold values of a single dof.
    double dof_values[3] = {0.0, 0.0, 0.0};
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 12; r++)
    {
      _evaluate_basis(r, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < 3; s++)
      {
        values[r*3 + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
}

void cahnhilliard3d_finite_element_1::_evaluate_basis_derivatives(std::size_t i,
                                                std::size_t n,
                                                double * values,
                                                const double * x,
                                                const double * coordinate_dofs,
                                                int cell_orientation)
{
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < 3*num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
    return ;
    }
    
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[9]  + coordinate_dofs[6] + coordinate_dofs[3]  - coordinate_dofs[0];
    const double C1 = coordinate_dofs[10] + coordinate_dofs[7] + coordinate_dofs[4]  - coordinate_dofs[1];
    const double C2 = coordinate_dofs[11] + coordinate_dofs[8] + coordinate_dofs[5]  - coordinate_dofs[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Declare two dimensional array that holds combinations of derivatives and initialise
    unsigned int combinations[3][1];
    for (unsigned int row = 0; row < 3; row++)
    {
      for (unsigned int col = 0; col < 1; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K[0], K[1], K[2]}, {K[3], K[4], K[5]}, {K[6], K[7], K[8]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double transform[3][3];
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    }
    
}

void cahnhilliard3d_finite_element_1::_evaluate_basis_derivatives_all(std::size_t n,
                                                    double * values,
                                                    const double * x,
                                                    const double * coordinate_dofs,
                                                    int cell_orientation)
{
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 12; r++)
    {
      for (unsigned int s = 0; s < 3*num_derivatives; s++)
      {
        values[r*3*num_derivatives + s] = 0.0;
      } // end loop over 's'
    } // end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[9];
    for (unsigned int r = 0; r < 9; r++)
    {
      dof_values[r] = 0.0;
    } // end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 12; r++)
    {
      _evaluate_basis_derivatives(r, n, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < 3*num_derivatives; s++)
      {
        values[r*3*num_derivatives + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
}

double cahnhilliard3d_finite_element_1::evaluate_dof(std::size_t i,
                                   const ufc::function& f,
                                   const double * coordinate_dofs,
                                   int cell_orientation,
                                   const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[3];
    
    // Declare variable for physical coordinates
    double y[3];
    switch (i)
    {
    case 0:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      y[2] = coordinate_dofs[2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = coordinate_dofs[3];
      y[1] = coordinate_dofs[4];
      y[2] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = coordinate_dofs[6];
      y[1] = coordinate_dofs[7];
      y[2] = coordinate_dofs[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = coordinate_dofs[9];
      y[1] = coordinate_dofs[10];
      y[2] = coordinate_dofs[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      y[2] = coordinate_dofs[2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 5:
      {
        y[0] = coordinate_dofs[3];
      y[1] = coordinate_dofs[4];
      y[2] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 6:
      {
        y[0] = coordinate_dofs[6];
      y[1] = coordinate_dofs[7];
      y[2] = coordinate_dofs[8];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 7:
      {
        y[0] = coordinate_dofs[9];
      y[1] = coordinate_dofs[10];
      y[2] = coordinate_dofs[11];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 8:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      y[2] = coordinate_dofs[2];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 9:
      {
        y[0] = coordinate_dofs[3];
      y[1] = coordinate_dofs[4];
      y[2] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 10:
      {
        y[0] = coordinate_dofs[6];
      y[1] = coordinate_dofs[7];
      y[2] = coordinate_dofs[8];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 11:
      {
        y[0] = coordinate_dofs[9];
      y[1] = coordinate_dofs[10];
      y[2] = coordinate_dofs[11];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    }
    
    return 0.0;
}

void cahnhilliard3d_finite_element_1::evaluate_dofs(double * values,
                                  const ufc::function& f,
                                  const double * coordinate_dofs,
                                  int cell_orientation,
                                  const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[3];
    
    // Declare variable for physical coordinates
    double y[3];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    y[2] = coordinate_dofs[2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    values[4] = vals[1];
    values[8] = vals[2];
    y[0] = coordinate_dofs[3];
    y[1] = coordinate_dofs[4];
    y[2] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    values[5] = vals[1];
    values[9] = vals[2];
    y[0] = coordinate_dofs[6];
    y[1] = coordinate_dofs[7];
    y[2] = coordinate_dofs[8];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    values[6] = vals[1];
    values[10] = vals[2];
    y[0] = coordinate_dofs[9];
    y[1] = coordinate_dofs[10];
    y[2] = coordinate_dofs[11];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    values[7] = vals[1];
    values[11] = vals[2];
}

void cahnhilliard3d_finite_element_1::interpolate_vertex_values(double * vertex_values,
                                              const double * dof_values,
                                              const double * coordinate_dofs,
                                              int cell_orientation,
                                              const ufc::cell& c) const
{
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[3] = dof_values[1];
    vertex_values[6] = dof_values[2];
    vertex_values[9] = dof_values[3];
    // Evaluate function and change variables
    vertex_values[1] = dof_values[4];
    vertex_values[4] = dof_values[5];
    vertex_values[7] = dof_values[6];
    vertex_values[10] = dof_values[7];
    // Evaluate function and change variables
    vertex_values[2] = dof_values[8];
    vertex_values[5] = dof_values[9];
    vertex_values[8] = dof_values[10];
    vertex_values[11] = dof_values[11];
}

void cahnhilliard3d_finite_element_1::tabulate_dof_coordinates(double * dof_coordinates,
                                             const double * coordinate_dofs) const
{
    dof_coordinates[0] = coordinate_dofs[0];
    dof_coordinates[1] = coordinate_dofs[1];
    dof_coordinates[2] = coordinate_dofs[2];
    dof_coordinates[3] = coordinate_dofs[3];
    dof_coordinates[4] = coordinate_dofs[4];
    dof_coordinates[5] = coordinate_dofs[5];
    dof_coordinates[6] = coordinate_dofs[6];
    dof_coordinates[7] = coordinate_dofs[7];
    dof_coordinates[8] = coordinate_dofs[8];
    dof_coordinates[9] = coordinate_dofs[9];
    dof_coordinates[10] = coordinate_dofs[10];
    dof_coordinates[11] = coordinate_dofs[11];
    dof_coordinates[12] = coordinate_dofs[0];
    dof_coordinates[13] = coordinate_dofs[1];
    dof_coordinates[14] = coordinate_dofs[2];
    dof_coordinates[15] = coordinate_dofs[3];
    dof_coordinates[16] = coordinate_dofs[4];
    dof_coordinates[17] = coordinate_dofs[5];
    dof_coordinates[18] = coordinate_dofs[6];
    dof_coordinates[19] = coordinate_dofs[7];
    dof_coordinates[20] = coordinate_dofs[8];
    dof_coordinates[21] = coordinate_dofs[9];
    dof_coordinates[22] = coordinate_dofs[10];
    dof_coordinates[23] = coordinate_dofs[11];
    dof_coordinates[24] = coordinate_dofs[0];
    dof_coordinates[25] = coordinate_dofs[1];
    dof_coordinates[26] = coordinate_dofs[2];
    dof_coordinates[27] = coordinate_dofs[3];
    dof_coordinates[28] = coordinate_dofs[4];
    dof_coordinates[29] = coordinate_dofs[5];
    dof_coordinates[30] = coordinate_dofs[6];
    dof_coordinates[31] = coordinate_dofs[7];
    dof_coordinates[32] = coordinate_dofs[8];
    dof_coordinates[33] = coordinate_dofs[9];
    dof_coordinates[34] = coordinate_dofs[10];
    dof_coordinates[35] = coordinate_dofs[11];
}

std::size_t cahnhilliard3d_finite_element_1::num_sub_elements() const
{
    return 3;
}

ufc::finite_element * cahnhilliard3d_finite_element_1::create_sub_element(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new cahnhilliard3d_finite_element_0();
        break;
      }
    case 1:
      {
        return new cahnhilliard3d_finite_element_0();
        break;
      }
    case 2:
      {
        return new cahnhilliard3d_finite_element_0();
        break;
      }
    }
    
    return 0;
}

ufc::finite_element * cahnhilliard3d_finite_element_1::create() const
{
    return new cahnhilliard3d_finite_element_1();
}


cahnhilliard3d_finite_element_2::cahnhilliard3d_finite_element_2() : ufc::finite_element()
{
    // Do nothing
}

cahnhilliard3d_finite_element_2::~cahnhilliard3d_finite_element_2()
{
    // Do nothing
}

const char * cahnhilliard3d_finite_element_2::signature() const
{
    return "MixedElement(FiniteElement('Lagrange', tetrahedron, 1), FiniteElement('Lagrange', tetrahedron, 1))";
}

ufc::shape cahnhilliard3d_finite_element_2::cell_shape() const
{
    return ufc::shape::tetrahedron;
}

std::size_t cahnhilliard3d_finite_element_2::topological_dimension() const
{
    return 3;
}

std::size_t cahnhilliard3d_finite_element_2::geometric_dimension() const
{
    return 3;
}

std::size_t cahnhilliard3d_finite_element_2::space_dimension() const
{
    return 8;
}

std::size_t cahnhilliard3d_finite_element_2::value_rank() const
{
    return 1;
}

std::size_t cahnhilliard3d_finite_element_2::value_dimension(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return 2;
        break;
      }
    }
    
    return 0;
}

std::size_t cahnhilliard3d_finite_element_2::value_size() const
{
    return 2;
}

std::size_t cahnhilliard3d_finite_element_2::reference_value_rank() const
{
    return 1;
}

std::size_t cahnhilliard3d_finite_element_2::reference_value_dimension(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return 2;
        break;
      }
    }
    
    return 0;
}

std::size_t cahnhilliard3d_finite_element_2::reference_value_size() const
{
    return 2;
}

std::size_t cahnhilliard3d_finite_element_2::degree() const
{
    return 1;
}

const char * cahnhilliard3d_finite_element_2::family() const
{
    return "Mixed";
}

void cahnhilliard3d_finite_element_2::_evaluate_basis(std::size_t i,
                                    double * values,
                                    const double * x,
                                    const double * coordinate_dofs,
                                    int cell_orientation)
{
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[9]  + coordinate_dofs[6] + coordinate_dofs[3]  - coordinate_dofs[0];
    const double C1 = coordinate_dofs[10] + coordinate_dofs[7] + coordinate_dofs[4]  - coordinate_dofs[1];
    const double C2 = coordinate_dofs[11] + coordinate_dofs[8] + coordinate_dofs[5]  - coordinate_dofs[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Reset values
    values[0] = 0.0;
    values[1] = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    }
    
}

void cahnhilliard3d_finite_element_2::_evaluate_basis_all(double * values,
                                        const double * x,
                                        const double * coordinate_dofs,
                                        int cell_orientation)
{
    // Helper variable to hold values of a single dof.
    double dof_values[2] = {0.0, 0.0};
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 8; r++)
    {
      _evaluate_basis(r, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < 2; s++)
      {
        values[r*2 + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
}

void cahnhilliard3d_finite_element_2::_evaluate_basis_derivatives(std::size_t i,
                                                std::size_t n,
                                                double * values,
                                                const double * x,
                                                const double * coordinate_dofs,
                                                int cell_orientation)
{
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < 2*num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
    return ;
    }
    
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[9]  + coordinate_dofs[6] + coordinate_dofs[3]  - coordinate_dofs[0];
    const double C1 = coordinate_dofs[10] + coordinate_dofs[7] + coordinate_dofs[4]  - coordinate_dofs[1];
    const double C2 = coordinate_dofs[11] + coordinate_dofs[8] + coordinate_dofs[5]  - coordinate_dofs[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Declare two dimensional array that holds combinations of derivatives and initialise
    unsigned int combinations[3][1];
    for (unsigned int row = 0; row < 3; row++)
    {
      for (unsigned int col = 0; col < 1; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K[0], K[1], K[2]}, {K[3], K[4], K[5]}, {K[6], K[7], K[8]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double transform[3][3];
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    }
    
}

void cahnhilliard3d_finite_element_2::_evaluate_basis_derivatives_all(std::size_t n,
                                                    double * values,
                                                    const double * x,
                                                    const double * coordinate_dofs,
                                                    int cell_orientation)
{
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 8; r++)
    {
      for (unsigned int s = 0; s < 2*num_derivatives; s++)
      {
        values[r*2*num_derivatives + s] = 0.0;
      } // end loop over 's'
    } // end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[6];
    for (unsigned int r = 0; r < 6; r++)
    {
      dof_values[r] = 0.0;
    } // end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 8; r++)
    {
      _evaluate_basis_derivatives(r, n, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < 2*num_derivatives; s++)
      {
        values[r*2*num_derivatives + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
}

double cahnhilliard3d_finite_element_2::evaluate_dof(std::size_t i,
                                   const ufc::function& f,
                                   const double * coordinate_dofs,
                                   int cell_orientation,
                                   const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[2];
    
    // Declare variable for physical coordinates
    double y[3];
    switch (i)
    {
    case 0:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      y[2] = coordinate_dofs[2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = coordinate_dofs[3];
      y[1] = coordinate_dofs[4];
      y[2] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = coordinate_dofs[6];
      y[1] = coordinate_dofs[7];
      y[2] = coordinate_dofs[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = coordinate_dofs[9];
      y[1] = coordinate_dofs[10];
      y[2] = coordinate_dofs[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      y[2] = coordinate_dofs[2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 5:
      {
        y[0] = coordinate_dofs[3];
      y[1] = coordinate_dofs[4];
      y[2] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 6:
      {
        y[0] = coordinate_dofs[6];
      y[1] = coordinate_dofs[7];
      y[2] = coordinate_dofs[8];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 7:
      {
        y[0] = coordinate_dofs[9];
      y[1] = coordinate_dofs[10];
      y[2] = coordinate_dofs[11];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    }
    
    return 0.0;
}

void cahnhilliard3d_finite_element_2::evaluate_dofs(double * values,
                                  const ufc::function& f,
                                  const double * coordinate_dofs,
                                  int cell_orientation,
                                  const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[2];
    
    // Declare variable for physical coordinates
    double y[3];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    y[2] = coordinate_dofs[2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    values[4] = vals[1];
    y[0] = coordinate_dofs[3];
    y[1] = coordinate_dofs[4];
    y[2] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    values[5] = vals[1];
    y[0] = coordinate_dofs[6];
    y[1] = coordinate_dofs[7];
    y[2] = coordinate_dofs[8];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    values[6] = vals[1];
    y[0] = coordinate_dofs[9];
    y[1] = coordinate_dofs[10];
    y[2] = coordinate_dofs[11];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    values[7] = vals[1];
}

void cahnhilliard3d_finite_element_2::interpolate_vertex_values(double * vertex_values,
                                              const double * dof_values,
                                              const double * coordinate_dofs,
                                              int cell_orientation,
                                              const ufc::cell& c) const
{
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[2] = dof_values[1];
    vertex_values[4] = dof_values[2];
    vertex_values[6] = dof_values[3];
    // Evaluate function and change variables
    vertex_values[1] = dof_values[4];
    vertex_values[3] = dof_values[5];
    vertex_values[5] = dof_values[6];
    vertex_values[7] = dof_values[7];
}

void cahnhilliard3d_finite_element_2::tabulate_dof_coordinates(double * dof_coordinates,
                                             const double * coordinate_dofs) const
{
    dof_coordinates[0] = coordinate_dofs[0];
    dof_coordinates[1] = coordinate_dofs[1];
    dof_coordinates[2] = coordinate_dofs[2];
    dof_coordinates[3] = coordinate_dofs[3];
    dof_coordinates[4] = coordinate_dofs[4];
    dof_coordinates[5] = coordinate_dofs[5];
    dof_coordinates[6] = coordinate_dofs[6];
    dof_coordinates[7] = coordinate_dofs[7];
    dof_coordinates[8] = coordinate_dofs[8];
    dof_coordinates[9] = coordinate_dofs[9];
    dof_coordinates[10] = coordinate_dofs[10];
    dof_coordinates[11] = coordinate_dofs[11];
    dof_coordinates[12] = coordinate_dofs[0];
    dof_coordinates[13] = coordinate_dofs[1];
    dof_coordinates[14] = coordinate_dofs[2];
    dof_coordinates[15] = coordinate_dofs[3];
    dof_coordinates[16] = coordinate_dofs[4];
    dof_coordinates[17] = coordinate_dofs[5];
    dof_coordinates[18] = coordinate_dofs[6];
    dof_coordinates[19] = coordinate_dofs[7];
    dof_coordinates[20] = coordinate_dofs[8];
    dof_coordinates[21] = coordinate_dofs[9];
    dof_coordinates[22] = coordinate_dofs[10];
    dof_coordinates[23] = coordinate_dofs[11];
}

std::size_t cahnhilliard3d_finite_element_2::num_sub_elements() const
{
    return 2;
}

ufc::finite_element * cahnhilliard3d_finite_element_2::create_sub_element(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new cahnhilliard3d_finite_element_0();
        break;
      }
    case 1:
      {
        return new cahnhilliard3d_finite_element_0();
        break;
      }
    }
    
    return 0;
}

ufc::finite_element * cahnhilliard3d_finite_element_2::create() const
{
    return new cahnhilliard3d_finite_element_2();
}


cahnhilliard3d_finite_element_3::cahnhilliard3d_finite_element_3() : ufc::finite_element()
{
    // Do nothing
}

cahnhilliard3d_finite_element_3::~cahnhilliard3d_finite_element_3()
{
    // Do nothing
}

const char * cahnhilliard3d_finite_element_3::signature() const
{
    return "FiniteElement('Real', tetrahedron, 0)";
}

ufc::shape cahnhilliard3d_finite_element_3::cell_shape() const
{
    return ufc::shape::tetrahedron;
}

std::size_t cahnhilliard3d_finite_element_3::topological_dimension() const
{
    return 3;
}

std::size_t cahnhilliard3d_finite_element_3::geometric_dimension() const
{
    return 3;
}

std::size_t cahnhilliard3d_finite_element_3::space_dimension() const
{
    return 1;
}

std::size_t cahnhilliard3d_finite_element_3::value_rank() const
{
    return 0;
}

std::size_t cahnhilliard3d_finite_element_3::value_dimension(std::size_t i) const
{
    return 1;
}

std::size_t cahnhilliard3d_finite_element_3::value_size() const
{
    return 1;
}

std::size_t cahnhilliard3d_finite_element_3::reference_value_rank() const
{
    return 0;
}

std::size_t cahnhilliard3d_finite_element_3::reference_value_dimension(std::size_t i) const
{
    return 1;
}

std::size_t cahnhilliard3d_finite_element_3::reference_value_size() const
{
    return 1;
}

std::size_t cahnhilliard3d_finite_element_3::degree() const
{
    return 0;
}

const char * cahnhilliard3d_finite_element_3::family() const
{
    return "Real";
}

void cahnhilliard3d_finite_element_3::_evaluate_basis(std::size_t i,
                                    double * values,
                                    const double * x,
                                    const double * coordinate_dofs,
                                    int cell_orientation)
{
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    
    // Compute subdeterminants
    
    // Get coordinates and map to the reference (FIAT) element
    
    
    // Reset values
    *values = 0.0;
    
    // Array of basisvalues
    double basisvalues[1] = {0.0};
    
    // Declare helper variables
    
    // Compute basisvalues
    basisvalues[0] = 1.0;
    
    // Table(s) of coefficients
    static const double coefficients0[1] = \
    {1.0};
    
    // Compute value(s)
    for (unsigned int r = 0; r < 1; r++)
    {
      *values += coefficients0[r]*basisvalues[r];
    } // end loop over 'r'
}

void cahnhilliard3d_finite_element_3::_evaluate_basis_all(double * values,
                                        const double * x,
                                        const double * coordinate_dofs,
                                        int cell_orientation)
{
    // Element is constant, calling evaluate_basis.
    _evaluate_basis(0, values, x, coordinate_dofs, cell_orientation);
}

void cahnhilliard3d_finite_element_3::_evaluate_basis_derivatives(std::size_t i,
                                                std::size_t n,
                                                double * values,
                                                const double * x,
                                                const double * coordinate_dofs,
                                                int cell_orientation)
{
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 0)
    {
    return ;
    }
    
}

void cahnhilliard3d_finite_element_3::_evaluate_basis_derivatives_all(std::size_t n,
                                                    double * values,
                                                    const double * x,
                                                    const double * coordinate_dofs,
                                                    int cell_orientation)
{
    // Element is constant, calling evaluate_basis_derivatives.
    _evaluate_basis_derivatives(0, n, values, x, coordinate_dofs, cell_orientation);
}

double cahnhilliard3d_finite_element_3::evaluate_dof(std::size_t i,
                                   const ufc::function& f,
                                   const double * coordinate_dofs,
                                   int cell_orientation,
                                   const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    switch (i)
    {
    case 0:
      {
        y[0] = 0.25*coordinate_dofs[0] + 0.25*coordinate_dofs[3] + 0.25*coordinate_dofs[6] + 0.25*coordinate_dofs[9];
      y[1] = 0.25*coordinate_dofs[1] + 0.25*coordinate_dofs[4] + 0.25*coordinate_dofs[7] + 0.25*coordinate_dofs[10];
      y[2] = 0.25*coordinate_dofs[2] + 0.25*coordinate_dofs[5] + 0.25*coordinate_dofs[8] + 0.25*coordinate_dofs[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
}

void cahnhilliard3d_finite_element_3::evaluate_dofs(double * values,
                                  const ufc::function& f,
                                  const double * coordinate_dofs,
                                  int cell_orientation,
                                  const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    y[0] = 0.25*coordinate_dofs[0] + 0.25*coordinate_dofs[3] + 0.25*coordinate_dofs[6] + 0.25*coordinate_dofs[9];
    y[1] = 0.25*coordinate_dofs[1] + 0.25*coordinate_dofs[4] + 0.25*coordinate_dofs[7] + 0.25*coordinate_dofs[10];
    y[2] = 0.25*coordinate_dofs[2] + 0.25*coordinate_dofs[5] + 0.25*coordinate_dofs[8] + 0.25*coordinate_dofs[11];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
}

void cahnhilliard3d_finite_element_3::interpolate_vertex_values(double * vertex_values,
                                              const double * dof_values,
                                              const double * coordinate_dofs,
                                              int cell_orientation,
                                              const ufc::cell& c) const
{
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[0];
    vertex_values[2] = dof_values[0];
    vertex_values[3] = dof_values[0];
}

void cahnhilliard3d_finite_element_3::tabulate_dof_coordinates(double * dof_coordinates,
                                             const double * coordinate_dofs) const
{
    dof_coordinates[0] = 0.25*coordinate_dofs[0] + 0.25*coordinate_dofs[3] + 0.25*coordinate_dofs[6] + 0.25*coordinate_dofs[9];
    dof_coordinates[1] = 0.25*coordinate_dofs[1] + 0.25*coordinate_dofs[4] + 0.25*coordinate_dofs[7] + 0.25*coordinate_dofs[10];
    dof_coordinates[2] = 0.25*coordinate_dofs[2] + 0.25*coordinate_dofs[5] + 0.25*coordinate_dofs[8] + 0.25*coordinate_dofs[11];
}

std::size_t cahnhilliard3d_finite_element_3::num_sub_elements() const
{
    return 0;
}

ufc::finite_element * cahnhilliard3d_finite_element_3::create_sub_element(std::size_t i) const
{
    return 0;
}

ufc::finite_element * cahnhilliard3d_finite_element_3::create() const
{
    return new cahnhilliard3d_finite_element_3();
}


cahnhilliard3d_dofmap_0::cahnhilliard3d_dofmap_0() : ufc::dofmap()
{
    // Do nothing
}

cahnhilliard3d_dofmap_0::~cahnhilliard3d_dofmap_0()
{
    // Do nothing
}

const char * cahnhilliard3d_dofmap_0::signature() const
{
    return "FFC dofmap for FiniteElement('Lagrange', tetrahedron, 1)";
}

bool cahnhilliard3d_dofmap_0::needs_mesh_entities(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
}

std::size_t cahnhilliard3d_dofmap_0::topological_dimension() const
{
    return 3;
}

std::size_t cahnhilliard3d_dofmap_0::global_dimension(const std::vector<std::size_t>&
                                            num_global_entities) const
{
    return num_global_entities[0];
}

std::size_t cahnhilliard3d_dofmap_0::num_element_dofs() const
{
    return 4;
}

std::size_t cahnhilliard3d_dofmap_0::num_facet_dofs() const
{
    return 3;
}

std::size_t cahnhilliard3d_dofmap_0::num_entity_dofs(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
}

std::size_t cahnhilliard3d_dofmap_0::num_entity_closure_dofs(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 2;
        break;
      }
    case 2:
      {
        return 3;
        break;
      }
    case 3:
      {
        return 4;
        break;
      }
    }
    
    return 0;
}

void cahnhilliard3d_dofmap_0::tabulate_dofs(std::size_t * dofs,
                                  const std::vector<std::size_t>& num_global_entities,
                                  const std::vector<std::vector<std::size_t>>& entity_indices) const
{
    dofs[0] = entity_indices[0][0];
    dofs[1] = entity_indices[0][1];
    dofs[2] = entity_indices[0][2];
    dofs[3] = entity_indices[0][3];
}

void cahnhilliard3d_dofmap_0::tabulate_facet_dofs(std::size_t * dofs,
                                        std::size_t facet) const
{
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
        break;
      }
    }
    
}

void cahnhilliard3d_dofmap_0::tabulate_entity_dofs(std::size_t * dofs,
                                         std::size_t d, std::size_t i) const
{
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
}

void cahnhilliard3d_dofmap_0::tabulate_entity_closure_dofs(std::size_t * dofs,
                                             std::size_t d, std::size_t i) const
{
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 5)
      {
      throw std::runtime_error("i is larger than number of entities (5)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 2;
        dofs[1] = 3;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
        dofs[1] = 3;
          break;
        }
      case 2:
        {
          dofs[0] = 1;
        dofs[1] = 2;
          break;
        }
      case 3:
        {
          dofs[0] = 0;
        dofs[1] = 3;
          break;
        }
      case 4:
        {
          dofs[0] = 0;
        dofs[1] = 2;
          break;
        }
      case 5:
        {
          dofs[0] = 0;
        dofs[1] = 1;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 1;
        dofs[1] = 2;
        dofs[2] = 3;
          break;
        }
      case 1:
        {
          dofs[0] = 0;
        dofs[1] = 2;
        dofs[2] = 3;
          break;
        }
      case 2:
        {
          dofs[0] = 0;
        dofs[1] = 1;
        dofs[2] = 3;
          break;
        }
      case 3:
        {
          dofs[0] = 0;
        dofs[1] = 1;
        dofs[2] = 2;
          break;
        }
      }
      
        break;
      }
    case 3:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 3;
        break;
      }
    }
    
}

std::size_t cahnhilliard3d_dofmap_0::num_sub_dofmaps() const
{
    return 0;
}

ufc::dofmap * cahnhilliard3d_dofmap_0::create_sub_dofmap(std::size_t i) const
{
    return 0;
}

ufc::dofmap * cahnhilliard3d_dofmap_0::create() const
{
    return new cahnhilliard3d_dofmap_0();
}


cahnhilliard3d_dofmap_1::cahnhilliard3d_dofmap_1() : ufc::dofmap()
{
    // Do nothing
}

cahnhilliard3d_dofmap_1::~cahnhilliard3d_dofmap_1()
{
    // Do nothing
}

const char * cahnhilliard3d_dofmap_1::signature() const
{
    return "FFC dofmap for VectorElement(FiniteElement('Lagrange', tetrahedron, 1), dim=3)";
}

bool cahnhilliard3d_dofmap_1::needs_mesh_entities(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
}

std::size_t cahnhilliard3d_dofmap_1::topological_dimension() const
{
    return 3;
}

std::size_t cahnhilliard3d_dofmap_1::global_dimension(const std::vector<std::size_t>&
                                            num_global_entities) const
{
    return 3*num_global_entities[0];
}

std::size_t cahnhilliard3d_dofmap_1::num_element_dofs() const
{
    return 12;
}

std::size_t cahnhilliard3d_dofmap_1::num_facet_dofs() const
{
    return 9;
}

std::size_t cahnhilliard3d_dofmap_1::num_entity_dofs(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return 3;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
}

std::size_t cahnhilliard3d_dofmap_1::num_entity_closure_dofs(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return 3;
        break;
      }
    case 1:
      {
        return 6;
        break;
      }
    case 2:
      {
        return 9;
        break;
      }
    case 3:
      {
        return 12;
        break;
      }
    }
    
    return 0;
}

void cahnhilliard3d_dofmap_1::tabulate_dofs(std::size_t * dofs,
                                  const std::vector<std::size_t>& num_global_entities,
                                  const std::vector<std::vector<std::size_t>>& entity_indices) const
{
    unsigned int offset = 0;
    dofs[0] = offset + entity_indices[0][0];
    dofs[1] = offset + entity_indices[0][1];
    dofs[2] = offset + entity_indices[0][2];
    dofs[3] = offset + entity_indices[0][3];
    offset += num_global_entities[0];
    dofs[4] = offset + entity_indices[0][0];
    dofs[5] = offset + entity_indices[0][1];
    dofs[6] = offset + entity_indices[0][2];
    dofs[7] = offset + entity_indices[0][3];
    offset += num_global_entities[0];
    dofs[8] = offset + entity_indices[0][0];
    dofs[9] = offset + entity_indices[0][1];
    dofs[10] = offset + entity_indices[0][2];
    dofs[11] = offset + entity_indices[0][3];
    offset += num_global_entities[0];
}

void cahnhilliard3d_dofmap_1::tabulate_facet_dofs(std::size_t * dofs,
                                        std::size_t facet) const
{
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 5;
      dofs[4] = 6;
      dofs[5] = 7;
      dofs[6] = 9;
      dofs[7] = 10;
      dofs[8] = 11;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 6;
      dofs[5] = 7;
      dofs[6] = 8;
      dofs[7] = 10;
      dofs[8] = 11;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 7;
      dofs[6] = 8;
      dofs[7] = 9;
      dofs[8] = 11;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 6;
      dofs[6] = 8;
      dofs[7] = 9;
      dofs[8] = 10;
        break;
      }
    }
    
}

void cahnhilliard3d_dofmap_1::tabulate_entity_dofs(std::size_t * dofs,
                                         std::size_t d, std::size_t i) const
{
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
        dofs[1] = 4;
        dofs[2] = 8;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
        dofs[1] = 5;
        dofs[2] = 9;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
        dofs[1] = 6;
        dofs[2] = 10;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
        dofs[1] = 7;
        dofs[2] = 11;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
}

void cahnhilliard3d_dofmap_1::tabulate_entity_closure_dofs(std::size_t * dofs,
                                             std::size_t d, std::size_t i) const
{
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
        dofs[1] = 4;
        dofs[2] = 8;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
        dofs[1] = 5;
        dofs[2] = 9;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
        dofs[1] = 6;
        dofs[2] = 10;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
        dofs[1] = 7;
        dofs[2] = 11;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 5)
      {
      throw std::runtime_error("i is larger than number of entities (5)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 2;
        dofs[1] = 3;
        dofs[2] = 6;
        dofs[3] = 7;
        dofs[4] = 10;
        dofs[5] = 11;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
        dofs[1] = 3;
        dofs[2] = 5;
        dofs[3] = 7;
        dofs[4] = 9;
        dofs[5] = 11;
          break;
        }
      case 2:
        {
          dofs[0] = 1;
        dofs[1] = 2;
        dofs[2] = 5;
        dofs[3] = 6;
        dofs[4] = 9;
        dofs[5] = 10;
          break;
        }
      case 3:
        {
          dofs[0] = 0;
        dofs[1] = 3;
        dofs[2] = 4;
        dofs[3] = 7;
        dofs[4] = 8;
        dofs[5] = 11;
          break;
        }
      case 4:
        {
          dofs[0] = 0;
        dofs[1] = 2;
        dofs[2] = 4;
        dofs[3] = 6;
        dofs[4] = 8;
        dofs[5] = 10;
          break;
        }
      case 5:
        {
          dofs[0] = 0;
        dofs[1] = 1;
        dofs[2] = 4;
        dofs[3] = 5;
        dofs[4] = 8;
        dofs[5] = 9;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 1;
        dofs[1] = 2;
        dofs[2] = 3;
        dofs[3] = 5;
        dofs[4] = 6;
        dofs[5] = 7;
        dofs[6] = 9;
        dofs[7] = 10;
        dofs[8] = 11;
          break;
        }
      case 1:
        {
          dofs[0] = 0;
        dofs[1] = 2;
        dofs[2] = 3;
        dofs[3] = 4;
        dofs[4] = 6;
        dofs[5] = 7;
        dofs[6] = 8;
        dofs[7] = 10;
        dofs[8] = 11;
          break;
        }
      case 2:
        {
          dofs[0] = 0;
        dofs[1] = 1;
        dofs[2] = 3;
        dofs[3] = 4;
        dofs[4] = 5;
        dofs[5] = 7;
        dofs[6] = 8;
        dofs[7] = 9;
        dofs[8] = 11;
          break;
        }
      case 3:
        {
          dofs[0] = 0;
        dofs[1] = 1;
        dofs[2] = 2;
        dofs[3] = 4;
        dofs[4] = 5;
        dofs[5] = 6;
        dofs[6] = 8;
        dofs[7] = 9;
        dofs[8] = 10;
          break;
        }
      }
      
        break;
      }
    case 3:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 3;
      dofs[4] = 4;
      dofs[5] = 5;
      dofs[6] = 6;
      dofs[7] = 7;
      dofs[8] = 8;
      dofs[9] = 9;
      dofs[10] = 10;
      dofs[11] = 11;
        break;
      }
    }
    
}

std::size_t cahnhilliard3d_dofmap_1::num_sub_dofmaps() const
{
    return 3;
}

ufc::dofmap * cahnhilliard3d_dofmap_1::create_sub_dofmap(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new cahnhilliard3d_dofmap_0();
        break;
      }
    case 1:
      {
        return new cahnhilliard3d_dofmap_0();
        break;
      }
    case 2:
      {
        return new cahnhilliard3d_dofmap_0();
        break;
      }
    }
    
    return 0;
}

ufc::dofmap * cahnhilliard3d_dofmap_1::create() const
{
    return new cahnhilliard3d_dofmap_1();
}


cahnhilliard3d_dofmap_2::cahnhilliard3d_dofmap_2() : ufc::dofmap()
{
    // Do nothing
}

cahnhilliard3d_dofmap_2::~cahnhilliard3d_dofmap_2()
{
    // Do nothing
}

const char * cahnhilliard3d_dofmap_2::signature() const
{
    return "FFC dofmap for MixedElement(FiniteElement('Lagrange', tetrahedron, 1), FiniteElement('Lagrange', tetrahedron, 1))";
}

bool cahnhilliard3d_dofmap_2::needs_mesh_entities(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
}

std::size_t cahnhilliard3d_dofmap_2::topological_dimension() const
{
    return 3;
}

std::size_t cahnhilliard3d_dofmap_2::global_dimension(const std::vector<std::size_t>&
                                            num_global_entities) const
{
    return 2*num_global_entities[0];
}

std::size_t cahnhilliard3d_dofmap_2::num_element_dofs() const
{
    return 8;
}

std::size_t cahnhilliard3d_dofmap_2::num_facet_dofs() const
{
    return 6;
}

std::size_t cahnhilliard3d_dofmap_2::num_entity_dofs(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return 2;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
}

std::size_t cahnhilliard3d_dofmap_2::num_entity_closure_dofs(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return 2;
        break;
      }
    case 1:
      {
        return 4;
        break;
      }
    case 2:
      {
        return 6;
        break;
      }
    case 3:
      {
        return 8;
        break;
      }
    }
    
    return 0;
}

void cahnhilliard3d_dofmap_2::tabulate_dofs(std::size_t * dofs,
                                  const std::vector<std::size_t>& num_global_entities,
                                  const std::vector<std::vector<std::size_t>>& entity_indices) const
{
    unsigned int offset = 0;
    dofs[0] = offset + entity_indices[0][0];
    dofs[1] = offset + entity_indices[0][1];
    dofs[2] = offset + entity_indices[0][2];
    dofs[3] = offset + entity_indices[0][3];
    offset += num_global_entities[0];
    dofs[4] = offset + entity_indices[0][0];
    dofs[5] = offset + entity_indices[0][1];
    dofs[6] = offset + entity_indices[0][2];
    dofs[7] = offset + entity_indices[0][3];
    offset += num_global_entities[0];
}

void cahnhilliard3d_dofmap_2::tabulate_facet_dofs(std::size_t * dofs,
                                        std::size_t facet) const
{
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 5;
      dofs[4] = 6;
      dofs[5] = 7;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 6;
      dofs[5] = 7;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 7;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 6;
        break;
      }
    }
    
}

void cahnhilliard3d_dofmap_2::tabulate_entity_dofs(std::size_t * dofs,
                                         std::size_t d, std::size_t i) const
{
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
        dofs[1] = 4;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
        dofs[1] = 5;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
        dofs[1] = 6;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
        dofs[1] = 7;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
}

void cahnhilliard3d_dofmap_2::tabulate_entity_closure_dofs(std::size_t * dofs,
                                             std::size_t d, std::size_t i) const
{
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
        dofs[1] = 4;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
        dofs[1] = 5;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
        dofs[1] = 6;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
        dofs[1] = 7;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 5)
      {
      throw std::runtime_error("i is larger than number of entities (5)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 2;
        dofs[1] = 3;
        dofs[2] = 6;
        dofs[3] = 7;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
        dofs[1] = 3;
        dofs[2] = 5;
        dofs[3] = 7;
          break;
        }
      case 2:
        {
          dofs[0] = 1;
        dofs[1] = 2;
        dofs[2] = 5;
        dofs[3] = 6;
          break;
        }
      case 3:
        {
          dofs[0] = 0;
        dofs[1] = 3;
        dofs[2] = 4;
        dofs[3] = 7;
          break;
        }
      case 4:
        {
          dofs[0] = 0;
        dofs[1] = 2;
        dofs[2] = 4;
        dofs[3] = 6;
          break;
        }
      case 5:
        {
          dofs[0] = 0;
        dofs[1] = 1;
        dofs[2] = 4;
        dofs[3] = 5;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 1;
        dofs[1] = 2;
        dofs[2] = 3;
        dofs[3] = 5;
        dofs[4] = 6;
        dofs[5] = 7;
          break;
        }
      case 1:
        {
          dofs[0] = 0;
        dofs[1] = 2;
        dofs[2] = 3;
        dofs[3] = 4;
        dofs[4] = 6;
        dofs[5] = 7;
          break;
        }
      case 2:
        {
          dofs[0] = 0;
        dofs[1] = 1;
        dofs[2] = 3;
        dofs[3] = 4;
        dofs[4] = 5;
        dofs[5] = 7;
          break;
        }
      case 3:
        {
          dofs[0] = 0;
        dofs[1] = 1;
        dofs[2] = 2;
        dofs[3] = 4;
        dofs[4] = 5;
        dofs[5] = 6;
          break;
        }
      }
      
        break;
      }
    case 3:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 3;
      dofs[4] = 4;
      dofs[5] = 5;
      dofs[6] = 6;
      dofs[7] = 7;
        break;
      }
    }
    
}

std::size_t cahnhilliard3d_dofmap_2::num_sub_dofmaps() const
{
    return 2;
}

ufc::dofmap * cahnhilliard3d_dofmap_2::create_sub_dofmap(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new cahnhilliard3d_dofmap_0();
        break;
      }
    case 1:
      {
        return new cahnhilliard3d_dofmap_0();
        break;
      }
    }
    
    return 0;
}

ufc::dofmap * cahnhilliard3d_dofmap_2::create() const
{
    return new cahnhilliard3d_dofmap_2();
}


cahnhilliard3d_dofmap_3::cahnhilliard3d_dofmap_3() : ufc::dofmap()
{
    // Do nothing
}

cahnhilliard3d_dofmap_3::~cahnhilliard3d_dofmap_3()
{
    // Do nothing
}

const char * cahnhilliard3d_dofmap_3::signature() const
{
    return "FFC dofmap for FiniteElement('Real', tetrahedron, 0)";
}

bool cahnhilliard3d_dofmap_3::needs_mesh_entities(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return false;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
}

std::size_t cahnhilliard3d_dofmap_3::topological_dimension() const
{
    return 3;
}

std::size_t cahnhilliard3d_dofmap_3::global_dimension(const std::vector<std::size_t>&
                                            num_global_entities) const
{
    return 1;
}

std::size_t cahnhilliard3d_dofmap_3::num_element_dofs() const
{
    return 1;
}

std::size_t cahnhilliard3d_dofmap_3::num_facet_dofs() const
{
    return 0;
}

std::size_t cahnhilliard3d_dofmap_3::num_entity_dofs(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return 0;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 1;
        break;
      }
    }
    
    return 0;
}

std::size_t cahnhilliard3d_dofmap_3::num_entity_closure_dofs(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return 0;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 1;
        break;
      }
    }
    
    return 0;
}

void cahnhilliard3d_dofmap_3::tabulate_dofs(std::size_t * dofs,
                                  const std::vector<std::size_t>& num_global_entities,
                                  const std::vector<std::vector<std::size_t>>& entity_indices) const
{
    dofs[0] = 0;
}

void cahnhilliard3d_dofmap_3::tabulate_facet_dofs(std::size_t * dofs,
                                        std::size_t facet) const
{
    switch (facet)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
}

void cahnhilliard3d_dofmap_3::tabulate_entity_dofs(std::size_t * dofs,
                                         std::size_t d, std::size_t i) const
{
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
        break;
      }
    }
    
}

void cahnhilliard3d_dofmap_3::tabulate_entity_closure_dofs(std::size_t * dofs,
                                             std::size_t d, std::size_t i) const
{
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          
          break;
        }
      case 1:
        {
          
          break;
        }
      case 2:
        {
          
          break;
        }
      case 3:
        {
          
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 5)
      {
      throw std::runtime_error("i is larger than number of entities (5)");
      }
      
      switch (i)
      {
      case 0:
        {
          
          break;
        }
      case 1:
        {
          
          break;
        }
      case 2:
        {
          
          break;
        }
      case 3:
        {
          
          break;
        }
      case 4:
        {
          
          break;
        }
      case 5:
        {
          
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          
          break;
        }
      case 1:
        {
          
          break;
        }
      case 2:
        {
          
          break;
        }
      case 3:
        {
          
          break;
        }
      }
      
        break;
      }
    case 3:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
        break;
      }
    }
    
}

std::size_t cahnhilliard3d_dofmap_3::num_sub_dofmaps() const
{
    return 0;
}

ufc::dofmap * cahnhilliard3d_dofmap_3::create_sub_dofmap(std::size_t i) const
{
    return 0;
}

ufc::dofmap * cahnhilliard3d_dofmap_3::create() const
{
    return new cahnhilliard3d_dofmap_3();
}


cahnhilliard3d_cell_integral_0_otherwise::cahnhilliard3d_cell_integral_0_otherwise() : ufc::cell_integral()
{

}

cahnhilliard3d_cell_integral_0_otherwise::~cahnhilliard3d_cell_integral_0_otherwise()
{

}

const std::vector<bool> & cahnhilliard3d_cell_integral_0_otherwise::enabled_coefficients() const
{
static const std::vector<bool> enabled({true, true, true, true, true});
return enabled;
}

void cahnhilliard3d_cell_integral_0_otherwise::tabulate_tensor(double * A,
                                    const double * const * w,
                                    const double * coordinate_dofs,
                                    int cell_orientation) const
{
    // This function was generated using 'uflacs' representation
    // with the following integrals metadata:
    // 
    //   num_cells:         None
    //   quadrature_degree: 4
    //   quadrature_rule:   'default'
    //   representation:    'uflacs'
    // 
    // and the following integral 0 metadata:
    // 
    //   estimated_polynomial_degree: 4
    //   quadrature_degree:           4
    //   quadrature_rule:             'default'
    //   representation:              'uflacs'
    
    // Section for quadrature weights and points
    alignas(32) static const double weights14[14] = { 0.00317460317460317, 0.00317460317460317, 0.00317460317460317, 0.00317460317460317, 0.00317460317460317, 0.00317460317460317, 0.0147649707904968, 0.0147649707904968, 0.0147649707904968, 0.0147649707904968, 0.0221397911142651, 0.0221397911142651, 0.0221397911142651, 0.0221397911142651 };
    // Section for precomputed element basis function values
    // Table dimensions: num_entities, num_points, num_dofs
    // Definitions of 4 tables for 14 quadrature points
    alignas(32) static const double FE29_C0_D001_Q14[1][1][4] = { { { -1.0, 0.0, 0.0, 1.0 } } };
    alignas(32) static const double FE29_C0_D010_Q14[1][1][3] = { { { -1.0, 0.0, 1.0 } } };
    alignas(32) static const double FE29_C0_D100_Q14[1][1][2] = { { { -1.0, 1.0 } } };
    alignas(32) static const double FE29_C0_Q14[1][14][4] =
        { { { 0.0, 0.0, 0.5, 0.5 },
            { 0.0, 0.5, 0.0, 0.5 },
            { 0.0, 0.5, 0.5, 0.0 },
            { 0.5, 0.5, 0.0, 0.0 },
            { 0.5, 0.0, 0.5, 0.0 },
            { 0.5, 0.0, 0.0, 0.5 },
            { 0.100526765225205, 0.698419704324386, 0.100526765225205, 0.100526765225205 },
            { 0.698419704324387, 0.100526765225204, 0.100526765225205, 0.100526765225205 },
            { 0.100526765225205, 0.100526765225204, 0.100526765225205, 0.698419704324386 },
            { 0.100526765225205, 0.100526765225204, 0.698419704324386, 0.100526765225205 },
            { 0.314372873493192, 0.0568813795204234, 0.314372873493192, 0.314372873493192 },
            { 0.0568813795204235, 0.314372873493192, 0.314372873493192, 0.314372873493192 },
            { 0.314372873493192, 0.314372873493192, 0.314372873493192, 0.0568813795204234 },
            { 0.314372873493192, 0.314372873493192, 0.0568813795204235, 0.314372873493192 } } };
    // Reset element tensor
    memset(A, 0, 8 * sizeof(*A));
    // Unstructured piecewise computations
    double w0_d0_c0 = 0.0;
    for (int ic = 0; ic < 2; ++ic)
    {
        w0_d0_c0 += w[0][ic] * FE29_C0_D100_Q14[0][0][ic - 0];
    }
    const double J_c4 = coordinate_dofs[1] * FE29_C0_D010_Q14[0][0][0] + coordinate_dofs[4] * FE29_C0_D010_Q14[0][0][1] + coordinate_dofs[7] * FE29_C0_D010_Q14[0][0][2];
    const double J_c8 = coordinate_dofs[2] * FE29_C0_D001_Q14[0][0][0] + coordinate_dofs[5] * FE29_C0_D001_Q14[0][0][1] + coordinate_dofs[8] * FE29_C0_D001_Q14[0][0][2] + coordinate_dofs[11] * FE29_C0_D001_Q14[0][0][3];
    const double J_c5 = coordinate_dofs[1] * FE29_C0_D001_Q14[0][0][0] + coordinate_dofs[4] * FE29_C0_D001_Q14[0][0][1] + coordinate_dofs[7] * FE29_C0_D001_Q14[0][0][2] + coordinate_dofs[10] * FE29_C0_D001_Q14[0][0][3];
    const double J_c7 = coordinate_dofs[2] * FE29_C0_D010_Q14[0][0][0] + coordinate_dofs[5] * FE29_C0_D010_Q14[0][0][1] + coordinate_dofs[8] * FE29_C0_D010_Q14[0][0][2];
    const double J_c0 = coordinate_dofs[0] * FE29_C0_D100_Q14[0][0][0] + coordinate_dofs[3] * FE29_C0_D100_Q14[0][0][1];
    const double J_c1 = coordinate_dofs[0] * FE29_C0_D010_Q14[0][0][0] + coordinate_dofs[3] * FE29_C0_D010_Q14[0][0][1] + coordinate_dofs[6] * FE29_C0_D010_Q14[0][0][2];
    const double J_c6 = coordinate_dofs[2] * FE29_C0_D100_Q14[0][0][0] + coordinate_dofs[5] * FE29_C0_D100_Q14[0][0][1];
    const double J_c3 = coordinate_dofs[1] * FE29_C0_D100_Q14[0][0][0] + coordinate_dofs[4] * FE29_C0_D100_Q14[0][0][1];
    const double J_c2 = coordinate_dofs[0] * FE29_C0_D001_Q14[0][0][0] + coordinate_dofs[3] * FE29_C0_D001_Q14[0][0][1] + coordinate_dofs[6] * FE29_C0_D001_Q14[0][0][2] + coordinate_dofs[9] * FE29_C0_D001_Q14[0][0][3];
    double w0_d1_c0 = 0.0;
    for (int ic = 0; ic < 3; ++ic)
    {
        w0_d1_c0 += w[0][ic] * FE29_C0_D010_Q14[0][0][ic - 0];
    }
    double w0_d2_c0 = 0.0;
    for (int ic = 0; ic < 4; ++ic)
    {
        w0_d2_c0 += w[0][ic] * FE29_C0_D001_Q14[0][0][ic - 0];
    }
    double w1_d0_c1 = 0.0;
    for (int ic = 4; ic < 6; ++ic)
    {
        w1_d0_c1 += w[1][ic] * FE29_C0_D100_Q14[0][0][ic - 4];
    }
    double w1_d1_c1 = 0.0;
    for (int ic = 4; ic < 7; ++ic)
    {
        w1_d1_c1 += w[1][ic] * FE29_C0_D010_Q14[0][0][ic - 4];
    }
    double w1_d2_c1 = 0.0;
    for (int ic = 4; ic < 8; ++ic)
    {
        w1_d2_c1 += w[1][ic] * FE29_C0_D001_Q14[0][0][ic - 4];
    }
    double w0_d0_c1 = 0.0;
    for (int ic = 4; ic < 6; ++ic)
    {
        w0_d0_c1 += w[0][ic] * FE29_C0_D100_Q14[0][0][ic - 4];
    }
    double w0_d1_c1 = 0.0;
    for (int ic = 4; ic < 7; ++ic)
    {
        w0_d1_c1 += w[0][ic] * FE29_C0_D010_Q14[0][0][ic - 4];
    }
    double w0_d2_c1 = 0.0;
    for (int ic = 4; ic < 8; ++ic)
    {
        w0_d2_c1 += w[0][ic] * FE29_C0_D001_Q14[0][0][ic - 4];
    }
    alignas(32) double sp14[149];
    sp14[0] = J_c4 * J_c8;
    sp14[1] = J_c5 * J_c7;
    sp14[2] = -1 * sp14[1];
    sp14[3] = sp14[0] + sp14[2];
    sp14[4] = J_c0 * sp14[3];
    sp14[5] = J_c5 * J_c6;
    sp14[6] = J_c3 * J_c8;
    sp14[7] = -1 * sp14[6];
    sp14[8] = sp14[5] + sp14[7];
    sp14[9] = J_c1 * sp14[8];
    sp14[10] = sp14[4] + sp14[9];
    sp14[11] = J_c3 * J_c7;
    sp14[12] = J_c4 * J_c6;
    sp14[13] = -1 * sp14[12];
    sp14[14] = sp14[11] + sp14[13];
    sp14[15] = J_c2 * sp14[14];
    sp14[16] = sp14[10] + sp14[15];
    sp14[17] = sp14[3] / sp14[16];
    sp14[18] = w0_d0_c0 * sp14[17];
    sp14[19] = -1 * J_c8;
    sp14[20] = J_c3 * sp14[19];
    sp14[21] = sp14[5] + sp14[20];
    sp14[22] = sp14[21] / sp14[16];
    sp14[23] = w0_d1_c0 * sp14[22];
    sp14[24] = sp14[18] + sp14[23];
    sp14[25] = sp14[14] / sp14[16];
    sp14[26] = w0_d2_c0 * sp14[25];
    sp14[27] = sp14[24] + sp14[26];
    sp14[28] = sp14[27] * sp14[17];
    sp14[29] = sp14[27] * sp14[22];
    sp14[30] = sp14[27] * sp14[25];
    sp14[31] = J_c2 * J_c7;
    sp14[32] = -1 * J_c1;
    sp14[33] = J_c8 * sp14[32];
    sp14[34] = sp14[31] + sp14[33];
    sp14[35] = sp14[34] / sp14[16];
    sp14[36] = w0_d0_c0 * sp14[35];
    sp14[37] = J_c0 * J_c8;
    sp14[38] = -1 * J_c2;
    sp14[39] = J_c6 * sp14[38];
    sp14[40] = sp14[37] + sp14[39];
    sp14[41] = sp14[40] / sp14[16];
    sp14[42] = w0_d1_c0 * sp14[41];
    sp14[43] = sp14[36] + sp14[42];
    sp14[44] = J_c1 * J_c6;
    sp14[45] = J_c0 * J_c7;
    sp14[46] = -1 * sp14[45];
    sp14[47] = sp14[44] + sp14[46];
    sp14[48] = sp14[47] / sp14[16];
    sp14[49] = w0_d2_c0 * sp14[48];
    sp14[50] = sp14[43] + sp14[49];
    sp14[51] = sp14[50] * sp14[35];
    sp14[52] = sp14[50] * sp14[41];
    sp14[53] = sp14[50] * sp14[48];
    sp14[54] = sp14[51] + sp14[28];
    sp14[55] = sp14[52] + sp14[29];
    sp14[56] = sp14[30] + sp14[53];
    sp14[57] = J_c1 * J_c5;
    sp14[58] = J_c2 * J_c4;
    sp14[59] = -1 * sp14[58];
    sp14[60] = sp14[57] + sp14[59];
    sp14[61] = sp14[60] / sp14[16];
    sp14[62] = w0_d0_c0 * sp14[61];
    sp14[63] = J_c2 * J_c3;
    sp14[64] = J_c0 * J_c5;
    sp14[65] = -1 * sp14[64];
    sp14[66] = sp14[63] + sp14[65];
    sp14[67] = sp14[66] / sp14[16];
    sp14[68] = w0_d1_c0 * sp14[67];
    sp14[69] = sp14[62] + sp14[68];
    sp14[70] = J_c0 * J_c4;
    sp14[71] = J_c1 * J_c3;
    sp14[72] = -1 * sp14[71];
    sp14[73] = sp14[70] + sp14[72];
    sp14[74] = sp14[73] / sp14[16];
    sp14[75] = w0_d2_c0 * sp14[74];
    sp14[76] = sp14[69] + sp14[75];
    sp14[77] = sp14[76] * sp14[61];
    sp14[78] = sp14[76] * sp14[67];
    sp14[79] = sp14[76] * sp14[74];
    sp14[80] = sp14[54] + sp14[77];
    sp14[81] = sp14[55] + sp14[78];
    sp14[82] = sp14[56] + sp14[79];
    sp14[83] = sp14[80] * w[2][0];
    sp14[84] = sp14[81] * w[2][0];
    sp14[85] = sp14[82] * w[2][0];
    sp14[86] = -1 * sp14[83];
    sp14[87] = -1 * sp14[84];
    sp14[88] = -1 * sp14[85];
    sp14[89] = w1_d0_c1 * sp14[17];
    sp14[90] = w1_d1_c1 * sp14[22];
    sp14[91] = sp14[89] + sp14[90];
    sp14[92] = w1_d2_c1 * sp14[25];
    sp14[93] = sp14[91] + sp14[92];
    sp14[94] = -1 * w[4][0];
    sp14[95] = 1 + sp14[94];
    sp14[96] = sp14[93] * sp14[95];
    sp14[97] = w0_d0_c1 * sp14[17];
    sp14[98] = w0_d1_c1 * sp14[22];
    sp14[99] = sp14[97] + sp14[98];
    sp14[100] = w0_d2_c1 * sp14[25];
    sp14[101] = sp14[99] + sp14[100];
    sp14[102] = sp14[101] * w[4][0];
    sp14[103] = sp14[96] + sp14[102];
    sp14[104] = sp14[103] * sp14[17];
    sp14[105] = sp14[103] * sp14[22];
    sp14[106] = sp14[103] * sp14[25];
    sp14[107] = w1_d0_c1 * sp14[35];
    sp14[108] = w1_d1_c1 * sp14[41];
    sp14[109] = sp14[107] + sp14[108];
    sp14[110] = w1_d2_c1 * sp14[48];
    sp14[111] = sp14[109] + sp14[110];
    sp14[112] = sp14[111] * sp14[95];
    sp14[113] = w0_d0_c1 * sp14[35];
    sp14[114] = w0_d1_c1 * sp14[41];
    sp14[115] = sp14[113] + sp14[114];
    sp14[116] = w0_d2_c1 * sp14[48];
    sp14[117] = sp14[115] + sp14[116];
    sp14[118] = sp14[117] * w[4][0];
    sp14[119] = sp14[112] + sp14[118];
    sp14[120] = sp14[119] * sp14[35];
    sp14[121] = sp14[119] * sp14[41];
    sp14[122] = sp14[119] * sp14[48];
    sp14[123] = sp14[120] + sp14[104];
    sp14[124] = sp14[121] + sp14[105];
    sp14[125] = sp14[106] + sp14[122];
    sp14[126] = w1_d0_c1 * sp14[61];
    sp14[127] = w1_d1_c1 * sp14[67];
    sp14[128] = sp14[126] + sp14[127];
    sp14[129] = w1_d2_c1 * sp14[74];
    sp14[130] = sp14[128] + sp14[129];
    sp14[131] = sp14[130] * sp14[95];
    sp14[132] = w0_d0_c1 * sp14[61];
    sp14[133] = w0_d1_c1 * sp14[67];
    sp14[134] = sp14[132] + sp14[133];
    sp14[135] = w0_d2_c1 * sp14[74];
    sp14[136] = sp14[134] + sp14[135];
    sp14[137] = sp14[136] * w[4][0];
    sp14[138] = sp14[131] + sp14[137];
    sp14[139] = sp14[138] * sp14[61];
    sp14[140] = sp14[138] * sp14[67];
    sp14[141] = sp14[138] * sp14[74];
    sp14[142] = sp14[123] + sp14[139];
    sp14[143] = sp14[124] + sp14[140];
    sp14[144] = sp14[125] + sp14[141];
    sp14[145] = sp14[142] * w[3][0];
    sp14[146] = sp14[143] * w[3][0];
    sp14[147] = sp14[144] * w[3][0];
    sp14[148] = std::abs(sp14[16]);
    for (int iq14 = 0; iq14 < 14; ++iq14)
    {
        // Quadrature loop body setup (num_points=14)
        // Unstructured varying computations
        double w0_c0 = 0.0;
        for (int ic = 0; ic < 4; ++ic)
        {
            w0_c0 += w[0][ic] * FE29_C0_Q14[0][iq14][ic - 0];
        }
        double w0_c1 = 0.0;
        for (int ic = 4; ic < 8; ++ic)
        {
            w0_c1 += w[0][ic] * FE29_C0_Q14[0][iq14][ic - 4];
        }
        double w1_c0 = 0.0;
        for (int ic = 0; ic < 4; ++ic)
        {
            w1_c0 += w[1][ic] * FE29_C0_Q14[0][iq14][ic - 0];
        }
        alignas(32) double sv14[24];
        sv14[0] = -1 * w1_c0;
        sv14[1] = w0_c0 + sv14[0];
        sv14[2] = -1 * w0_c0;
        sv14[3] = 1 + sv14[2];
        sv14[4] = -2.0 * sv14[3];
        sv14[5] = std::pow(w0_c0, 2);
        sv14[6] = 100 * sv14[5];
        sv14[7] = sv14[4] * sv14[6];
        sv14[8] = 2.0 * w0_c0;
        sv14[9] = 100 * sv14[8];
        sv14[10] = std::pow(sv14[3], 2);
        sv14[11] = sv14[9] * sv14[10];
        sv14[12] = sv14[7] + sv14[11];
        sv14[13] = -1 * sv14[12];
        sv14[14] = w0_c1 + sv14[13];
        sv14[15] = weights14[iq14] * sp14[148];
        sv14[16] = sv14[1] * sv14[15];
        sv14[17] = sv14[14] * sv14[15];
        sv14[18] = sp14[86] * sv14[15];
        sv14[19] = sp14[87] * sv14[15];
        sv14[20] = sp14[88] * sv14[15];
        sv14[21] = sv14[15] * sp14[145];
        sv14[22] = sv14[15] * sp14[146];
        sv14[23] = sv14[15] * sp14[147];
        for (int ia0 = 0; ia0 < 2; ++ia0)
        {
            A[ia0] += sv14[21] * FE29_C0_D100_Q14[0][0][ia0 - 0];
        }
        for (int ia0 = 0; ia0 < 3; ++ia0)
        {
            A[ia0] += sv14[22] * FE29_C0_D010_Q14[0][0][ia0 - 0];
        }
        for (int ia0 = 0; ia0 < 4; ++ia0)
        {
            A[ia0] += sv14[16] * FE29_C0_Q14[0][iq14][ia0 - 0];
        }
        for (int ia0 = 0; ia0 < 4; ++ia0)
        {
            A[ia0] += sv14[23] * FE29_C0_D001_Q14[0][0][ia0 - 0];
        }
        for (int ia0 = 4; ia0 < 6; ++ia0)
        {
            A[ia0] += sv14[18] * FE29_C0_D100_Q14[0][0][ia0 - 4];
        }
        for (int ia0 = 4; ia0 < 7; ++ia0)
        {
            A[ia0] += sv14[19] * FE29_C0_D010_Q14[0][0][ia0 - 4];
        }
        for (int ia0 = 4; ia0 < 8; ++ia0)
        {
            A[ia0] += sv14[17] * FE29_C0_Q14[0][iq14][ia0 - 4];
        }
        for (int ia0 = 4; ia0 < 8; ++ia0)
        {
            A[ia0] += sv14[20] * FE29_C0_D001_Q14[0][0][ia0 - 4];
        }
    }
}


cahnhilliard3d_cell_integral_1_otherwise::cahnhilliard3d_cell_integral_1_otherwise() : ufc::cell_integral()
{

}

cahnhilliard3d_cell_integral_1_otherwise::~cahnhilliard3d_cell_integral_1_otherwise()
{

}

const std::vector<bool> & cahnhilliard3d_cell_integral_1_otherwise::enabled_coefficients() const
{
static const std::vector<bool> enabled({true, true, true, true});
return enabled;
}

void cahnhilliard3d_cell_integral_1_otherwise::tabulate_tensor(double * A,
                                    const double * const * w,
                                    const double * coordinate_dofs,
                                    int cell_orientation) const
{
    // This function was generated using 'uflacs' representation
    // with the following integrals metadata:
    // 
    //   num_cells:         None
    //   quadrature_degree: 4
    //   quadrature_rule:   'default'
    //   representation:    'uflacs'
    // 
    // and the following integral 0 metadata:
    // 
    //   estimated_polynomial_degree: 4
    //   quadrature_degree:           4
    //   quadrature_rule:             'default'
    //   representation:              'uflacs'
    
    // Section for quadrature weights and points
    alignas(32) static const double weights14[14] = { 0.00317460317460317, 0.00317460317460317, 0.00317460317460317, 0.00317460317460317, 0.00317460317460317, 0.00317460317460317, 0.0147649707904968, 0.0147649707904968, 0.0147649707904968, 0.0147649707904968, 0.0221397911142651, 0.0221397911142651, 0.0221397911142651, 0.0221397911142651 };
    // Section for precomputed element basis function values
    // Table dimensions: num_entities, num_points, num_dofs
    // Definitions of 4 tables for 14 quadrature points
    alignas(32) static const double FE26_C0_D001_Q14[1][1][4] = { { { -1.0, 0.0, 0.0, 1.0 } } };
    alignas(32) static const double FE26_C0_D010_Q14[1][1][3] = { { { -1.0, 0.0, 1.0 } } };
    alignas(32) static const double FE26_C0_D100_Q14[1][1][2] = { { { -1.0, 1.0 } } };
    alignas(32) static const double FE26_C0_Q14[1][14][4] =
        { { { 0.0, 0.0, 0.5, 0.5 },
            { 0.0, 0.5, 0.0, 0.5 },
            { 0.0, 0.5, 0.5, 0.0 },
            { 0.5, 0.5, 0.0, 0.0 },
            { 0.5, 0.0, 0.5, 0.0 },
            { 0.5, 0.0, 0.0, 0.5 },
            { 0.100526765225205, 0.698419704324386, 0.100526765225205, 0.100526765225205 },
            { 0.698419704324387, 0.100526765225204, 0.100526765225205, 0.100526765225205 },
            { 0.100526765225205, 0.100526765225204, 0.100526765225205, 0.698419704324386 },
            { 0.100526765225205, 0.100526765225204, 0.698419704324386, 0.100526765225205 },
            { 0.314372873493192, 0.0568813795204234, 0.314372873493192, 0.314372873493192 },
            { 0.0568813795204235, 0.314372873493192, 0.314372873493192, 0.314372873493192 },
            { 0.314372873493192, 0.314372873493192, 0.314372873493192, 0.0568813795204234 },
            { 0.314372873493192, 0.314372873493192, 0.0568813795204235, 0.314372873493192 } } };
    // Reset element tensor
    memset(A, 0, 64 * sizeof(*A));
    // Unstructured piecewise computations
    const double J_c4 = coordinate_dofs[1] * FE26_C0_D010_Q14[0][0][0] + coordinate_dofs[4] * FE26_C0_D010_Q14[0][0][1] + coordinate_dofs[7] * FE26_C0_D010_Q14[0][0][2];
    const double J_c8 = coordinate_dofs[2] * FE26_C0_D001_Q14[0][0][0] + coordinate_dofs[5] * FE26_C0_D001_Q14[0][0][1] + coordinate_dofs[8] * FE26_C0_D001_Q14[0][0][2] + coordinate_dofs[11] * FE26_C0_D001_Q14[0][0][3];
    const double J_c5 = coordinate_dofs[1] * FE26_C0_D001_Q14[0][0][0] + coordinate_dofs[4] * FE26_C0_D001_Q14[0][0][1] + coordinate_dofs[7] * FE26_C0_D001_Q14[0][0][2] + coordinate_dofs[10] * FE26_C0_D001_Q14[0][0][3];
    const double J_c7 = coordinate_dofs[2] * FE26_C0_D010_Q14[0][0][0] + coordinate_dofs[5] * FE26_C0_D010_Q14[0][0][1] + coordinate_dofs[8] * FE26_C0_D010_Q14[0][0][2];
    const double J_c0 = coordinate_dofs[0] * FE26_C0_D100_Q14[0][0][0] + coordinate_dofs[3] * FE26_C0_D100_Q14[0][0][1];
    const double J_c1 = coordinate_dofs[0] * FE26_C0_D010_Q14[0][0][0] + coordinate_dofs[3] * FE26_C0_D010_Q14[0][0][1] + coordinate_dofs[6] * FE26_C0_D010_Q14[0][0][2];
    const double J_c6 = coordinate_dofs[2] * FE26_C0_D100_Q14[0][0][0] + coordinate_dofs[5] * FE26_C0_D100_Q14[0][0][1];
    const double J_c3 = coordinate_dofs[1] * FE26_C0_D100_Q14[0][0][0] + coordinate_dofs[4] * FE26_C0_D100_Q14[0][0][1];
    const double J_c2 = coordinate_dofs[0] * FE26_C0_D001_Q14[0][0][0] + coordinate_dofs[3] * FE26_C0_D001_Q14[0][0][1] + coordinate_dofs[6] * FE26_C0_D001_Q14[0][0][2] + coordinate_dofs[9] * FE26_C0_D001_Q14[0][0][3];
    alignas(32) double sp14[159];
    sp14[0] = J_c4 * J_c8;
    sp14[1] = J_c5 * J_c7;
    sp14[2] = -1 * sp14[1];
    sp14[3] = sp14[0] + sp14[2];
    sp14[4] = J_c0 * sp14[3];
    sp14[5] = J_c5 * J_c6;
    sp14[6] = J_c3 * J_c8;
    sp14[7] = -1 * sp14[6];
    sp14[8] = sp14[5] + sp14[7];
    sp14[9] = J_c1 * sp14[8];
    sp14[10] = sp14[4] + sp14[9];
    sp14[11] = J_c3 * J_c7;
    sp14[12] = J_c4 * J_c6;
    sp14[13] = -1 * sp14[12];
    sp14[14] = sp14[11] + sp14[13];
    sp14[15] = J_c2 * sp14[14];
    sp14[16] = sp14[10] + sp14[15];
    sp14[17] = sp14[3] / sp14[16];
    sp14[18] = -1 * J_c8;
    sp14[19] = J_c3 * sp14[18];
    sp14[20] = sp14[5] + sp14[19];
    sp14[21] = sp14[20] / sp14[16];
    sp14[22] = sp14[14] / sp14[16];
    sp14[23] = sp14[17] * sp14[17];
    sp14[24] = sp14[17] * sp14[21];
    sp14[25] = sp14[22] * sp14[17];
    sp14[26] = sp14[21] * sp14[21];
    sp14[27] = sp14[22] * sp14[21];
    sp14[28] = sp14[22] * sp14[22];
    sp14[29] = J_c2 * J_c7;
    sp14[30] = -1 * J_c1;
    sp14[31] = J_c8 * sp14[30];
    sp14[32] = sp14[29] + sp14[31];
    sp14[33] = sp14[32] / sp14[16];
    sp14[34] = J_c0 * J_c8;
    sp14[35] = -1 * J_c2;
    sp14[36] = J_c6 * sp14[35];
    sp14[37] = sp14[34] + sp14[36];
    sp14[38] = sp14[37] / sp14[16];
    sp14[39] = J_c1 * J_c6;
    sp14[40] = J_c0 * J_c7;
    sp14[41] = -1 * sp14[40];
    sp14[42] = sp14[39] + sp14[41];
    sp14[43] = sp14[42] / sp14[16];
    sp14[44] = sp14[33] * sp14[33];
    sp14[45] = sp14[33] * sp14[38];
    sp14[46] = sp14[33] * sp14[43];
    sp14[47] = sp14[38] * sp14[38];
    sp14[48] = sp14[38] * sp14[43];
    sp14[49] = sp14[43] * sp14[43];
    sp14[50] = sp14[44] + sp14[23];
    sp14[51] = sp14[45] + sp14[24];
    sp14[52] = sp14[46] + sp14[25];
    sp14[53] = sp14[47] + sp14[26];
    sp14[54] = sp14[48] + sp14[27];
    sp14[55] = sp14[28] + sp14[49];
    sp14[56] = J_c1 * J_c5;
    sp14[57] = J_c2 * J_c4;
    sp14[58] = -1 * sp14[57];
    sp14[59] = sp14[56] + sp14[58];
    sp14[60] = sp14[59] / sp14[16];
    sp14[61] = J_c2 * J_c3;
    sp14[62] = J_c0 * J_c5;
    sp14[63] = -1 * sp14[62];
    sp14[64] = sp14[61] + sp14[63];
    sp14[65] = sp14[64] / sp14[16];
    sp14[66] = J_c0 * J_c4;
    sp14[67] = J_c1 * J_c3;
    sp14[68] = -1 * sp14[67];
    sp14[69] = sp14[66] + sp14[68];
    sp14[70] = sp14[69] / sp14[16];
    sp14[71] = sp14[60] * sp14[60];
    sp14[72] = sp14[60] * sp14[65];
    sp14[73] = sp14[70] * sp14[60];
    sp14[74] = sp14[65] * sp14[65];
    sp14[75] = sp14[70] * sp14[65];
    sp14[76] = sp14[70] * sp14[70];
    sp14[77] = sp14[50] + sp14[71];
    sp14[78] = sp14[51] + sp14[72];
    sp14[79] = sp14[52] + sp14[73];
    sp14[80] = sp14[53] + sp14[74];
    sp14[81] = sp14[54] + sp14[75];
    sp14[82] = sp14[55] + sp14[76];
    sp14[83] = sp14[77] * w[1][0];
    sp14[84] = sp14[78] * w[1][0];
    sp14[85] = sp14[79] * w[1][0];
    sp14[86] = sp14[80] * w[1][0];
    sp14[87] = sp14[81] * w[1][0];
    sp14[88] = sp14[82] * w[1][0];
    sp14[89] = -1 * sp14[83];
    sp14[90] = -1 * sp14[84];
    sp14[91] = -1 * sp14[85];
    sp14[92] = -1 * sp14[86];
    sp14[93] = -1 * sp14[87];
    sp14[94] = -1 * sp14[88];
    sp14[95] = sp14[17] * w[3][0];
    sp14[96] = sp14[21] * w[3][0];
    sp14[97] = sp14[22] * w[3][0];
    sp14[98] = sp14[95] * sp14[17];
    sp14[99] = sp14[96] * sp14[17];
    sp14[100] = sp14[97] * sp14[17];
    sp14[101] = sp14[95] * sp14[21];
    sp14[102] = sp14[96] * sp14[21];
    sp14[103] = sp14[97] * sp14[21];
    sp14[104] = sp14[95] * sp14[22];
    sp14[105] = sp14[96] * sp14[22];
    sp14[106] = sp14[97] * sp14[22];
    sp14[107] = sp14[33] * w[3][0];
    sp14[108] = sp14[38] * w[3][0];
    sp14[109] = sp14[43] * w[3][0];
    sp14[110] = sp14[107] * sp14[33];
    sp14[111] = sp14[108] * sp14[33];
    sp14[112] = sp14[109] * sp14[33];
    sp14[113] = sp14[107] * sp14[38];
    sp14[114] = sp14[108] * sp14[38];
    sp14[115] = sp14[109] * sp14[38];
    sp14[116] = sp14[107] * sp14[43];
    sp14[117] = sp14[108] * sp14[43];
    sp14[118] = sp14[109] * sp14[43];
    sp14[119] = sp14[110] + sp14[98];
    sp14[120] = sp14[111] + sp14[99];
    sp14[121] = sp14[112] + sp14[100];
    sp14[122] = sp14[113] + sp14[101];
    sp14[123] = sp14[114] + sp14[102];
    sp14[124] = sp14[115] + sp14[103];
    sp14[125] = sp14[104] + sp14[116];
    sp14[126] = sp14[105] + sp14[117];
    sp14[127] = sp14[106] + sp14[118];
    sp14[128] = sp14[60] * w[3][0];
    sp14[129] = sp14[65] * w[3][0];
    sp14[130] = sp14[70] * w[3][0];
    sp14[131] = sp14[128] * sp14[60];
    sp14[132] = sp14[129] * sp14[60];
    sp14[133] = sp14[130] * sp14[60];
    sp14[134] = sp14[128] * sp14[65];
    sp14[135] = sp14[129] * sp14[65];
    sp14[136] = sp14[130] * sp14[65];
    sp14[137] = sp14[128] * sp14[70];
    sp14[138] = sp14[129] * sp14[70];
    sp14[139] = sp14[130] * sp14[70];
    sp14[140] = sp14[119] + sp14[131];
    sp14[141] = sp14[120] + sp14[132];
    sp14[142] = sp14[121] + sp14[133];
    sp14[143] = sp14[122] + sp14[134];
    sp14[144] = sp14[123] + sp14[135];
    sp14[145] = sp14[124] + sp14[136];
    sp14[146] = sp14[125] + sp14[137];
    sp14[147] = sp14[126] + sp14[138];
    sp14[148] = sp14[127] + sp14[139];
    sp14[149] = sp14[140] * w[2][0];
    sp14[150] = sp14[141] * w[2][0];
    sp14[151] = sp14[142] * w[2][0];
    sp14[152] = sp14[143] * w[2][0];
    sp14[153] = sp14[144] * w[2][0];
    sp14[154] = sp14[145] * w[2][0];
    sp14[155] = sp14[146] * w[2][0];
    sp14[156] = sp14[147] * w[2][0];
    sp14[157] = sp14[148] * w[2][0];
    sp14[158] = std::abs(sp14[16]);
    for (int iq14 = 0; iq14 < 14; ++iq14)
    {
        // Quadrature loop body setup (num_points=14)
        // Unstructured varying computations
        double w0_c0 = 0.0;
        for (int ic = 0; ic < 4; ++ic)
        {
            w0_c0 += w[0][ic] * FE26_C0_Q14[0][iq14][ic - 0];
        }
        alignas(32) double sv14[32];
        sv14[0] = -1 * w0_c0;
        sv14[1] = 1 + sv14[0];
        sv14[2] = -2.0 * sv14[1];
        sv14[3] = 2.0 * w0_c0;
        sv14[4] = 100 * sv14[3];
        sv14[5] = sv14[2] * sv14[4];
        sv14[6] = std::pow(w0_c0, 2);
        sv14[7] = 100 * sv14[6];
        sv14[8] = 2.0 * sv14[7];
        sv14[9] = sv14[5] + sv14[8];
        sv14[10] = std::pow(sv14[1], 2);
        sv14[11] = 200.0 * sv14[10];
        sv14[12] = sv14[5] + sv14[11];
        sv14[13] = sv14[9] + sv14[12];
        sv14[14] = -1 * sv14[13];
        sv14[15] = weights14[iq14] * sp14[158];
        sv14[16] = sv14[14] * sv14[15];
        sv14[17] = sp14[89] * sv14[15];
        sv14[18] = sp14[90] * sv14[15];
        sv14[19] = sp14[91] * sv14[15];
        sv14[20] = sp14[92] * sv14[15];
        sv14[21] = sp14[93] * sv14[15];
        sv14[22] = sp14[94] * sv14[15];
        sv14[23] = sv14[15] * sp14[149];
        sv14[24] = sv14[15] * sp14[150];
        sv14[25] = sv14[15] * sp14[151];
        sv14[26] = sv14[15] * sp14[152];
        sv14[27] = sv14[15] * sp14[153];
        sv14[28] = sv14[15] * sp14[154];
        sv14[29] = sv14[15] * sp14[155];
        sv14[30] = sv14[15] * sp14[156];
        sv14[31] = sv14[15] * sp14[157];
        for (int ia0 = 0; ia0 < 2; ++ia0)
        {
            for (int ia1 = 4; ia1 < 6; ++ia1)
            {
                A[8 * ia0 + ia1] += sv14[23] * FE26_C0_D100_Q14[0][0][ia0 - 0] * FE26_C0_D100_Q14[0][0][ia1 - 4];
            }
        }
        for (int ia0 = 0; ia0 < 2; ++ia0)
        {
            for (int ia1 = 4; ia1 < 7; ++ia1)
            {
                A[8 * ia0 + ia1] += sv14[24] * FE26_C0_D100_Q14[0][0][ia0 - 0] * FE26_C0_D010_Q14[0][0][ia1 - 4];
            }
        }
        for (int ia0 = 0; ia0 < 2; ++ia0)
        {
            for (int ia1 = 4; ia1 < 8; ++ia1)
            {
                A[8 * ia0 + ia1] += sv14[25] * FE26_C0_D100_Q14[0][0][ia0 - 0] * FE26_C0_D001_Q14[0][0][ia1 - 4];
            }
        }
        for (int ia0 = 0; ia0 < 3; ++ia0)
        {
            for (int ia1 = 4; ia1 < 6; ++ia1)
            {
                A[8 * ia0 + ia1] += sv14[26] * FE26_C0_D010_Q14[0][0][ia0 - 0] * FE26_C0_D100_Q14[0][0][ia1 - 4];
            }
        }
        for (int ia0 = 0; ia0 < 3; ++ia0)
        {
            for (int ia1 = 4; ia1 < 7; ++ia1)
            {
                A[8 * ia0 + ia1] += sv14[27] * FE26_C0_D010_Q14[0][0][ia0 - 0] * FE26_C0_D010_Q14[0][0][ia1 - 4];
            }
        }
        for (int ia0 = 0; ia0 < 3; ++ia0)
        {
            for (int ia1 = 4; ia1 < 8; ++ia1)
            {
                A[8 * ia0 + ia1] += sv14[28] * FE26_C0_D010_Q14[0][0][ia0 - 0] * FE26_C0_D001_Q14[0][0][ia1 - 4];
            }
        }
        for (int ia0 = 0; ia0 < 4; ++ia0)
        {
            for (int ia1 = 0; ia1 < 4; ++ia1)
            {
                A[8 * ia0 + ia1] += sv14[15] * FE26_C0_Q14[0][iq14][ia0 - 0] * FE26_C0_Q14[0][iq14][ia1 - 0];
            }
        }
        for (int ia0 = 0; ia0 < 4; ++ia0)
        {
            for (int ia1 = 4; ia1 < 6; ++ia1)
            {
                A[8 * ia0 + ia1] += sv14[29] * FE26_C0_D001_Q14[0][0][ia0 - 0] * FE26_C0_D100_Q14[0][0][ia1 - 4];
            }
        }
        for (int ia0 = 0; ia0 < 4; ++ia0)
        {
            for (int ia1 = 4; ia1 < 7; ++ia1)
            {
                A[8 * ia0 + ia1] += sv14[30] * FE26_C0_D001_Q14[0][0][ia0 - 0] * FE26_C0_D010_Q14[0][0][ia1 - 4];
            }
        }
        for (int ia0 = 0; ia0 < 4; ++ia0)
        {
            for (int ia1 = 4; ia1 < 8; ++ia1)
            {
                A[8 * ia0 + ia1] += sv14[31] * FE26_C0_D001_Q14[0][0][ia0 - 0] * FE26_C0_D001_Q14[0][0][ia1 - 4];
            }
        }
        for (int ia0 = 4; ia0 < 6; ++ia0)
        {
            for (int ia1 = 0; ia1 < 2; ++ia1)
            {
                A[8 * ia0 + ia1] += sv14[17] * FE26_C0_D100_Q14[0][0][ia0 - 4] * FE26_C0_D100_Q14[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 4; ia0 < 6; ++ia0)
        {
            for (int ia1 = 0; ia1 < 3; ++ia1)
            {
                A[8 * ia0 + ia1] += sv14[18] * FE26_C0_D100_Q14[0][0][ia0 - 4] * FE26_C0_D010_Q14[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 4; ia0 < 6; ++ia0)
        {
            for (int ia1 = 0; ia1 < 4; ++ia1)
            {
                A[8 * ia0 + ia1] += sv14[19] * FE26_C0_D100_Q14[0][0][ia0 - 4] * FE26_C0_D001_Q14[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 4; ia0 < 7; ++ia0)
        {
            for (int ia1 = 0; ia1 < 2; ++ia1)
            {
                A[8 * ia0 + ia1] += sv14[18] * FE26_C0_D010_Q14[0][0][ia0 - 4] * FE26_C0_D100_Q14[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 4; ia0 < 7; ++ia0)
        {
            for (int ia1 = 0; ia1 < 3; ++ia1)
            {
                A[8 * ia0 + ia1] += sv14[20] * FE26_C0_D010_Q14[0][0][ia0 - 4] * FE26_C0_D010_Q14[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 4; ia0 < 7; ++ia0)
        {
            for (int ia1 = 0; ia1 < 4; ++ia1)
            {
                A[8 * ia0 + ia1] += sv14[21] * FE26_C0_D010_Q14[0][0][ia0 - 4] * FE26_C0_D001_Q14[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 4; ia0 < 8; ++ia0)
        {
            for (int ia1 = 0; ia1 < 2; ++ia1)
            {
                A[8 * ia0 + ia1] += sv14[19] * FE26_C0_D001_Q14[0][0][ia0 - 4] * FE26_C0_D100_Q14[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 4; ia0 < 8; ++ia0)
        {
            for (int ia1 = 0; ia1 < 3; ++ia1)
            {
                A[8 * ia0 + ia1] += sv14[21] * FE26_C0_D001_Q14[0][0][ia0 - 4] * FE26_C0_D010_Q14[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 4; ia0 < 8; ++ia0)
        {
            for (int ia1 = 0; ia1 < 4; ++ia1)
            {
                A[8 * ia0 + ia1] += sv14[16] * FE26_C0_Q14[0][iq14][ia0 - 4] * FE26_C0_Q14[0][iq14][ia1 - 0];
            }
        }
        for (int ia0 = 4; ia0 < 8; ++ia0)
        {
            for (int ia1 = 0; ia1 < 4; ++ia1)
            {
                A[8 * ia0 + ia1] += sv14[22] * FE26_C0_D001_Q14[0][0][ia0 - 4] * FE26_C0_D001_Q14[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 4; ia0 < 8; ++ia0)
        {
            for (int ia1 = 4; ia1 < 8; ++ia1)
            {
                A[8 * ia0 + ia1] += sv14[15] * FE26_C0_Q14[0][iq14][ia0 - 4] * FE26_C0_Q14[0][iq14][ia1 - 4];
            }
        }
    }
}


cahnhilliard3d_form_0::cahnhilliard3d_form_0() : ufc::form()
{
    // Do nothing
}

cahnhilliard3d_form_0::~cahnhilliard3d_form_0()
{
    // Do nothing
}

const char * cahnhilliard3d_form_0::signature() const
{
    return "d5150d94b3bd09e6ceca9d09afda39e2119a6cb6547ac85205009ca1a593b6fa005a5f402fb19b3374ef1a0dc3c4b03161cd7326b42add38c0d4ee80ec920308";
}

std::size_t cahnhilliard3d_form_0::rank() const
{
    return 1;
}

std::size_t cahnhilliard3d_form_0::num_coefficients() const
{
    return 5;
}

std::size_t cahnhilliard3d_form_0::original_coefficient_position(std::size_t i) const
{
    static const std::vector<std::size_t> position({0, 1, 2, 3, 4});
    return position[i];
}

ufc::finite_element * cahnhilliard3d_form_0::create_coordinate_finite_element() const
{
    return new cahnhilliard3d_finite_element_1();
}

ufc::dofmap * cahnhilliard3d_form_0::create_coordinate_dofmap() const
{
    return new cahnhilliard3d_dofmap_1();
}

ufc::coordinate_mapping * cahnhilliard3d_form_0::create_coordinate_mapping() const
{
    return nullptr;
}

ufc::finite_element * cahnhilliard3d_form_0::create_finite_element(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new cahnhilliard3d_finite_element_2();
        break;
      }
    case 1:
      {
        return new cahnhilliard3d_finite_element_2();
        break;
      }
    case 2:
      {
        return new cahnhilliard3d_finite_element_2();
        break;
      }
    case 3:
      {
        return new cahnhilliard3d_finite_element_3();
        break;
      }
    case 4:
      {
        return new cahnhilliard3d_finite_element_3();
        break;
      }
    case 5:
      {
        return new cahnhilliard3d_finite_element_3();
        break;
      }
    }
    
    return 0;
}

ufc::dofmap * cahnhilliard3d_form_0::create_dofmap(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new cahnhilliard3d_dofmap_2();
        break;
      }
    case 1:
      {
        return new cahnhilliard3d_dofmap_2();
        break;
      }
    case 2:
      {
        return new cahnhilliard3d_dofmap_2();
        break;
      }
    case 3:
      {
        return new cahnhilliard3d_dofmap_3();
        break;
      }
    case 4:
      {
        return new cahnhilliard3d_dofmap_3();
        break;
      }
    case 5:
      {
        return new cahnhilliard3d_dofmap_3();
        break;
      }
    }
    
    return 0;
}

std::size_t cahnhilliard3d_form_0::max_cell_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard3d_form_0::max_exterior_facet_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard3d_form_0::max_interior_facet_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard3d_form_0::max_vertex_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard3d_form_0::max_custom_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard3d_form_0::max_cutcell_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard3d_form_0::max_interface_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard3d_form_0::max_overlap_subdomain_id() const
{
    return 0;
}

bool cahnhilliard3d_form_0::has_cell_integrals() const
{
    return true;
}

bool cahnhilliard3d_form_0::has_exterior_facet_integrals() const
{
    return false;
}

bool cahnhilliard3d_form_0::has_interior_facet_integrals() const
{
    return false;
}

bool cahnhilliard3d_form_0::has_vertex_integrals() const
{
    return false;
}

bool cahnhilliard3d_form_0::has_custom_integrals() const
{
    return false;
}

bool cahnhilliard3d_form_0::has_cutcell_integrals() const
{
    return false;
}

bool cahnhilliard3d_form_0::has_interface_integrals() const
{
    return false;
}

bool cahnhilliard3d_form_0::has_overlap_integrals() const
{
    return false;
}

ufc::cell_integral * cahnhilliard3d_form_0::create_cell_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::exterior_facet_integral * cahnhilliard3d_form_0::create_exterior_facet_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::interior_facet_integral * cahnhilliard3d_form_0::create_interior_facet_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::vertex_integral * cahnhilliard3d_form_0::create_vertex_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::custom_integral * cahnhilliard3d_form_0::create_custom_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::cutcell_integral * cahnhilliard3d_form_0::create_cutcell_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::interface_integral * cahnhilliard3d_form_0::create_interface_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::overlap_integral * cahnhilliard3d_form_0::create_overlap_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::cell_integral * cahnhilliard3d_form_0::create_default_cell_integral() const
{
    return new cahnhilliard3d_cell_integral_0_otherwise();
}

ufc::exterior_facet_integral * cahnhilliard3d_form_0::create_default_exterior_facet_integral() const
{
    return 0;
}

ufc::interior_facet_integral * cahnhilliard3d_form_0::create_default_interior_facet_integral() const
{
    return 0;
}

ufc::vertex_integral * cahnhilliard3d_form_0::create_default_vertex_integral() const
{
    return 0;
}

ufc::custom_integral * cahnhilliard3d_form_0::create_default_custom_integral() const
{
    return 0;
}

ufc::cutcell_integral * cahnhilliard3d_form_0::create_default_cutcell_integral() const
{
    return 0;
}

ufc::interface_integral * cahnhilliard3d_form_0::create_default_interface_integral() const
{
    return 0;
}

ufc::overlap_integral * cahnhilliard3d_form_0::create_default_overlap_integral() const
{
    return 0;
}


cahnhilliard3d_form_1::cahnhilliard3d_form_1() : ufc::form()
{
    // Do nothing
}

cahnhilliard3d_form_1::~cahnhilliard3d_form_1()
{
    // Do nothing
}

const char * cahnhilliard3d_form_1::signature() const
{
    return "de362a73f656f9a69f43f8ea0ac2637021186cefce4f5df9cdea5cf77244d9d3d7e3d75c3ccea2ab95617742c41b0ec432c2935ce380d50bc73ff73f86e77398";
}

std::size_t cahnhilliard3d_form_1::rank() const
{
    return 2;
}

std::size_t cahnhilliard3d_form_1::num_coefficients() const
{
    return 4;
}

std::size_t cahnhilliard3d_form_1::original_coefficient_position(std::size_t i) const
{
    static const std::vector<std::size_t> position({0, 2, 3, 4});
    return position[i];
}

ufc::finite_element * cahnhilliard3d_form_1::create_coordinate_finite_element() const
{
    return new cahnhilliard3d_finite_element_1();
}

ufc::dofmap * cahnhilliard3d_form_1::create_coordinate_dofmap() const
{
    return new cahnhilliard3d_dofmap_1();
}

ufc::coordinate_mapping * cahnhilliard3d_form_1::create_coordinate_mapping() const
{
    return nullptr;
}

ufc::finite_element * cahnhilliard3d_form_1::create_finite_element(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new cahnhilliard3d_finite_element_2();
        break;
      }
    case 1:
      {
        return new cahnhilliard3d_finite_element_2();
        break;
      }
    case 2:
      {
        return new cahnhilliard3d_finite_element_2();
        break;
      }
    case 3:
      {
        return new cahnhilliard3d_finite_element_3();
        break;
      }
    case 4:
      {
        return new cahnhilliard3d_finite_element_3();
        break;
      }
    case 5:
      {
        return new cahnhilliard3d_finite_element_3();
        break;
      }
    }
    
    return 0;
}

ufc::dofmap * cahnhilliard3d_form_1::create_dofmap(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new cahnhilliard3d_dofmap_2();
        break;
      }
    case 1:
      {
        return new cahnhilliard3d_dofmap_2();
        break;
      }
    case 2:
      {
        return new cahnhilliard3d_dofmap_2();
        break;
      }
    case 3:
      {
        return new cahnhilliard3d_dofmap_3();
        break;
      }
    case 4:
      {
        return new cahnhilliard3d_dofmap_3();
        break;
      }
    case 5:
      {
        return new cahnhilliard3d_dofmap_3();
        break;
      }
    }
    
    return 0;
}

std::size_t cahnhilliard3d_form_1::max_cell_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard3d_form_1::max_exterior_facet_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard3d_form_1::max_interior_facet_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard3d_form_1::max_vertex_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard3d_form_1::max_custom_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard3d_form_1::max_cutcell_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard3d_form_1::max_interface_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard3d_form_1::max_overlap_subdomain_id() const
{
    return 0;
}

bool cahnhilliard3d_form_1::has_cell_integrals() const
{
    return true;
}

bool cahnhilliard3d_form_1::has_exterior_facet_integrals() const
{
    return false;
}

bool cahnhilliard3d_form_1::has_interior_facet_integrals() const
{
    return false;
}

bool cahnhilliard3d_form_1::has_vertex_integrals() const
{
    return false;
}

bool cahnhilliard3d_form_1::has_custom_integrals() const
{
    return false;
}

bool cahnhilliard3d_form_1::has_cutcell_integrals() const
{
    return false;
}

bool cahnhilliard3d_form_1::has_interface_integrals() const
{
    return false;
}

bool cahnhilliard3d_form_1::has_overlap_integrals() const
{
    return false;
}

ufc::cell_integral * cahnhilliard3d_form_1::create_cell_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::exterior_facet_integral * cahnhilliard3d_form_1::create_exterior_facet_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::interior_facet_integral * cahnhilliard3d_form_1::create_interior_facet_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::vertex_integral * cahnhilliard3d_form_1::create_vertex_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::custom_integral * cahnhilliard3d_form_1::create_custom_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::cutcell_integral * cahnhilliard3d_form_1::create_cutcell_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::interface_integral * cahnhilliard3d_form_1::create_interface_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::overlap_integral * cahnhilliard3d_form_1::create_overlap_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::cell_integral * cahnhilliard3d_form_1::create_default_cell_integral() const
{
    return new cahnhilliard3d_cell_integral_1_otherwise();
}

ufc::exterior_facet_integral * cahnhilliard3d_form_1::create_default_exterior_facet_integral() const
{
    return 0;
}

ufc::interior_facet_integral * cahnhilliard3d_form_1::create_default_interior_facet_integral() const
{
    return 0;
}

ufc::vertex_integral * cahnhilliard3d_form_1::create_default_vertex_integral() const
{
    return 0;
}

ufc::custom_integral * cahnhilliard3d_form_1::create_default_custom_integral() const
{
    return 0;
}

ufc::cutcell_integral * cahnhilliard3d_form_1::create_default_cutcell_integral() const
{
    return 0;
}

ufc::interface_integral * cahnhilliard3d_form_1::create_default_interface_integral() const
{
    return 0;
}

ufc::overlap_integral * cahnhilliard3d_form_1::create_default_overlap_integral() const
{
    return 0;
}

