// Auto generated SWIG file for Python interface of DOLFIN
//
// Copyright (C) 2012-2016 Kristian B. Oelgaard
//
// This file is part of DOLFIN.
//
// DOLFIN is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// DOLFIN is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with DOLFIN. If not, see <http://www.gnu.org/licenses/>.
//

// Autogenerated docstrings file, extracted from the DOLFIN source C++ files.

// Documentation extracted from: (module=common, header=init.h)
%feature("docstring")  dolfin::init "
Initialize DOLFIN (and PETSc) with command-line arguments. This
should not be needed in most cases since the initialization is
otherwise handled automatically.
";

// Documentation extracted from: (module=common, header=defines.h)
%feature("docstring")  dolfin::dolfin_version "
Return DOLFIN version string
";

%feature("docstring")  dolfin::ufc_signature "
Return UFC signature string
";

%feature("docstring")  dolfin::git_commit_hash "
Return git changeset hash (returns \"unknown\" if changeset is
not known)
";

%feature("docstring")  dolfin::sizeof_la_index "
Return sizeof the dolfin::la_index type
";

%feature("docstring")  dolfin::has_openmp "
Return true if DOLFIN is compiled with OpenMP
";

%feature("docstring")  dolfin::has_mpi "
Return true if DOLFIN is compiled with MPI
";

%feature("docstring")  dolfin::has_petsc "
Return true if DOLFIN is compiled with PETSc
";

%feature("docstring")  dolfin::has_slepc "
Return true if DOLFIN is compiled with SLEPc
";

%feature("docstring")  dolfin::has_scotch "
Return true if DOLFIN is compiled with Scotch
";

%feature("docstring")  dolfin::has_umfpack "
Return true if DOLFIN is compiled with Umfpack
";

%feature("docstring")  dolfin::has_cholmod "
Return true if DOLFIN is compiled with Cholmod
";

%feature("docstring")  dolfin::has_parmetis "
Return true if DOLFIN is compiled with ParMETIS
";

%feature("docstring")  dolfin::has_zlib "
Return true if DOLFIN is compiled with ZLIB
";

%feature("docstring")  dolfin::has_hdf5 "
Return true if DOLFIN is compiled with HDF5
";

%feature("docstring")  dolfin::has_vtk "
Return true if DOLFIN is compiled with VTK
";

// Documentation extracted from: (module=common, header=types.h)
// Documentation extracted from: (module=common, header=constants.h)
// Documentation extracted from: (module=common, header=timing.h)
%feature("docstring")  dolfin::TimingClear "
Parameter specifying whether to clear timing(s):
  * ``TimingClear::keep``
  * ``TimingClear::clear``
";

%feature("docstring")  dolfin::TimingType "
Timing types:
  * ``TimingType::wall`` wall-clock time
  * ``TimingType::user`` user (cpu) time
  * ``TimingType::system`` system (kernel) time

Precision of wall is around 1 microsecond, user and system are around
10 millisecond (on Linux).
";

%feature("docstring")  dolfin::tic "
Start timing (should not be used internally in DOLFIN!)
";

%feature("docstring")  dolfin::toc "
Return elapsed wall time (should not be used internally in DOLFIN!)
";

%feature("docstring")  dolfin::time "
Return wall time elapsed since some implementation dependent epoch
";

%feature("docstring")  dolfin::timings "
Return a summary of timings and tasks in a :py:class:`Table`, optionally clearing
stored timings

*Arguments*
    clear (TimingClear)
        * ``TimingClear::clear`` resets stored timings
        * ``TimingClear::keep`` leaves stored timings intact
    type (std::set<TimingType>)
        subset of ``{ TimingType::wall, TimingType::user,
        TimingType::system }``

*Returns*
    :py:class:`Table`
        :py:class:`Table` with timings
";

%feature("docstring")  dolfin::list_timings "
List a summary of timings and tasks, optionally clearing stored timings.
``MPI_AVG`` reduction is printed. Collective on ``MPI_COMM_WORLD``.

*Arguments*
    clear (TimingClear)
        * ``TimingClear::clear`` resets stored timings
        * ``TimingClear::keep`` leaves stored timings intact
    type (std::set<TimingType>)
        subset of ``{ TimingType::wall, TimingType::user,
        TimingType::system }``
";

%feature("docstring")  dolfin::dump_timings_to_xml "
Dump a summary of timings and tasks to XML file, optionally clearing
stored timings. ``MPI_MAX``, ``MPI_MIN`` and ``MPI_AVG`` reductions are
stored. Collective on ``MPI_COMM_WORLD``.

*Arguments*
    filename (str)
        output filename; must have ``.xml`` suffix; existing file
        is silently overwritten
    clear (TimingClear)
        * ``TimingClear::clear`` resets stored timings
        * ``TimingClear::keep`` leaves stored timings intact
";

%feature("docstring")  dolfin::timing "
Return timing (count, total wall time, total user time,
total system time) for given task, optionally clearing
all timings for the task

*Arguments*
    task (str)
        name of a task
    clear (TimingClear)
        * ``TimingClear::clear`` resets stored timings
        * ``TimingClear::keep`` leaves stored timings intact

*Returns*
    std::tuple<std::size_t, double, double, double>
        (count, total wall time, total user time, total system time)
";

// Documentation extracted from: (module=common, header=Array.h)
%feature("docstring")  dolfin::Array "
This class provides a simple wrapper for a pointer to an array. A
purpose of this class is to enable the simple and safe exchange
of data between C++ and Python.
";

%feature("docstring")  dolfin::Array::Array "
**Overloaded versions**

* Array\ (N)

  Create array of size N. Array has ownership.

* Array\ (N, x)

  Construct array from a pointer. Array does not take ownership.

* Array\ (other)

  Disable copy construction, to avoid unanticipated sharing or
  copying of data. This means that an Array must always be passed as
  reference, or as a (possibly shared) pointer.
";

%feature("docstring")  dolfin::Array::str "
Return informal string representation (pretty-print).
Note that the Array class is not a subclass of Variable (for
efficiency) which means that one needs to call str() directly
instead of using the info() function on Array objects.
";

%feature("docstring")  dolfin::Array::size "
Return size of array
";

%feature("docstring")  dolfin::Array::operator[] "
**Overloaded versions**

* operator[]\ (i)

  Access value of given entry (const version)

* operator[]\ (i)

  Access value of given entry (non-const version)
";

%feature("docstring")  dolfin::Array::data "
**Overloaded versions**

* data\ ()

  Return pointer to data (const version)

* data\ ()

  Return pointer to data (non-const version)
";

// Documentation extracted from: (module=common, header=ArrayView.h)
%feature("docstring")  dolfin::ArrayView "
This class provides a wrapper for a pointer to an array. It
never owns the data, and will not be valid if the underlying
data goes out-of-scope.
";

%feature("docstring")  dolfin::ArrayView::ArrayView "
**Overloaded versions**

* ArrayView\ ()

  Constructor

* ArrayView\ (N, x)

  Construct array from a pointer. Array does not take ownership.

* ArrayView\ (v)

  Construct array from a container with the the data() and
  size() functions

* ArrayView\ (x)

  Copy constructor
";

%feature("docstring")  dolfin::ArrayView::set "
**Overloaded versions**

* set\ (N, x)

  Update object to point to new data

* set\ (v)

  Update object to point to new container
";

%feature("docstring")  dolfin::ArrayView::size "
Return size of array
";

%feature("docstring")  dolfin::ArrayView::empty "
Test if array view is empty
";

%feature("docstring")  dolfin::ArrayView::operator[] "
**Overloaded versions**

* operator[]\ (i)

  Access value of given entry (const version)

* operator[]\ (i)

  Access value of given entry (non-const version)
";

%feature("docstring")  dolfin::ArrayView::data "
**Overloaded versions**

* data\ ()

  Return pointer to data (const version)

* data\ ()

  Return pointer to data (non-const version)
";

// Documentation extracted from: (module=common, header=IndexSet.h)
%feature("docstring")  dolfin::IndexSet "
This class provides an efficient data structure for index sets.
The cost of checking whether a given index is in the set is O(1)
and very very fast (optimal) at the cost of extra storage.
";

%feature("docstring")  dolfin::IndexSet::IndexSet "
Create index set of given size
";

%feature("docstring")  dolfin::IndexSet::empty "
Return true if set is empty
";

%feature("docstring")  dolfin::IndexSet::size "
Return size of set
";

%feature("docstring")  dolfin::IndexSet::has_index "
Check whether index is in set
";

%feature("docstring")  dolfin::IndexSet::find "
Return position (if any) for given index
";

%feature("docstring")  dolfin::IndexSet::operator[] "
**Overloaded versions**

* operator[]\ (i)

  Return given index

* operator[]\ (i)

  Return given index (const version)
";

%feature("docstring")  dolfin::IndexSet::insert "
Insert index into set
";

%feature("docstring")  dolfin::IndexSet::fill "
Fill index set with indices 0, 1, 2, ..., size - 1
";

%feature("docstring")  dolfin::IndexSet::clear "
Clear set
";

// Documentation extracted from: (module=common, header=Set.h)
%feature("docstring")  dolfin::Set::Set "
**Overloaded versions**

* Set\ ()

  Create empty set

* Set\ (x)

  Wrap std::vector as a set. Contents will be erased.

* Set\ (x)

  Copy constructor
";

%feature("docstring")  dolfin::Set::find "
**Overloaded versions**

* find\ (x)

  Find entry in set and return an iterator to the entry

* find\ (x)

  Find entry in set and return an iterator to the entry (const)
";

%feature("docstring")  dolfin::Set::insert "
**Overloaded versions**

* insert\ (x)

  Insert entry

* insert\ (first, last)

  Insert entries
";

%feature("docstring")  dolfin::Set::size "
Set size
";

%feature("docstring")  dolfin::Set::erase "
Erase an entry
";

%feature("docstring")  dolfin::Set::sort "
Sort set
";

%feature("docstring")  dolfin::Set::clear "
Clear set
";

%feature("docstring")  dolfin::Set::operator[] "
Index the nth entry in the set
";

%feature("docstring")  dolfin::Set::set "
**Overloaded versions**

* set\ ()

  Return the vector that stores the data in the Set

* set\ ()

  Return the vector that stores the data in the Set
";

// Documentation extracted from: (module=common, header=Timer.h)
%feature("docstring")  dolfin::Timer "
A timer can be used for timing tasks. The basic usage is

  Timer timer(\"Assembling over cells\");

The timer is started at construction and timing ends
when the timer is destroyed (goes out of scope). It is
also possible to start and stop a timer explicitly by

  timer.start();
  timer.stop();

Timings are stored globally and a summary may be printed
by calling

  list_timings();
";

%feature("docstring")  dolfin::Timer::Timer "
**Overloaded versions**

* Timer\ ()

  Create timer without logging

* Timer\ (task)

  Create timer with logging
";

%feature("docstring")  dolfin::Timer::start "
Zero and start timer
";

%feature("docstring")  dolfin::Timer::resume "
Resume timer. Not well-defined for logging timer
";

%feature("docstring")  dolfin::Timer::stop "
Stop timer, return wall time elapsed and store timing data
into logger
";

%feature("docstring")  dolfin::Timer::elapsed "
Return wall, user and system time in seconds. Wall-clock time
has precision around 1 microsecond; user and system around
10 millisecond.
";

// Documentation extracted from: (module=common, header=Variable.h)
%feature("docstring")  dolfin::Variable "
Common base class for DOLFIN variables.
";

%feature("docstring")  dolfin::Variable::Variable "
**Overloaded versions**

* Variable\ ()

  Create unnamed variable

* Variable\ (name, label)

  Create variable with given name and label

* Variable\ (variable)

  Copy constructor
";

%feature("docstring")  dolfin::Variable::operator= "
Assignment operator
";

%feature("docstring")  dolfin::Variable::rename "
Rename variable
";

%feature("docstring")  dolfin::Variable::name "
Return name
";

%feature("docstring")  dolfin::Variable::label "
Return label (description)
";

%feature("docstring")  dolfin::Variable::id "
Get unique identifier.

*Returns*
    _std::size_t_
        The unique integer identifier associated with the object.
";

%feature("docstring")  dolfin::Variable::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=common, header=Hierarchical.h)
%feature("docstring")  dolfin::Hierarchical "
This class provides storage and data access for hierarchical
classes; that is, classes where an object may have a child
and a parent.

Note to developers: each subclass of Hierarchical that
implements an assignment operator must call the base class
assignment operator at the *end* of the subclass assignment
operator. See the Mesh class for an example.
";

%feature("docstring")  dolfin::Hierarchical::Hierarchical "
Constructor
";

%feature("docstring")  dolfin::Hierarchical::depth "
Return depth of the hierarchy; that is, the total number of
objects in the hierarchy linked to the current object via
child-parent relationships, including the object itself.

*Returns*
    int
        The depth of the hierarchy.
";

%feature("docstring")  dolfin::Hierarchical::has_parent "
Check if the object has a parent.

*Returns*
    bool
        The return value is true iff the object has a parent.
";

%feature("docstring")  dolfin::Hierarchical::has_child "
Check if the object has a child.

*Returns*
    bool
        The return value is true iff the object has a child.
";

%feature("docstring")  dolfin::Hierarchical::parent "
**Overloaded versions**

* parent\ ()

  Return parent in hierarchy. An error is thrown if the object
  has no parent.
  
  *Returns*
      _Object_
          The parent object.

* parent\ ()

  Return parent in hierarchy (const version).
";

%feature("docstring")  dolfin::Hierarchical::parent_shared_ptr "
**Overloaded versions**

* parent_shared_ptr\ ()

  Return shared pointer to parent. A zero pointer is returned if
  the object has no parent.
  
  *Returns*
      shared_ptr<T>
          The parent object.

* parent_shared_ptr\ ()

  Return shared pointer to parent (const version).
";

%feature("docstring")  dolfin::Hierarchical::child "
**Overloaded versions**

* child\ ()

  Return child in hierarchy. An error is thrown if the object
  has no child.
  
  *Returns*
      _T_
          The child object.

* child\ ()

  Return child in hierarchy (const version).
";

%feature("docstring")  dolfin::Hierarchical::child_shared_ptr "
**Overloaded versions**

* child_shared_ptr\ ()

  Return shared pointer to child. A zero pointer is returned if
  the object has no child.
  
  *Returns*
      shared_ptr<T>
          The child object.

* child_shared_ptr\ ()

  Return shared pointer to child (const version).
";

%feature("docstring")  dolfin::Hierarchical::root_node "
**Overloaded versions**

* root_node\ ()

  Return root node object in hierarchy.
  
  *Returns*
      _T_
          The root node object.

* root_node\ ()

  Return root node object in hierarchy (const version).
";

%feature("docstring")  dolfin::Hierarchical::root_node_shared_ptr "
**Overloaded versions**

* root_node_shared_ptr\ ()

  Return shared pointer to root node object in hierarchy.
  
  *Returns*
      _T_
          The root node object.

* root_node_shared_ptr\ ()

  Return shared pointer to root node object in hierarchy (const version).
";

%feature("docstring")  dolfin::Hierarchical::leaf_node "
**Overloaded versions**

* leaf_node\ ()

  Return leaf node object in hierarchy.
  
  *Returns*
      _T_
          The leaf node object.

* leaf_node\ ()

  Return leaf node object in hierarchy (const version).
";

%feature("docstring")  dolfin::Hierarchical::leaf_node_shared_ptr "
**Overloaded versions**

* leaf_node_shared_ptr\ ()

  Return shared pointer to leaf node object in hierarchy.
  
  *Returns*
      _T_
          The leaf node object.

* leaf_node_shared_ptr\ ()

  Return shared pointer to leaf node object in hierarchy (const version).
";

%feature("docstring")  dolfin::Hierarchical::set_parent "
Set parent
";

%feature("docstring")  dolfin::Hierarchical::clear_child "
Clear child
";

%feature("docstring")  dolfin::Hierarchical::set_child "
Set child
";

%feature("docstring")  dolfin::Hierarchical::operator= "
Assignment operator
";

%feature("docstring")  dolfin::Hierarchical::_debug "
Function useful for debugging the hierarchy
";

// Documentation extracted from: (module=common, header=MPI.h)
%feature("docstring")  dolfin::MPI "
This class provides utility functions for easy communication
with MPI and handles cases when DOLFIN is not configured with
MPI.
";

%feature("docstring")  dolfin::MPI::rank "
Return process rank for the communicator
";

%feature("docstring")  dolfin::MPI::size "
Return size of the group (number of processes) associated with
the communicator
";

%feature("docstring")  dolfin::MPI::is_broadcaster "
Determine whether we should broadcast (based on current
parallel policy)
";

%feature("docstring")  dolfin::MPI::is_receiver "
Determine whether we should receive (based on current parallel
policy)
";

%feature("docstring")  dolfin::MPI::barrier "
Set a barrier (synchronization point)
";

%feature("docstring")  dolfin::MPI::all_to_all "
Send in_values[p0] to process p0 and receive values from
process p1 in out_values[p1]
";

%feature("docstring")  dolfin::MPI::broadcast "
**Overloaded versions**

* broadcast\ (comm, value, broadcaster=0)

  Broadcast vector of value from broadcaster to all processes

* broadcast\ (comm, value, broadcaster=0)

  Broadcast single primitive from broadcaster to all processes
";

%feature("docstring")  dolfin::MPI::scatter "
**Overloaded versions**

* scatter\ (comm, in_values, out_value, sending_process=0)

  Scatter vector in_values[i] to process i

* scatter\ (comm, in_values, out_value, sending_process=0)

  Scatter primitive in_values[i] to process i
";

%feature("docstring")  dolfin::MPI::gather "
**Overloaded versions**

* gather\ (comm, in_values, out_values, receiving_process=0)

  Gather values on one process

* gather\ (comm, in_values, out_values, receiving_process=0)

  Gather strings on one process
";

%feature("docstring")  dolfin::MPI::all_gather "
**Overloaded versions**

* all_gather\ (comm, in_values, out_values)

  Gather values from all processes. Same data count from each
  process (wrapper for MPI_Allgather)

* all_gather\ (comm, in_values, out_values)

  Gather values from each process (variable count per process)

* all_gather\ (comm, in_value, out_values)

  Gather values, one primitive from each process (MPI_Allgather)
";

%feature("docstring")  dolfin::MPI::max "
Return global max value
";

%feature("docstring")  dolfin::MPI::min "
Return global min value
";

%feature("docstring")  dolfin::MPI::sum "
Sum values and return sum
";

%feature("docstring")  dolfin::MPI::avg "
Return average across comm; implemented only for T == Table
";

%feature("docstring")  dolfin::MPI::all_reduce "
All reduce
";

%feature("docstring")  dolfin::MPI::global_offset "
Find global offset (index) (wrapper for MPI_(Ex)Scan with
MPI_SUM as reduction op)
";

%feature("docstring")  dolfin::MPI::send_recv "
**Overloaded versions**

* send_recv\ (comm, send_value, dest, send_tag, recv_value, source, recv_tag)

  Send-receive data between processes (blocking)

* send_recv\ (comm, send_value, dest, recv_value, source)

  Send-receive data between processes
";

%feature("docstring")  dolfin::MPI::local_range "
**Overloaded versions**

* local_range\ (comm, N)

  Return local range for local process, splitting [0, N - 1] into
  size() portions of almost equal size

* local_range\ (comm, process, N)

  Return local range for given process, splitting [0, N - 1] into
  size() portions of almost equal size
";

%feature("docstring")  dolfin::MPI::compute_local_range "
Return local range for given process, splitting [0, N - 1] into
size() portions of almost equal size
";

%feature("docstring")  dolfin::MPI::index_owner "
Return which process owns index (inverse of local_range)
";

%feature("docstring")  dolfin::MPI::MPI_AVG "
Return average reduction operation; recognized by
all_reduce(MPI_Comm, Table&, MPI_Op)
";

// Documentation extracted from: (module=common, header=SubSystemsManager.h)
%feature("docstring")  dolfin::SubSystemsManager "
This is a singleton class which manages the initialisation and
finalisation of various sub systems, such as MPI and PETSc.
";

%feature("docstring")  dolfin::SubSystemsManager::singleton "
Singleton instance. Calling this ensures singleton instance of
SubSystemsManager is initialized according to the \"Construct
on First Use\" idiom.
";

%feature("docstring")  dolfin::SubSystemsManager::init_mpi "
**Overloaded versions**

* init_mpi\ ()

  Initialise MPI

* init_mpi\ (argc, argv[], required_thread_level)

  Initialise MPI with required level of thread support
";

%feature("docstring")  dolfin::SubSystemsManager::init_petsc "
**Overloaded versions**

* init_petsc\ ()

  Initialize PETSc without command-line arguments

* init_petsc\ (argc, argv[])

  Initialize PETSc with command-line arguments. Note that PETSc
  command-line arguments may also be filtered and sent to PETSc
  by parameters.parse(argc, argv).
";

%feature("docstring")  dolfin::SubSystemsManager::finalize "
Finalize subsystems. This will be called by the destructor, but in
special cases it may be necessary to call finalize() explicitly.
";

%feature("docstring")  dolfin::SubSystemsManager::responsible_mpi "
Return true if DOLFIN initialised MPI (and is therefore responsible
for finalization)
";

%feature("docstring")  dolfin::SubSystemsManager::responsible_petsc "
Return true if DOLFIN initialised PETSc (and is therefore
responsible for finalization)
";

%feature("docstring")  dolfin::SubSystemsManager::mpi_initialized "
Check if MPI has been initialised (returns true if MPI has been
initialised, even if it is later finalised)
";

%feature("docstring")  dolfin::SubSystemsManager::mpi_finalized "
Check if MPI has been finalized (returns true if MPI has been
finalised)
";

%feature("docstring")  dolfin::SubSystemsManager::PetscDolfinErrorHandler "
PETSc error handler. Logs everything known to DOLFIN logging
system (with level TRACE) and stores the error message into
pests_err_msg member.
";

