/* Drip - a transcoder for Unix
 * Copyright (C) 2001-2003 Jarl van Katwijk
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <videoencoder.h>
#include <avifile.h>
#include <aviplay.h>
#include <version.h>
// avifile
#include <avm_default.h>
#include <avm_fourcc.h>
#include <creators.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <unistd.h>
#include <pthread.h>
#include <fstream>
#include <errno.h>
extern "C" {
#include "../libspu/spu.h"
}
#include "../src/drip.h"
#include "../config.h"
#include <gdk-pixbuf/gdk-pixbuf.h>

//#include <dmalloc.h>


#define APPNAME "dripencoder"
#define ENCODER_LD "DripEncoder"

#define BYTES_PER_COLOUR_OUTPOUT 3
#define LIBMPEG_COLOUR_DEPT_OUPUT MPEG3_BGR888 //MPEG3_601_BGRA8888
#define AVIFILE_COLOUR_DEPT_OUTPUT 24
#define YCRCB

extern gint clipleft;
extern gint clipright;
extern gint cliptop;
extern gint clipbottom;


typedef struct _arg_parmS arg_parmS;
struct _arg_parmS {
    gint argc;
    gchar **argv;
    gint nice;
};


/* Globals */
extern gboolean encoding;
extern gboolean stopped;
extern gboolean encoding_paused;
extern pthread_t serverthread;
extern gint serverthread_id;
extern pthread_t encoderthread;
extern gint encoderthread_id;
extern pthread_t guiclientthread;
extern gint guiclientthread_id;
extern gint linenr;
extern gint log_handler_encoder_id;
extern gboolean forking;

/* protos */
void log_handler(glong level,const gchar *message);

