#!/bin/sh
#
# Run dstool_tk
#

# This line records the location of the DSTOOL installation:
#: ${DSTOOL=/u/pkg/dstool_tk}
: ${DSTOOL=/usr/lib/dstooltk}
: ${ARCH=linux}

# The following determines machine type according to whatever clues your
# system makes available.
#if [ -z "${ARCH}" ]; then
#   case "$CPU" in
#    iris4) ARCH=iris;;
#    sun4os4) ARCH=sun4;;
#    "") ARCH=unknown;;
#    *) ARCH=other ;;
#   esac
#fi

#case "$ARCH" in
#   iris)
#      if [ ! -d /sbin ]; then
#	echo "Sorry, $0 can't run on Irix 4 Irises; try an Irix 5 machine." >&2
#	exit 1
#      fi ;;#
#   sun4) ;;
#   unknown)
#	echo "Can't tell what type of machine this is; you may need to
#	setenv ARCH iris		or
#	setenv ARCH sun4
#and re-run this script." >&2
#	exit 1
#	;;
#   other)  echo "Sorry, $0 is only supported on Suns and on Irix 5 Irises." >&2
#	exit 1
#	 ;;
#   *) 
#esac


# The remainder of this script probably needn't be changed per installation.

case "$1" in
   -h | -help | -?)
	echo "Usage: $0 [-my_dstool  my_dstool_directory]  dstool-args ...
Invoke either standard dstool, or a user-extended version,
given the my_dstool directory." >&2
	;;
   -m | -my | -my_dstool)
	MY_DSTOOL="$2"
	shift 2
	;;
esac

prog=${DSTOOL}/bin/${ARCH}/dstool_tk

if [ -x ${MY_DSTOOL}/bin/${ARCH}/my_dstool ]; then
   prog=${MY_DSTOOL}/bin/${ARCH}/my_dstool
elif [ -n "$MY_DSTOOL" ]; then
   echo "Can't find ${MY_DSTOOL}/bin/${ARCH}/my_dstool; invoking standard dstool." >&2
fi

export DSTOOL ARCH MY_DSTOOL
echo "Invoking $prog $@" >&2
${prog} ${1+"$@"}
