/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/*
 * browser.c
 *
 */

#include <constants.h>  
#include <stdio.h>
#include <pm.h>
#include <memory.h>
#include <modellib.h>
#include <math_utils.h>

void browser_copy_go(void);
void browser_output_go(void);
void browser_delete_go(void);
void browser_go(void);

/*
 * browser_copy_go()
 * 
 * procedure to copy browser panel point
 * to selected point
 */
void
  browser_copy_go()
{
  int i, n, code;
  
  code = *((int *) pm(GET, "Browser.Set_Code", NULL));

  if (code & 1)
    {
      /* do variables */
      n = *((int *) pm(GET, "Model.Varb_Dim", NULL));
      for (i=0; i<n; i++)
	pm(PUT, "Selected.Varb_Ic", i,
	   *((double *) pm(GET, "Browser.Vars", i, NULL)), NULL);
    }
  if (code & 2)
    {
      /* do parameters */
      n = *((int *) pm(GET, "Model.Param_Dim", NULL));
      for (i=0; i<n; i++)
	pm(PUT, "Selected.Param_Ic", i,
	   *((double *) pm(GET, "Browser.Params", i, NULL)), NULL);
    }
  pm(EXEC, "Selected.Funct", NULL);
}


void
browser_output_go()
{
  int i, n, format = *((int *) pm(GET, "Defaults.Precision", NULL));
  int code = *((int *) pm(GET, "Browser.Set_Code", NULL));

  if (code & 1)
    {
      /* do variables */
      n = *((int *) pm(GET, "Model.Varb_Dim", NULL));
      for (i=0; i<n; i++)
	fprintf(stdout, "%.*g ", format, 
		*((double *) pm(GET, "Browser.Vars", i, NULL)));
    }
  if (code & 2)
    {
      /* do parameters */
      n = *((int *) pm(GET, "Model.Param_Dim", NULL));
      for (i=0; i<n; i++)
	fprintf(stdout, "%.*g ", format, 
		*((double *) pm(GET, "Browser.Params", i, NULL)));
    }
  if (code & 4)
    {
      /* do colors */
      for (i=0; i<3; i++)
	fprintf(stdout, "%d ", *((int *) pm(GET, "Browser.Color", i, NULL)));
    }
  fprintf(stdout,"\n");
}


/*
 * browser_delete_go()
 *
 * procedure to delete the selected flow
 * from the selected memory object on the browser panel
 *
 */
void
browser_delete_go()
{
  memory m = (memory) pm(GET, "Browser.Memory", NULL);
  memory_delete_flow(m, *((int *) pm(GET, "Browser.Flow_Num", NULL)));
  pm(EXEC, "Memory.Count", NULL);
}


/*
 * Procedure to load up postmaster with info on requested flow, traj, point.
 *
 */
void
browser_go()
{
    memory m = (memory) pm(GET, "Browser.Memory", NULL);
    int set_code = 0;
    int n_varb, n_param, n_funcs, n_flows, n_trajs, n_points,
        flow_num, traj_num, point_num, i, status,
        hd_num, *p_hi, hi_num, bd_num, bi_num, *p_color, *p_bi;
    double *p_hd, *p_varb, *p_param, *p_bd, *p_func;

    pm(PUT, "Browser.Set_Code", 0,
       PUT, "Browser.N_Flows", 0,
       PUT, "Browser.N_Trajs", 0,
       PUT, "Browser.N_Points", 0,
       NULL);

    /* check for NULL memory item */
    if (m == NULL)
      {
	return;
      }
    
    n_varb = *((int *) pm(GET, "Model.Varb_Dim", NULL));
    n_param = *((int *) pm(GET, "Model.Param_Dim", NULL));
    n_funcs = *((int *) pm(GET, "Model.Funct_Dim", NULL));

    n_flows = memory_nflows(m);
    pm(PUT, "Browser.N_Flows", n_flows, NULL);

    /* find correct flow */
    flow_num = *((int *) pm(GET, "Browser.Flow_Num", NULL));
    if ((flow_num < 1) || (flow_num > n_flows)) return;
    status = memory_reset_read(m);
    for (i=0; i<flow_num; i++)
      status = memory_read_next_flow(m, &n_trajs, &p_hd, &hd_num,
				     &p_hi, &hi_num);
    pm(PUT, "Browser.N_Trajs", n_trajs, NULL);

    /* do something with the header stuff */
    /* nothing for now! */

    /* find correct trajectory */
    traj_num = *((int *) pm(GET, "Browser.Traj_Num", NULL));
    if ((traj_num < 1) || (traj_num > n_trajs)) return;
    for (i=0; i<traj_num; i++)
      status = memory_read_next_traj(m, &n_points, &bd_num, &bi_num);
    pm(PUT, "Browser.N_Points", n_points, NULL);

    /* find correct point */
    point_num = *((int *) pm(GET, "Browser.Point_Num", NULL));
    status = memory_set_read(m, flow_num, traj_num, point_num,
			     NULL, NULL, NULL, NULL, NULL, NULL);
    if (status) return;

    /* read it and stuff into postmaster browser object */
    status = memory_read_next_point(m, &p_varb, &p_param, &p_color,
				    &p_bd, &p_bi);
    if (p_varb)
      {
	pm(PUT_LIST, "Browser.Vars", 0, n_varb-1, p_varb, NULL);
	set_code += 1;
      }

    if (p_param)
      {
	pm(PUT_LIST, "Browser.Params", 0, n_param-1, p_param, NULL);
	set_code += 2;
      }

    if (p_color)
      {
	pm(PUT_LIST, "Browser.Color", 0, 2, p_color, NULL);
	set_code += 4;
      }

/* Put function information into Browser, for highlighting purposes */
    if ((set_code == 7)&&(n_funcs > 0)) {	/* everything's there */
        p_func = dvector(0,n_funcs-1);
        get_ds_func(p_func, p_varb, p_param);
        pm(PUT_LIST, "Browser.Funcs", 0, n_funcs-1, p_func, NULL);
        }

    pm(PUT, "Browser.Set_Code", set_code, NULL);
}

void
browser_new_mem()
{
  char buf[MAX_LONG_STR];

  /* construct name of memory object */
  sprintf(buf, "Memory.");
  (void) pm(GET, "Browser.Memory_Str", buf+7, NULL);

  pm(PUT, "Browser.Memory", (void *) pm(GET, buf, NULL),
     NULL);
}
