/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

#ifndef PARSER_DEFS_h
#define PARSER_DEFS_h

/* 
 * parser_defs.h
 * 
 * The header file for the parser/symbolic dynamical system library
 *
 */

#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <math.h>

extern double sign();

#define TRUE 1
#define FALSE 0
#define OK 2
#define PARSER_NEW 3
#define PARSER_CONTINUE 4
#define FAILURE -1
#define OUT_OF_MEMORY -2
#define DUPLICATE_NAME -3
#define EQN_BADLY_FORMED -4
#define PROGRAM_ERROR -5
#define MISSING_RHS -6

/* token identifiers */
typedef enum {
        UOP, BOP, CON, VAR, PAR, TEMP_FN
	} kind_t;

typedef enum {
  VAR_NODE=0, PAR_NODE, AUX_FN_NODE, TEMP_FN_NODE, PERIODIC_NODE, INITIAL_NODE, RANGE_NODE,
  DUMMY
  } node_name;
#define N_EQ_NODES DUMMY

typedef enum {
  EQUATION, INFO, BLANK
} node_type;

/* unary operator types */
typedef enum {
        SIN, COS, TAN,
        ASIN, ACOS, ATAN,
        SINH, COSH, TANH,
        LOG, LN, EXP,
        ABS, SQRT, MINUS, SIGN
        } uop_t;


/* the item in a list of string tokens */
typedef struct token_str_item {
  char *str;
  struct token_str_item *next;
} token_str;


/* the item in a list of tokens */
typedef struct token_item {
  kind_t kind;
  union {
    uop_t uop;
    char bop;
    int var;
    int par;
    int aux_fn;
    int temp_fn;
    double con;
  } u;
  struct token_item *next;
} token;


typedef struct eq_node_item {
  char *name;
  token *eval_tree;
  token *eqn;
  token_str *eqn_str;
  struct eq_node_item *next;
} eq_node;


/* the full information on the symbolic dynamical system */
typedef struct {
  eq_node *node[N_EQ_NODES];
  double *temp_fn_values;
  int needs_temp_fn[N_EQ_NODES];
  token_str *temp_token_str_stack;
  double *eval_stack;
} symbolic_ds, *s_ds;

typedef struct dlist_item {
  double value;
  struct dlist_item *next;
} dlist;


typedef double (*PFD)(double); /* ptr to function of double which
				  returns a double */


extern char *uop_dict[];
extern char *uop_C_dict[];
extern uop_t uop_indx[];
extern PFD uop_fn[];
extern char *bop_dict[];
extern char bop_indx[];
extern char *con_dict[];
extern double con_indx[];
extern char *key_dict[];
extern node_name key_indx[];
extern node_type key_data_type[];

token_str *p_create_token_str(char *str);
int p_push_token_str(token_str **pstack, token_str *ts);
token_str *p_pop_token_str(token_str **);
int p_destroy_token_str_stack(token_str **pstack);
int p_clear_token_strings_in_node_list(eq_node *node);
int p_clear_all_token_strings(s_ds ds);

int p_get_num(char *, token_str **);
int p_get_id(char *, token_str **);
int p_get_fc(char *, token_str **);
int is_name_in_node(s_ds ds, node_name node_indx, char *t);
int is_key(char *t);
int is_con(char *t);
int is_uop(char *t);
int is_bop(char *t);
int is_known_id(s_ds, char *t);

eq_node *p_create_eq_node(char *name_str);
int p_destroy_eq_node(eq_node *node);
int p_destroy_eq_node_list(eq_node *node);
int p_add_eq_node(eq_node **pnode, char *s);
int p_add_name_to_node(s_ds ds, node_name node_indx, char *s);
int p_count_eq_node_length(eq_node *n);
char *p_get_name_from_node(eq_node *n, int i);

token *p_create_token(kind_t kind);
token *p_copy_token(token *t);
int p_push_token(token **ptoken, token *t);
token *p_pop_token(token **pstack);
int p_push_token_on_bottom(token **pstack, token *t);
token *p_pop_token_from_bottom(token **pstack);
int p_destroy_token_stack(token **pstack);

int p_dump_token_list(FILE *file, token *list);
int p_writeC_token_list(FILE *file, token *list);
int p_write_token_list(FILE *file, s_ds ds, token *list);

int p_dump_eq_node_list(FILE *file, eq_node *node, node_name type);
int p_dump_token_str_list(FILE *file, token_str *list);
int p_dump_ds(FILE *file, s_ds ds);

double minus(double op);
int priority(token *t);
int ismathc(char);

/*
extern dlist *p_create_dlist();
extern int p_push_d();
extern double p_pop_d();
extern int p_destroy_d_stack();

extern int p_dump_token_list();
*/

#endif
/* !PARSER_DEFS_h */
