/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/*
 * parser_prims.h
 *
 * The low level routines in the parser/symbolic ds package
 */

#include <stdlib.h>

int ismathc(char c);
token_str *p_create_token_str(char* str);
int p_push_token_str(token_str** pstack, token_str* ts);
token_str *p_pop_token_str( token_str** pstack);
int p_destroy_token_str_stack( token_str** pstack);
int p_clear_token_strings_in_node_list(eq_node* node);
int p_clear_all_token_strings( s_ds ds);
int p_get_num(char* s, token_str** ts);
int p_get_id(char* s, token_str** ts);
int p_get_fc(char* s, token_str** ts);
int is_name_in_node(s_ds ds,node_name node_indx, char* t);
int is_key( char* t);
int is_con( char* t);
int is_uop( char* t);
int is_bop( char* t);
int is_known_id( s_ds ds, char* t);
eq_node *p_create_eq_node( char* name_str);
int p_destroy_eq_node( eq_node* node);
int p_destroy_eq_node_list( eq_node* node);
int p_add_eq_node( eq_node** ppnode, char* s);
int p_add_name_to_node( s_ds ds, node_name node_indx, char* s);
int p_count_eq_node_length( eq_node* n);
char *p_get_name_from_node( eq_node* n, int i);
token *p_create_token( kind_t kind);
token *p_copy_token( token* t);
int p_push_token( token** pstack, token* t);
token *p_pop_token(token** pstack);
int p_push_token_on_bottom( token** pstack, token* t);
token *p_pop_token_from_bottom( token** pstack);
int p_destroy_token_stack( token** pstack);
int p_dump_token_list( FILE* file, token* list);
int p_write_token_list( FILE* file, s_ds ds, token* list);
int p_writeC_token_list( FILE* file,token* list);
int p_dump_eq_node_list( FILE* file, eq_node* node, node_name type);
int p_dump_token_str_list( FILE* file, token_str* list);
int p_dump_ds( FILE* file, s_ds ds);
double minus( double op);
