/*
***************************************************************************
*
* Author: Teunis van Beelen
*
* Copyright (C) 2007, 2008, 2009 Teunis van Beelen
*
* teuniz@gmail.com
*
***************************************************************************
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation version 2 of the License.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
***************************************************************************
*
* This version of GPL is at http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt
*
***************************************************************************
*/




#include "signal_properties.h"



UI_SignalProperties::UI_SignalProperties(QWidget *parent, int job)
{
  int i;

  task = job;

  mainwindow = (UI_Mainwindow *)parent;

  signalproperties_dialog = new QDialog(parent);

  signalproperties_dialog->setMinimumSize(QSize(200, 400));
  signalproperties_dialog->setMaximumSize(QSize(200, 400));
  signalproperties_dialog->setWindowTitle("Signals");
  signalproperties_dialog->setModal(TRUE);
  signalproperties_dialog->setAttribute(Qt::WA_DeleteOnClose, TRUE);

  list = new QListWidget(signalproperties_dialog);
  list->setGeometry(QRect(5, 5, 130, 365));
  list->setSelectionBehavior(QAbstractItemView::SelectRows);
  list->setSelectionMode(QAbstractItemView::SingleSelection);


  CloseButton = new QPushButton(signalproperties_dialog);
  CloseButton->setGeometry(QRect(5, 375, 130, 20));
  CloseButton->setText("Close");

  for(i=0; i<mainwindow->signalcomps; i++)
  {
    new QListWidgetItem(mainwindow->signalcomp[i]->signallabel, list);
  }

  QObject::connect(CloseButton, SIGNAL(clicked()), signalproperties_dialog, SLOT(close()));
  QObject::connect(list, SIGNAL(itemClicked(QListWidgetItem *)), this, SLOT(call_sidemenu(QListWidgetItem *)));

  signalproperties_dialog->exec();
}



void UI_SignalProperties::call_sidemenu(QListWidgetItem *)
{
  signalproperties_dialog->hide();

  if(task == 0)
  {
    mainwindow->maincurve->exec_sidemenu(list->currentRow());
  }

  if(task == 1)
  {
    mainwindow->spectrumdock->init(list->currentRow());
  }

  signalproperties_dialog->close();
}






