/*
Copyright (C) 2002 Pedro Zorzenon Neto <pzn@autsens.com>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Do not forget to visit Free Software Foundation site: http://fsf.org

$Id: eeprom.h,v 1.3 2003/07/05 18:23:22 pzn Exp $
*/
#ifndef _EEPROM_H
#define _EEPROM_H

#include "memory.h"
#include "parport.h"
#include "eeprpins.h"

/* NOTE: will use unsigned long int because if compiled
 * in old DOS compilers, unsigned int will have 16bit
 * and will not support values greater than 65535 */
typedef struct {
    parport_t * pp;
    int access_mode;
    unsigned long int write_size;
    unsigned int addr_size;
    unsigned long int read_size;
    unsigned long int total_size;
    unsigned char inv_page;
} eeprom_t;

eeprom_t * eeprom_init (unsigned long int parallel_port_address,

			unsigned long int write_size,
			/* how many bytes can be written sequencially */

			unsigned int addr_size,
			/* how many words the address command has */

			unsigned long int read_size,
			/* how many bytes can be read sequencially */

			unsigned long int total_size,
			/* how many bytes the memory has */

			unsigned char inv_page
			/* invert page specification bits in control word
			   (lsb will go first)
			   I only know Microchip 24xx515 which uses this */
		       );
void eeprom_destroy (eeprom_t * self);
/* int eeprom_readbyte (eeprom_t * self, int addr);
int eeprom_writebyte (eeprom_t * self, int addr, int value); */
int eeprom_fullread (eeprom_t * self, memory_t * mem);
int eeprom_fullwrite (eeprom_t *self, memory_t * mem);
void eeprom_power (eeprom_t * self, int poweron);

/* AT24Cxxx values:
 *
 * I found some chips (from other manufacturers) that have
 * write_size smaller than the values found in Atmel datasheet.
 * I recommend using write_size smaller than the values below.
 *
 * model   write_size addr_size read_size total_size inv_page
 * 24c01     8          1         128       128         0
 * 24c02     8          1         256       256         0
 * 24c04     16         1         256       512         0
 * 24c08     16         1         256       1024        0
 * 24c16     16         1         256       2048        0
 * 24c32     32         2         4096      4096        0
 * 24c64     32         2         8192      8192        0
 * 24c128    64         2         16384     16384       0
 * 24c256    64         2         32768     32768       0
 * 24c512    128        2         65536     65536       0
 * 24c515    64         2         32768     65536       1
 *
*/
#endif
