#!/usr/local/bin/python

""" Helper script to path the VC generated Makefile and execute
    NMAKE.

    Copyright (c) 2000, Marc-Andre Lemburg; mailto:mal@lemburg.com
    Copyright (c) 2000-2001, eGenix.com Software GmbH; mailto:info@egenix.com
    See the documentation for further copyright information or contact
    the author.

"""

import sys,os,imp

def makeall(configuration='Release',target='',dir='.'):

    # Find directories with vcmake.py and execute the script
    entries = os.listdir(dir)
    for entry in entries:
        if os.path.isdir(entry):
            subdir = os.path.join(dir,entry)
            vcmakefile = os.path.join(subdir,'vcmake.py')
            if os.path.isfile(vcmakefile):
                print 'entering',subdir
                print ' importing',vcmakefile
                try:
                    vcmake = imp.load_source('vcmake',
                                             vcmakefile,
                                             open(vcmakefile,'rb'))
                except:
                    print ' XXX Error %s:%s' % sys.exc_info()[:2]
                    continue
                print ' running vcmake.make()'
                print '-'*72
                origdir = os.getcwd()
                os.chdir(subdir)
                try:
                    vcmake.make(entry,configuration,target)
                except:
                    print ' XXX Error %s:%s' % sys.exc_info()[:2]
                os.chdir(origdir)
                print '-'*72

if __name__ == '__main__':
    try:
        apply(makeall,tuple(sys.argv[1:]))
    except TypeError:
        print "vcmakeall.py <configuration> [<maketarget>] [<dir>]"
        print
        print "Example: vcmakeall.py Release"
        print
        sys.exit(1)

