# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

"""
Metadata parsing support
"""


__maintainer__ = 'Philippe Normand <philippe@fluendo.com>'
__maintainer2__ = 'Benjamin Kampmann <benjamin@fluendo.com>'


from elisa.core.component import Component

class MetadataError(Exception):
    """
    A non-critical metadata error occurred in a metadata provider.
    """

class MetadataProvider(Component):
    """
    Metadata (ID3 tags, EXIF information, ...) can be extracted from medias
    using different ways. This base component is meant to
    provide the developer some nice ways to extend Elisa's metadata
    parsing framework.

    All MetadataProviders are handled by the L{elisa.core.metadata_manager.MetadataManager} manager.

    A MetadataProvider must be able to :
     - provide a rank between 0 (highest) and 255
     - check if it is able to handle a given dict

    TODO:
     - we need a way to rank the metadataproviders
    """

    def get_rank(self):
        """
        Rank determining wether the parser should be prioritized.

        @todo: We need a better System here so that the developers can decide
        which one to use

        @rtype:              integer
        @return:             the rank as integer between 0 and 255
        """

    def able_to_handle(self, metadata):
        """ Return wether this provider is able to fill in metadata, when it
        gets this metadata dictionary.

        @param metadata:    a dictionary containing all known and requested
                            metadata
        @type metadata:     dict
        @rtype:             bool
        """

    def get_metadata(self, metadata, low_priority=False):
        """ Retrieve the metadata for this metadata request and put it in
        there.

        @todo: determine all the keys returned for each content-type.

        @param metadata:    a dictionary containing all the known and
                            requested metadata, which is also filled with the
                            new data
        @type metadata:     dict
        @rtype:             L{twisted.internet.defer.Deferred}
        """
