#!/usr/bin/env perl

#  elmo - ELectronic Mail Operator
#
#  Copyright (C) 2004 Krzysztof Gibas <sdas % gibas org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; version 2.
#
#  This  program is  distributed in the  hope  that  it will be useful,
#  but  WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of
#  MERCHANTABILITY  or  FITNESS  FOR  A  PARTICULAR  PURPOSE.  See  the
#  GNU General Public License for more details.
# 
#  You  should  have  received a copy of the GNU General Public License
#  along  with  this  program;  if  not,  write  to  the  Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307,
#  USA.
#
#  $Id: funex.pl,v 1.11 2004/04/19 20:45:32 rzyjontko Exp $
#
#  ------------------------------------------------------------
#
#  This script extracts all functions from exec_table.t to README.txt

use strict;
use warnings;

#set secure environment
$ENV{'PATH'} = '/bin:/usr/bin:/usr/local/bin:/usr/pkg/bin';
delete @ENV{'IFS', 'CDPATH', 'ENV', 'BASH_ENV'};

my ($i, @readme, @tab, @parts, $p, @przed, @po, $README, $EXEC_TABLE, $comment);

$p = 0;

$EXEC_TABLE = $ARGV[0] || "exec_table.t";
$README = $ARGV[1] || "../doc/README.txt";

sub extract_functions () {

    open(FILE, "< $EXEC_TABLE") or die "Error: Couldn't open file $EXEC_TABLE: $!\n";
	my @line = <FILE>;
    close(FILE) or warn "Error: Couldn't close $EXEC_TABLE: $!\n";
    
    foreach (@line) {
	#comment
	if (! /^\{.*\},$/) {
	    if (! /^(\/\*)|(.*\*\/)$/) {
		$comment .= $_;
	    }
	}
	#normal declaration
	else {
	    $_ =~ s/(\"|\}|\{)//g;
	    @parts = split(/,/, $_);
	    
	    if (! $comment) {
		push(@tab, " $parts[1] -$parts[3]\n");
	    }
	    else {
		push(@tab, " $parts[1] -$parts[3].\n$comment");
	    }
	    $comment = "";
	}
    }

    @tab = sort @tab;
}

sub readlines{
    open(README, "< $README") or die "Error: Couldn't open file $README: $!\n";
	@readme = <README>;
    close(README) or warn "Error: Couldn't close $README: $!\n";

    foreach (@readme) {

	if (/^\s*= Function reference =$/) {
	    push(@przed, "$_                        ======================\n\n");
	    $p = 1;
	}
	elsif (!$p) {
	    #last modyfication update.
	    if (/^Last update: (\d)?\d\/(\d)?\d\/\d\d\d\d.$/) {
		my ($day, $month, $year) = (localtime)[3,4,5];

                $month = $month + 1;
                if (length($month) == 1) {
		    $month = "0" . $month;
		} 
                
                if (length($day) == 1) {
                    $day = "0" . $day;
                }

		$year = $year + 1900;
                
		push(@przed, "Last update: " . $day . "/" . $month . "/" . $year . ".\n");
	    }
	    else {
		push(@przed, $_);
	    }
	}
	elsif ($p == 2) {
	    push(@po, $_);
	}
    }
}

extract_functions ();
readlines();

#write to README.txt
open(README, "> $README") or die "Error: Couldn't open file $README: $!\n";
flock (README, 2) or print "\nCouldn't lock file $README: $!";

    foreach(@przed) {
	print README $_;
    }
    foreach(@tab) {
	print README $_ . "\n";
    }
    foreach(@po) {
	print README $_;
    }
        
close(README) or warn "Error: Couldn't close $README: $!\n";

