/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2003, 2004 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

   ----------------------------------------------------------------------

   rmime.c
   
*/
/****************************************************************************
 *    IMPLEMENTATION HEADERS
 ****************************************************************************/

#include <stdlib.h>

#include "mime.h"
#include "rarray.h"
#include "rmime.h"
#include "memchunk.h"

/****************************************************************************
 *    IMPLEMENTATION PRIVATE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION PRIVATE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION PRIVATE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION REQUIRED EXTERNAL REFERENCES (AVOID)
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION PRIVATE DATA
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE DATA
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION PRIVATE FUNCTION PROTOTYPES
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION PRIVATE FUNCTIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE FUNCTIONS
 ****************************************************************************/


rmime_t *
rmime_create_size (size_t size)
{
        return (rmime_t *) rarray_create_size (size);
}


rmime_t *
rmime_create (void)
{
        return (rmime_t *) rarray_create ();
}


void
rmime_destroy (rmime_t *ptr)
{
        mime_t **mime;

        if (ptr == NULL)
                return;
        
        for (mime = ptr->array; *mime; mime++){
                mime_destroy (*mime);
        }
        rarray_destroy ((rarray_t *) ptr);
}


void
rmime_add (rmime_t *ptr, mime_t *p)
{
        rarray_add ((rarray_t *) ptr, p);
}


void
rmime_remove (rmime_t *ptr, unsigned index)
{
        rarray_remove ((rarray_t *) ptr, index);
}


void
rmime_shrink (rmime_t *ptr)
{
        rarray_shrink ((rarray_t *) ptr);
}


rmime_t *
rmime_join (rmime_t *x, rmime_t *y)
{
        return (rmime_t *) rarray_join ((rarray_t *) x, (rarray_t *) y);
}



void
rmime_dump (memchunk_t *memchunk, rmime_t *ptr)
{
        int i;
        int zero = 0;

        if (ptr == NULL){
                memchunk_intdump (memchunk, zero);
                return;
        }
  
        memchunk_intdump (memchunk, ptr->count);
        for (i = 0; i < ptr->count; i++)
                mime_dump (memchunk, ptr->array[i]);
}


rmime_t *
rmime_read (memchunk_t *memchunk)
{
        int      i;
        int      size = memchunk_intget (memchunk);
        rmime_t *result;

        if (size == 0)
                return NULL;

        result = rmime_create_size (size + 1);
        for (i = 0; i < size; i++){
                mime_t *mime = mime_create ();
                mime_read (memchunk, mime);
                rmime_add (result, mime);
        }
        return result;
}


/****************************************************************************
 *    INTERFACE CLASS BODIES
 ****************************************************************************/
/****************************************************************************
 *
 *    END MODULE rmime.c
 *
 ****************************************************************************/
