/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.parser;

import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.REProgram;
import org.apache.regexp.RESyntaxException;

public class AcdFunResolve {
    public String result;

    public AcdFunResolve(String exp) {
        RECompiler rec = new RECompiler();
        try {
            REProgram funexp = rec.compile("^(.*)\\@\\(([^()]+)\\)");
            RE regfunexp = new RE(funexp);
            while (regfunexp.match(exp)) {
                String var = regfunexp.getParen(2);
                this.result = this.acdFunResolve(var);
                int iend = regfunexp.getParenEnd(1);
                String newvar = exp.substring(0, iend);
                iend = regfunexp.getParenEnd(2);
                newvar = newvar.concat(this.result);
                newvar = newvar.concat(exp.substring(iend + 1));
                exp = new String(newvar);
            }
        }
        catch (RESyntaxException rese) {
            System.out.println("RESyntaxException ");
        }
        if (this.result == null) {
            this.result = exp;
        }
    }

    public String getResult() {
        if (this.result.equalsIgnoreCase("False") || this.result.equalsIgnoreCase("True")) {
            this.result = this.result.toLowerCase();
        }
        return this.result;
    }

    public String acdFunResolve(String var) {
        this.result = "";
        this.acdExpPlus(var);
        this.acdExpMinus(var);
        this.acdExpStar(var);
        this.acdExpDiv(var);
        this.acdExpNot(var);
        this.acdExpEqual(var);
        this.acdExpNotEqual(var);
        this.acdExpGreater(var);
        this.acdExpLesser(var);
        this.acdExpOr(var);
        this.acdExpAnd(var);
        this.acdExpCond(var);
        return this.result;
    }

    private boolean acdExpPlus(String exp) {
        RE regexp;
        REProgram rep;
        RECompiler rec = new RECompiler();
        try {
            rep = rec.compile("^[ \t(]*([-+]*[:digit:]+)[ \t]*[+][ \t]*([-+]*[:digit:]+)[ \t)]*$");
            regexp = new RE(rep);
            if (regexp.match(exp)) {
                int ia = new Integer(regexp.getParen(1));
                int ib = new Integer(regexp.getParen(2));
                this.result = Integer.toString(ia += ib);
                return true;
            }
        }
        catch (RESyntaxException rese) {
            System.out.println("RESyntaxException ");
        }
        rec = new RECompiler();
        try {
            rep = rec.compile("^[ \t(]*([-+]*[:digit:]+[.]*[:digit:]*)[ \t]*[+][ \t]*([-+]*[:digit:]+[.]*[:digit:]*)[ \t)]*$");
            regexp = new RE(rep);
            if (regexp.match(exp)) {
                double da = new Double(regexp.getParen(1));
                double db = new Double(regexp.getParen(2));
                this.result = Double.toString(da += db);
                return true;
            }
        }
        catch (RESyntaxException rese) {
            System.out.println("RESyntaxException ");
        }
        return false;
    }

    private boolean acdExpMinus(String exp) {
        RE regexp;
        REProgram rep;
        RECompiler rec = new RECompiler();
        try {
            rep = rec.compile("^[ \t(]*([-+]*[:digit:]+)[ \t]*(-)[ \t]*([-+]*[:digit:]+)[ \t)]*$");
            regexp = new RE(rep);
            if (regexp.match(exp)) {
                int ia = new Integer(regexp.getParen(1));
                int ib = new Integer(regexp.getParen(3));
                this.result = Integer.toString(ia -= ib);
                return true;
            }
        }
        catch (RESyntaxException rese) {
            System.out.println("RESyntaxException ");
        }
        rec = new RECompiler();
        try {
            rep = rec.compile("^[ \t(]*([-+]*[:digit:]+[.]*[:digit:]*)[ \t]*(-)[ \t]*([-+]*[:digit:]+[.]*[:digit:]*)[ \t)]*$");
            regexp = new RE(rep);
            if (regexp.match(exp)) {
                double da = new Double(regexp.getParen(1));
                double db = new Double(regexp.getParen(3));
                this.result = Double.toString(da -= db);
                return true;
            }
        }
        catch (RESyntaxException rese) {
            System.out.println("RESyntaxException ");
        }
        return false;
    }

    private boolean acdExpStar(String exp) {
        RE regexp;
        REProgram rep;
        RECompiler rec = new RECompiler();
        try {
            rep = rec.compile("^[ \t(]*([-+]*[:digit:]+)[ \t]*[*][ \t]*([-+]*[:digit:]+)[ \t)]*$");
            regexp = new RE(rep);
            if (regexp.match(exp)) {
                int ia = new Integer(regexp.getParen(1));
                int ib = new Integer(regexp.getParen(2));
                this.result = Integer.toString(ia *= ib);
                return true;
            }
        }
        catch (RESyntaxException rese) {
            System.out.println("RESyntaxException ");
        }
        rec = new RECompiler();
        try {
            rep = rec.compile("^[ \t(]*([-+]*[:digit:]+[.]*[:digit:]*)[ \t]*[*][ \t]*([-+]*[:digit:]+[.]*[:digit:]*)[ \t)]*$");
            regexp = new RE(rep);
            if (regexp.match(exp)) {
                double da = new Double(regexp.getParen(1));
                double db = new Double(regexp.getParen(2));
                this.result = Double.toString(da *= db);
                return true;
            }
        }
        catch (RESyntaxException rese) {
            System.out.println("RESyntaxException ");
        }
        return false;
    }

    private boolean acdExpDiv(String exp) {
        RE regexp;
        REProgram rep;
        RECompiler rec = new RECompiler();
        try {
            rep = rec.compile("^[ \t(]*([-+]*[:digit:]+)[ \t]*[/][ \t]*([-+]*[:digit:]+)[ \t)]*$");
            regexp = new RE(rep);
            if (regexp.match(exp)) {
                int ia = new Integer(regexp.getParen(1));
                int ib = new Integer(regexp.getParen(2));
                this.result = Integer.toString(ia /= ib);
                return true;
            }
        }
        catch (RESyntaxException rese) {
            System.out.println("RESyntaxException ");
        }
        rec = new RECompiler();
        try {
            rep = rec.compile("^[ \t(]*([-+]*[:digit:]+[.]*[:digit:]*)[ \t]*[/][ \t]*([-+]*[:digit:]+[.]*[:digit:]*)[ \t)]*$");
            regexp = new RE(rep);
            if (regexp.match(exp)) {
                double da = new Double(regexp.getParen(1));
                double db = new Double(regexp.getParen(2));
                this.result = Double.toString(da /= db);
                return true;
            }
        }
        catch (RESyntaxException rese) {
            System.out.println("RESyntaxException ");
        }
        return false;
    }

    private boolean acdExpNot(String exp) {
        RECompiler rec = new RECompiler();
        try {
            REProgram rep = rec.compile("^[ \t(]*(!|[Nn][Oo][Tt])[ \t]*([a-zA-Z0-9]+)[ \t)]*$");
            RE regexp = new RE(rep);
            if (regexp.match(exp)) {
                this.result = regexp.getParen(2).equalsIgnoreCase("false") ? "true" : "false";
                return true;
            }
        }
        catch (RESyntaxException rese) {
            System.out.println("RESyntaxException ");
        }
        return false;
    }

    private boolean acdExpEqual(String exp) {
        RE regexp;
        REProgram rep;
        RECompiler rec = new RECompiler();
        try {
            rep = rec.compile("^[ \t(]*([-+]*[:digit:]+)[ \t]*[=][=][ \t]*([-+]*[:digit:]+)[ \t)]*$");
            regexp = new RE(rep);
            if (regexp.match(exp)) {
                int ib;
                int ia = new Integer(regexp.getParen(1));
                this.result = ia == (ib = new Integer(regexp.getParen(2)).intValue()) ? "true" : "false";
                return true;
            }
        }
        catch (RESyntaxException rese) {
            System.out.println("RESyntaxException ");
        }
        rec = new RECompiler();
        try {
            rep = rec.compile("^[ \t(]*([-+]*[:digit:]+[.]*[:digit:]*)[ \t]*[=][=][ \t]*([-+]*[:digit:]+[.]*[:digit:]*)[ \t)]*$");
            regexp = new RE(rep);
            if (regexp.match(exp)) {
                double db;
                double da = new Double(regexp.getParen(1));
                this.result = da == (db = new Double(regexp.getParen(2)).doubleValue()) ? "true" : "false";
                return true;
            }
        }
        catch (RESyntaxException rese) {
            System.out.println("RESyntaxException ");
        }
        rec = new RECompiler();
        try {
            rep = rec.compile("^[ \t(]*([a-zA-Z]+[a-zA-Z0-9]*)[ \t]*[=][=][ \t]*([a-zA-Z]+[a-zA-Z0-9]*)[ \t)]*$");
            regexp = new RE(rep);
            if (regexp.match(exp)) {
                String sb;
                String sa = regexp.getParen(1);
                this.result = sa.equalsIgnoreCase(sb = regexp.getParen(2)) ? "true" : "false";
                return true;
            }
        }
        catch (RESyntaxException rese) {
            System.out.println("RESyntaxException ");
        }
        return false;
    }

    private boolean acdExpNotEqual(String exp) {
        RE regexp;
        REProgram rep;
        RECompiler rec = new RECompiler();
        try {
            rep = rec.compile("^[ \t(]*([-+]*[:digit:]+)[ \t]*[!][=][ \t]*([-+]*[:digit:]+)[ \t)]*$");
            regexp = new RE(rep);
            if (regexp.match(exp)) {
                int ib;
                int ia = new Integer(regexp.getParen(1));
                this.result = ia != (ib = new Integer(regexp.getParen(2)).intValue()) ? "true" : "false";
                return true;
            }
        }
        catch (RESyntaxException rese) {
            System.out.println("RESyntaxException ");
        }
        rec = new RECompiler();
        try {
            rep = rec.compile("^[ \t(]*([-+]*[:digit:]+[.]*[:digit:]*)[ \t]*[!][=][ \t]*([-+]*[:digit:]+[.]*[:digit:]*)[ \t)]*$");
            regexp = new RE(rep);
            if (regexp.match(exp)) {
                double db;
                double da = new Double(regexp.getParen(1));
                this.result = da != (db = new Double(regexp.getParen(2)).doubleValue()) ? "true" : "false";
                return true;
            }
        }
        catch (RESyntaxException rese) {
            System.out.println("RESyntaxException ");
        }
        rec = new RECompiler();
        try {
            rep = rec.compile("^[ \t(]*([a-zA-Z]+[a-zA-Z0-9]*)[ \t]*[!][=][ \t]*([a-zA-Z]+[a-zA-Z0-9]*)[ \t)]*$");
            regexp = new RE(rep);
            if (regexp.match(exp)) {
                String sb;
                String sa = regexp.getParen(1);
                this.result = !sa.equalsIgnoreCase(sb = regexp.getParen(2)) ? "true" : "false";
                return true;
            }
        }
        catch (RESyntaxException rese) {
            System.out.println("RESyntaxException ");
        }
        return false;
    }

    private boolean acdExpGreater(String exp) {
        RE regexp;
        REProgram rep;
        RECompiler rec = new RECompiler();
        try {
            rep = rec.compile("^[ \t(]*([-+]*[:digit:]+)[ \t]*[>][ \t]*([-+]*[:digit:]+)[ \t)]*$");
            regexp = new RE(rep);
            if (regexp.match(exp)) {
                int ib;
                int ia = new Integer(regexp.getParen(1));
                this.result = ia > (ib = new Integer(regexp.getParen(2)).intValue()) ? "true" : "false";
                return true;
            }
        }
        catch (RESyntaxException rese) {
            System.out.println("RESyntaxException ");
        }
        rec = new RECompiler();
        try {
            rep = rec.compile("^[ \t(]*([-+]*[:digit:]+[.]*[:digit:]*)[ \t]*[>][ \t]*([-+]*[:digit:]+[.]*[:digit:]*)[ \t)]*$");
            regexp = new RE(rep);
            if (regexp.match(exp)) {
                double db;
                double da = new Double(regexp.getParen(1));
                this.result = da > (db = new Double(regexp.getParen(2)).doubleValue()) ? "true" : "false";
                return true;
            }
        }
        catch (RESyntaxException rese) {
            System.out.println("RESyntaxException ");
        }
        return false;
    }

    private boolean acdExpLesser(String exp) {
        RE regexp;
        REProgram rep;
        RECompiler rec = new RECompiler();
        try {
            rep = rec.compile("^[ \t(]*([-+]*[:digit:]+)[ \t]*[<][ \t]*([-+]*[:digit:]+)[ \t)]*$");
            regexp = new RE(rep);
            if (regexp.match(exp)) {
                int ib;
                int ia = new Integer(regexp.getParen(1));
                this.result = ia < (ib = new Integer(regexp.getParen(2)).intValue()) ? "true" : "false";
                return true;
            }
        }
        catch (RESyntaxException rese) {
            System.out.println("RESyntaxException ");
        }
        rec = new RECompiler();
        try {
            rep = rec.compile("^[ \t(]*([-+]*[:digit:]+[.]*[:digit:]*)[ \t]*[<][ \t]*([-+]*[:digit:]+[.]*[:digit:]*)[ \t)]*$");
            regexp = new RE(rep);
            if (regexp.match(exp)) {
                double db;
                double da = new Double(regexp.getParen(1));
                this.result = da < (db = new Double(regexp.getParen(2)).doubleValue()) ? "true" : "false";
                return true;
            }
        }
        catch (RESyntaxException rese) {
            System.out.println("RESyntaxException ");
        }
        return false;
    }

    private boolean acdExpOr(String exp) {
        RECompiler rec = new RECompiler();
        try {
            REProgram rep = rec.compile("^[ \t(]*([a-zA-Z]+)[ \t]*[|][ \t]*([a-zA-Z]+)[ \t)]*$");
            RE regexp = new RE(rep);
            if (regexp.match(exp)) {
                String ba = regexp.getParen(1);
                String bb = regexp.getParen(2);
                this.result = ba.equalsIgnoreCase("true") || bb.equalsIgnoreCase("true") ? "true" : "false";
                return true;
            }
        }
        catch (RESyntaxException rese) {
            System.out.println("RESyntaxException ");
        }
        return false;
    }

    private boolean acdExpAnd(String exp) {
        RECompiler rec = new RECompiler();
        try {
            REProgram rep = rec.compile("^[ \t(]*([a-zA-Z]+[a-zA-Z0-9]*)[ \t]*[&][ \t]*([a-zA-Z]+[a-zA-Z0-9]*)[ \t)]*$");
            RE regexp = new RE(rep);
            if (regexp.match(exp)) {
                String ba = regexp.getParen(1);
                String bb = regexp.getParen(2);
                this.result = ba.equalsIgnoreCase("true") && bb.equalsIgnoreCase("true") ? "true" : "false";
                return true;
            }
        }
        catch (RESyntaxException rese) {
            System.out.println("RESyntaxException ");
        }
        return false;
    }

    private boolean acdExpCond(String exp) {
        RECompiler rec = new RECompiler();
        try {
            REProgram rep = rec.compile("^[ \t(]*([a-zA-Z]+)[ \t]*[?][ \t]*([^: \t]+)[ \t]*(:)[ \t]*([^: \t)]+)[ \t)]*$");
            RE regexp = new RE(rep);
            if (regexp.match(exp)) {
                this.result = regexp.getParen(1).equalsIgnoreCase("true") ? regexp.getParen(2) : regexp.getParen(4);
                return true;
            }
        }
        catch (RESyntaxException rese) {
            System.out.println("RESyntaxException ");
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean acdExpCase(String exp) {
        RECompiler rec = new RECompiler();
        try {
            REProgram caseexp = rec.compile("^[ \t]*([A-Za-z0-9]+)[ \t]*[=]");
            REProgram listexp = rec.compile("^[ \t]*([^: \t]+)[ \t]*[:]+[ \t]*([^: \t,]+)[ \t,]*");
            RE caseregexp = new RE(caseexp);
            if (!caseregexp.match(exp)) return false;
        }
        catch (RESyntaxException rese) {
            System.out.println("RESyntaxException ");
        }
        return false;
    }
}

