C Copyright 1981-2007 ECMWF
C 
C Licensed under the GNU Lesser General Public License which
C incorporates the terms and conditions of version 3 of the GNU
C General Public License.
C See LICENSE and gpl-3.0.txt for details.
C

      INTEGER FUNCTION INTFC( INGRIB,INLEN,FLDIN,OUTGRIB,OUTLEN,FLDOUT)
C
C---->
C**** INTFC
C
C     Purpose
C     -------
C
C     Move input field to output field.
C
C
C     Interface
C     ---------
C
C     IRET = INTFC( INGRIB,INLEN,FLDIN,OUTGRIB,OUTLEN,FLDOUT)
C
C     Input
C     -----
C
C     INGRIB - Input field (packed).
C     INLEN  - Input field length (words).
C     FLDIN  - Input field (unpacked).
C
C
C     Output
C     ------
C
C     OUTGRIB - Output field (packed).
C     OUTLEN  - Output field length (words).
C     FLDOUT  - Output field (unpacked).
C
C
C     Method
C     ------
C
C     Move data (packed or unpacked) without special processing.
C
C
C     Externals
C     ---------
C
C     None.
C
C
C     Author
C     ------
C
C     J.D.Chambers     ECMWF     Jan 1995
C
C----<
C
      IMPLICIT NONE
C
C     Function arguments
      INTEGER INGRIB(*),OUTGRIB(*),INLEN,OUTLEN
      REAL FLDIN(*),FLDOUT(*)
C
#include "parim.h"
#include "nifld.common"
#include "nofld.common"
#include "grfixed.h"
C
C     Parameters
      INTEGER JPROUTINE
      PARAMETER (JPROUTINE = 26700 )
C
C     Local variables
C
      INTEGER LOOP
C
C ------------------------------------------------------------------
C*    Section 1.   Initialise
C ------------------------------------------------------------------
C
  100 CONTINUE
      INTFC = 0
C
C ------------------------------------------------------------------
C*    Section 2.   Move data from input to output.
C ------------------------------------------------------------------
C
  200 CONTINUE
C
C     If input is a GRIB product
      If (NIFORM .EQ. 1) THEN
C
C       Move packed values to user array
        DO 210 LOOP = 1, INLEN
          OUTGRIB( LOOP ) = INGRIB( LOOP )
 210    CONTINUE
C
      ELSE
C
C       Otherwise, move unpacked values to user array
        DO 220 LOOP = 1, INLEN
          FLDOUT( LOOP ) = FLDIN( LOOP )
 220    CONTINUE
C
      ENDIF
C
C     Return the number of values, the unpacked array length
      OUTLEN = INLEN
C
C ------------------------------------------------------------------
C*    Section 9.   Closedown.
C ------------------------------------------------------------------
C
  900 CONTINUE
C
C     Clear change flags for next product processing
      LCHANGE = .FALSE.
      LSMCHNG = .FALSE.
C
      RETURN
      END
