
/***************************************************************************
 *   Copyright (C) 2004 by Eugene Bort                                     *
 *   esvn@umputun.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
  ***************************************************************************/


#include <qprocess.h>
#include <qsettings.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qtextcodec.h>

#if ( _WINDOWS || ESVN_WIN )
#include <windows.h>
#else
#include <unistd.h>
#endif
#include <stdio.h>

//using namespace std;

int main (int argc, char *argv[])
{

	QTextCodec::setCodecForCStrings( QTextCodec::codecForLocale() );
	QSettings	settings;
	settings.setPath("umputun.com", "esvn");

#ifndef Q_OS_WIN
	settings.beginGroup("/esvn");
#endif

	QString esvn_diff_mask = argc == 8 ?
		settings.readEntry("/progs/diff", "kdiff3" ) :
		settings.readEntry("/progs/diff3", "kdiff3" );
	settings.endGroup();

	if (esvn_diff_mask.isEmpty()) {
		printf("empty diff mask\n");
		return 2;
	}


	//printf("args\n");
	//for (size_t i=1; i < argc; i++) 
	//	printf("r:%s \n", argv[i]);

	QStringList elems;
	int start = esvn_diff_mask.find("\"");
	int end = esvn_diff_mask.find("\"", start + 1);
	if(start != -1 && end != -1){
		elems += esvn_diff_mask.mid(start, end - ( start - 1 ) );
		esvn_diff_mask.remove(start, end - ( start - 1 ) );
	}
	elems += QStringList::split(" " , esvn_diff_mask);

	QProcess* proc = new QProcess(NULL);
	proc->addArgument(elems[0]);

	//find position of '-L'
	int pos = 0;
	for (int p=1; p<argc; p++) {
		QString arg = argv[p];
		if (arg == "-L" && pos == 0) {
			pos = p;
		}
	}
	if(argc == 8) pos += 2;

	if (elems.size() == 1) {
		proc->addArgument(argv[pos+2]);
		proc->addArgument(argv[pos+3]);
	}
	else {
		for (size_t i=1; i<elems.size() ; i++) {
			QString e = elems[i];
			if (e == "f1" || e == "F1"){
				proc->addArgument(argv[pos+2]); 
			}
			else if (e.find("%f1") != -1 || e.find("%F1") != -1 ){
				e.replace("%F1", "%f1");
				e.replace("%f1", QDir::convertSeparators(argv[pos+2]));
				proc->addArgument(e);
			}else if (e == "f2" || e == "F2") {
				proc->addArgument(argv[pos+3]); 
			}
			else if (e.find("%f2") != -1 || e.find("%F2") != -1 ){
				e.replace("%F2", "%f2");
				e.replace("%f2", QDir::convertSeparators(argv[pos+3]));
				proc->addArgument(e);
			}
			else if (e == "f3" || e == "F3") {
				proc->addArgument(argv[pos+4]); 
			}
			else if (e.find("%f3") != -1 || e.find("%F3") != -1 ){
				e.replace("%F3", "%f3");
				e.replace("%f3", QDir::convertSeparators(argv[pos+2]));
				proc->addArgument(e);
			}
			else if (e == "a1" || e == "A1"){ 
				proc->addArgument(QString(argv[pos+1]).replace('\t', ' ')); 
			}
			else if (e.find("%a1") != -1 || e.find("%A1") != -1 ){
				e.replace("%A1", "%a1");
				e.replace("%a1", QString(argv[pos+1]).replace('\t', ' '));
				proc->addArgument(e);
			}
			else if (e == "a2" || e == "A2") { 
				proc->addArgument(QString(argv[pos+3]).replace('\t', ' ')); 
			}
			else if (e.find("%a2") != -1 || e.find("%A2") != -1 ){
				e.replace("%A2", "%a2");
				e.replace("%a2", QString(argv[pos+3]).replace('\t', ' '));
				proc->addArgument(e);
			}
			else proc->addArgument(e);
		}

	}

/*	printf("start \n");
	for (size_t j=0; j<proc->arguments().size(); j++) 
		printf("a:%s \n", (proc->arguments())[j].ascii());
*/	
	if (!proc->start())
		return 1;

	while (proc->isRunning())
#if ( _WINDOWS || ESVN_WIN )
		Sleep(1000);
#else
		usleep(1000);
#endif

	return proc->exitStatus();
}
