/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////


#include "Foundation/PathUtil.h"

#include <boost/filesystem/path.hpp>
#include <boost/filesystem/operations.hpp>
#include <boost/shared_ptr.hpp>

using namespace boost;

namespace esys
{
  namespace lsm
  {
    void setPathEnv(int argc, char *argv[])
    {
      if (argc > 0)
      {
        setPathEnv(argv[0]);
      }
    }

    /**
     * Function which modifies the PATH environment variable according
     * to the specified executable file. This is a work-around for the
     * SGI MPT mpirun implementation which appears to alter the PATH environment
     * variable of the executed processes.
     */
    void setPathEnv(const std::string &exeName)
    {
      if (exeName.size() > 0)
      {
        std::string origPathValue = "";
        const char *getenvVal = getenv("PATH");
        if (getenvVal != NULL)
        {
          origPathValue = getenvVal;
        }

        filesystem::path exePath = filesystem::system_complete(filesystem::path(exeName, boost::filesystem::native));
        std::string newPathValue = origPathValue + ":" + (exePath.branch_path().native_file_string());
        setenv("PATH", newPathValue.c_str(), 1);
      }
    }
  }
}
