/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#ifndef REALDIST_H
#define REALDIST_H

// -- IO includes --
// -- STL includes --
#include <string>
using std::string;

class RealDist {
   public:
      RealDist (double MinSize, double MaxSize, int Nbins);
      ~RealDist ();
      void AddSample (double evsize);
      void Write (const string&);
      void Clear();
   private:
      int nbins; 
      double maxsize, minsize, binsize;
      long Nevents;
      void Create ();
      void Destroy ();
      long *Edist;
      void AddEvSize (double evsize);
};

#endif
