/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#include "Model/BMesh2DInteractionCpData.h"
#include "Model/BMesh2DInteraction.h"

BMesh2DInteractionCpData::BMesh2DInteractionCpData() : m_pid(-1), m_tid(-1)
{}

BMesh2DInteractionCpData::BMesh2DInteractionCpData(const BEdge2DInteraction& bmi)
{
  m_pid=bmi.getPid();
  m_tid=bmi.getTid();
}

BMesh2DInteractionCpData::BMesh2DInteractionCpData(int pid,int tid)
{
  m_pid=pid;
  m_tid=tid;
}

void BMesh2DInteractionCpData::set(const BEdge2DInteraction& bmi)
{
  m_pid=bmi.getPid();
  m_tid=bmi.getTid();

}

void BMesh2DInteractionCpData::set(int pid,int tid)
{
  m_pid=pid;
  m_tid=tid;
}

int BMesh2DInteractionCpData::getPID()
{
  return m_pid;
}

int BMesh2DInteractionCpData::getTID()
{
  return m_tid;
}
 
void BMesh2DInteractionCpData::saveCheckPointData(ostream& ost)
{
  const char delim = ' ';
  ost << m_pid << delim << m_tid ;
}

void BMesh2DInteractionCpData::loadCheckPointData(istream &ist)
{
  ist >> m_pid >> m_tid;
}
