#############################################################
##                                                         ##
## Copyright (c) 2003-2011 by The University of Queensland ##
## Earth Systems Science Computational Centre (ESSCC)      ##
## http://www.uq.edu.au/esscc                              ##
##                                                         ##
## Primary Business: Brisbane, Queensland, Australia       ##
## Licensed under the Open Software License version 3.0    ##
## http://www.opensource.org/licenses/osl-3.0.php          ##
##                                                         ##
#############################################################

"""
Defines classes which relate to I{modifying} renderable objects.
"""

class Modifiable(object):
    def __init__(self):
        self.idModDict = dict()

    def getModifierList(self):
        pairList = self.idModDict.values()
        pairList.sort(lambda a,b: a[0]-b[0])
        return [e[1] for e in pairList]

    def applySingle(self, modifier):
        if (modifier != None):
            self.idModDict[id(modifier.__class__)] = \
              (len(self.idModDict),modifier)

    def applySequence(self, sequence):
        for modifier in sequence:
            self.applySingle(modifier)

    def apply(self, modifiers):
        if ((modifiers != None) and (hasattr(modifiers, "__iter__"))):
            self.applySequence(modifiers)
        else:
            self.applySingle(modifiers)

class Modifier(object):
    def __init__(self):
        pass

