#############################################################
##                                                         ##
## Copyright (c) 2003-2011 by The University of Queensland ##
## Earth Systems Science Computational Centre (ESSCC)      ##
## http://www.uq.edu.au/esscc                              ##
##                                                         ##
## Primary Business: Brisbane, Queensland, Australia       ##
## Licensed under the Open Software License version 3.0    ##
## http://www.opensource.org/licenses/osl-3.0.php          ##
##                                                         ##
#############################################################

from esys.lsm.vis import core

from Modifier import Pigment
from Color  import Colors

import string

class EdgeExtractor(core.EdgeExtractor):
    def __init__(
        self,
        pointListMap    = lambda dataRecord: dataRecord.getPointList(),
        radiusListMap   = lambda dataRecord: 1.0,
        colorValListMap = lambda dataRecord: Pigment(Colors.Red),
        radiusScale     = 1.0
    ):
        core.EdgeExtractor.__init__(
            self,
            pointListMap,
            radiusListMap,
            colorValListMap,
            radiusScale
        )

    def getResizedList(self, lst, newLen):
        if (not hasattr(lst, "__iter__")):
            newLst = [lst]
        else:
            newLst = list(lst)
        if (len(newLst) < newLen):
            newLst = newLst*((newLen/(len(newLst))) + 1)
        del newLst[newLen:]
        return newLst

    def writeSdl(self, f, record):
        ptList = self.getPointList(record)
        numPts = len(ptList)
        radiusList = \
          self.getResizedList(self.getRadiusList(record), numPts)
        colorList  = \
          self.getResizedList(self.getColorValList(record), numPts)
        for i in range(0, numPts-1):
            f.write("cone {\n<")
            f.write(string.join(map(str,ptList[i]), ","))
            f.write(">,")
            f.write(str(radiusList[i]*self.getRadiusScale()))
            f.write("\n<")
            f.write(string.join(map(str,ptList[i+1]), ","))
            f.write(">,")
            f.write(str(radiusList[i+1]*self.getRadiusScale()))
            f.write("\n")
            if (hasattr(colorList[i], "writeSdl")):
                colorList[i].writeSdl(f)
            f.write("}\n")
