/*
 * EveryBuddy
 *
 * Copyright (C) 1999, Torrey Searle <tsearle@uci.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */ 

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>  
#include <gtk/gtk.h>
#include "about.h"
#include "dialog.h"

#include "pixmaps/eblogo.xpm"

/*
  Data
*/

/*
  Main body of text in about box -- REMEMBER, the preprocessor will concatenate
  raw strings for you, automatically, so...  use lines -- they are cheap....
*/

const char * About_Caption = 
"Everybuddy is designed to become a Universal Instant Messaging "
"client designed \n"
"to seamlessly integrate all existing Instant Messaging clients "
"and provide a \n"
"single consistent user interface. \n"
"\n"
"Everybuddy is brought to you by the heart-felt contributions of "
"the following:"
;


/*
  Array of Dev_Team Data....

  Remember to set the size of this CORRECTLY immediately after in 
  Dev_Team_Size -- THIS IS VERY IMPORTANT!  ON YOUR HEAD IF YOU DON'T
*/

Dev_Member Dev_Team [] = 
{
  {"Torrey Searle", "<tsearle@uci.edu>", "Creator"},
  {"Ben Rigas", "<ben@flygroup.org>", "Web Design & GUI Devel"},
  {"Jared Peterson", "<jared@tgflinux.com>", "GUI Devel"},
  {"Troy Morrison", "<troy@akropolys.com>", "Yahoo Devel"},
  {"Shane Brady", "<shane@jxie.com>", "MSN Devel"},
  {"Alex Wheeler", "<awheeler@speakeasy.org>", "Jabber Devel & Much More :)"},
  {"Robert Lazzurs", "<lazzurs@lazzurs.co.uk>", "Maintainer"},
  {"Meredydd", "<m_luff@mail.wincoll.ac.uk>", "MSN Devel"},
  {"Erik Inge Bols", "<knan@mo.himolde.no>", "IRC Devel"}
};
const unsigned int Dev_Team_Size = 9;

/*
  Functions
*/


static GtkWidget *aboutbox = NULL;

static void destroy_about()
{
	if (aboutbox)
		gtk_widget_destroy(aboutbox);
	aboutbox = NULL;
}

void show_about(GtkWidget *w, void *null)
{
	GtkWidget *logo;
	GtkWidget *ok;
	GtkWidget *label;
	GtkWidget *table;
	GtkWidget *vbox;
	GtkStyle *style;
	GdkPixmap *pm;
	GdkBitmap *bm;
	char abouttitle[45];
	unsigned int i;


	if (aboutbox) {
		gtk_widget_show(aboutbox);
		return;
	}
	
	aboutbox = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_realize(aboutbox);

	vbox = gtk_vbox_new(FALSE, 0);

	style = gtk_widget_get_style(aboutbox);
	pm = gdk_pixmap_create_from_xpm_d(aboutbox->window, &bm,
                 &style->bg[GTK_STATE_NORMAL], (gchar **)eblogo_xpm);
	logo = gtk_pixmap_new(pm, bm);
	gtk_box_pack_start(GTK_BOX(vbox), logo, TRUE, TRUE, 0);
	gtk_widget_show(logo);		

	label = gtk_label_new(About_Caption);

	gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 5);

	table = gtk_table_new (Dev_Team_Size, 3, FALSE);
	for (i = 0; i < Dev_Team_Size; i++)
	  {
	    GtkWidget * l;
	    l = gtk_label_new (Dev_Team [i].Name);
	    gtk_table_attach ((GtkTable *)table, l, 0, 1, i, i+1,
			      GTK_EXPAND, GTK_EXPAND, 10, 0);
	    gtk_widget_show(l);

	    l = gtk_label_new (Dev_Team [i].Email);
	    gtk_table_attach ((GtkTable *)table, l, 1, 2, i, i+1,
			      GTK_EXPAND, GTK_EXPAND, 10, 0);
	    gtk_widget_show(l);

	    l = gtk_label_new (Dev_Team [i].Pos);
	    gtk_table_attach ((GtkTable *)table, l, 2, 3, i, i+1,
			      GTK_EXPAND, GTK_EXPAND, 10, 0);
	    gtk_widget_show(l);
	  }
	gtk_box_pack_start(GTK_BOX(vbox), table, TRUE, TRUE, 5);

	ok = gtk_button_new_with_label("Close");
	gtk_signal_connect_object(GTK_OBJECT(ok), "clicked",
		                  GTK_SIGNAL_FUNC(destroy_about), GTK_OBJECT(aboutbox));

	gtk_box_pack_start(GTK_BOX(vbox), ok, TRUE, FALSE, 0);
	GTK_WIDGET_SET_FLAGS(ok, GTK_CAN_DEFAULT);
	gtk_widget_grab_default(ok);
	gtk_widget_show(ok);

	
	gtk_signal_connect_object(GTK_OBJECT(aboutbox), "destroy",
                                  GTK_SIGNAL_FUNC(destroy_about), GTK_OBJECT(aboutbox));

	gtk_widget_show(label);
	gtk_widget_show(table);
	gtk_widget_show(vbox);

	g_snprintf(abouttitle, sizeof(abouttitle), "About EveryBuddy v%s", VERSION);
	gtk_window_set_title(GTK_WINDOW(aboutbox), abouttitle);
	eb_icon(aboutbox->window);
	gtk_container_border_width(GTK_CONTAINER(aboutbox), 2);
	gtk_container_add(GTK_CONTAINER(aboutbox), vbox);
	gtk_widget_show(aboutbox);
}

