/*
 * Licq contact list extractor
 * Supports both newer and older licq contact list formats
 *
 * Copyright (C) 2000, John Starks <jstarks@penguinpowered.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#include <gtk/gtk.h>
#include <string.h>
#include <stdlib.h>
#include "account.h"
#include "contact.h"
#include "util.h"
#include "globals.h"

/* Removes the spaces surrounding a token */
char* remove_spaces(char* token)
{
  g_strchomp(token); /* Remove spaces at the end */
  while (*token == ' ') token++;  /* Remove spaces at the beginning */
  return token;
}

/* Gets your nickname for an licq buddy */
char* get_licq_nick(const char* uin, int licq_version)
{
    gchar buff[1024]; 
    static gchar c[1024];
    FILE *fp;
    char *token, *nick;

    g_snprintf(buff, 1024, "%s/.licq/%s/%s.uin", getenv("HOME"), 
               licq_version < 7 ? "conf" : "users", uin);
    if (!(fp = fopen(buff, "r")))
        return NULL;

    while (!feof(fp))
    {
        fgets(c, 1024, fp);
        token = remove_spaces(strtok(c, "="));
        if (g_strcasecmp(token, "Alias"))
            continue;

        nick = remove_spaces(strtok(NULL, "="));
        fclose(fp);
        return nick;
    }
    fclose(fp);
    return NULL;
}


/* Imports licq accounts
 * Supports newer and older contact list formats (0.7x and 0.6x)
 */
void import_licq_accounts()
{
    gchar group_name[] = "Licq Users";
    int num_users;
    int unused_num;
    int licq_version;

    gchar c[1024];
    char *nick, *uin, *token;

    FILE *fp;
    g_snprintf(c, 1024, "%s/.licq/users.conf", getenv("HOME"));
    if ((fp = fopen(c, "r")))
        licq_version = 7;
    else
    {
        g_snprintf(c, 1024, "%s/.licq/conf/users.conf", getenv("HOME"));
        if (!(fp = fopen(c, "r")))
            return;
        licq_version = 6;
    }

    while(!feof(fp))
    {
        fgets(c, 1024, fp);
        token = remove_spaces(c);
        if(!g_strcasecmp(token, "[users]"))
            break;
    }
    if(feof(fp))
    {
        fclose(fp);
        return;
    }

    while (!feof(fp))
    {
        fgets(c, 1024, fp);
        token = remove_spaces(strtok(c, "="));
        if (!g_strncasecmp(token, "NumOfUsers", strlen("NumOfUsers") + 1))
            break;
    }
    if (feof(fp)) 
    {
        fclose(fp);
        return;
    }

    token = strtok(NULL, "=");
    num_users = atoi(token);
    if (num_users < 1)
    {
        fclose(fp);
        return;
    }
    
    if(!find_grouplist_by_name(group_name))
        add_group(group_name);

    while(!feof(fp))
    {
        fgets(c, 1024, fp);
        if(feof(fp))
            break;
        token = strtok(c, "=");
        if (sscanf(token, "User%d", &unused_num) <= 0) 
            continue;

        uin = remove_spaces(strtok(NULL, "="));
        nick = get_licq_nick(uin, licq_version);
        if (!nick)
            nick = uin;

        if(find_account_by_handle(uin, ICQ_SERVICE_ID))
        {
            continue;
        }
        if(!find_contact_by_nick(nick))
        {
            add_new_contact(group_name, nick, ICQ_SERVICE_ID );
        }
        if(!find_account_by_handle(uin, ICQ_SERVICE_ID))
        {
            eb_account * ea = eb_services[ICQ_SERVICE_ID].sc->new_account(uin);
            add_account( nick, ea );
//            RUN_SERVICE(ea)->add_user(ea);
        }
    }
    fclose(fp);


}
