/*
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: mdregmgr
 * File: md_allocation.c
 *
 * Description: This file contains all functions pertaining to allocating and
 *              deallocating memory within the MD region manager plugin. This
 *              is the only file that should contain any calls to malloc() or
 *              free().
 */ 

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <plugin.h>
#define MY_PLUGIN my_plugin
#include "md.h"


/* Function: md_allocate_memory
 *
 *	Simple wrapper around malloc() that zeros out the memory block.
 */
int md_allocate_memory( void ** pointer, size_t bytes )
{
	LOG_ENTRY;

	if ( ! pointer ) {
		RETURN(EFAULT);
	}
	if ( ! bytes ) {
		*pointer = NULL;
		RETURN(0);
	}
	*pointer = malloc(bytes);
	if ( ! *pointer ) {
		LOG_CRITICAL("Memory allocation error.\n");
		RETURN(ENOMEM);
	}
	memset(*pointer,0,bytes);

	RETURN(0);
}


/* Function: md_deallocate_memory
 *
 *	Simple wrapper around free()
 */
void md_deallocate_memory( void * pointer )
{
	LOG_ENTRY;

	if (pointer) {
		free(pointer);
	}
	else {
		LOG_WARNING("Attempting to deallocate a NULL pointer.\n");
	}

	LOG_EXIT(0);
}


