/*
 *
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: views.h
 */ 
 
/*
 * Enumeration type that describes which view we are dealing with
 */
 
typedef enum {
    VOLUME_VIEW = 0,
    OBJECT_VIEW,
    FEATURE_VIEW,
    REGION_VIEW,
    CONTAINER_VIEW,
    SEGMENT_VIEW,
    DISK_VIEW,
    PLUGIN_VIEW,
    FILTER_VIEW,
    MAX_VIEWS
} view_type_t;

static const guint LEFT_MOUSE_BUTTON  = 1;
static const guint RIGHT_MOUSE_BUTTON = 3;

static const guint CURRENT_VIEW = 1;
static const guint ALL_VIEWS    = 2;

/*
 * Value stored in hash table with object handle
 * as key. It indicates whether we need to expand
 * or collapse a node.
 */

static const guint NODE_IS_COLLAPSED = 1;
static const guint NODE_IS_EXPANDED  = 2;

#define NO_PARENT                    0
#define NO_SIBLING                   0

#define COLUMN_SPACING               6
#define MAX_COLUMNS                  9
#define NAME_COLUMN                  0

#define VV_NAME_COLUMN               0
#define VV_SIZE_COLUMN               1
#define VV_PLUGIN_COLUMN             2
#define VV_MINOR_COLUMN              3
#define VV_MOUNTPOINT_COLUMN         4
#define VV_DIRTY_COLUMN              5
#define VV_NEW_COLUMN                6
#define VV_NEEDS_DEVNODE_COLUMN      7
#define VV_READ_ONLY_COLUMN          8

#define OV_NAME_COLUMN               0
#define OV_SIZE_COLUMN               1
#define OV_DIRTY_COLUMN              2
#define OV_CORRUPT_COLUMN            3
#define OV_READ_ONLY_COLUMN          4
#define OV_BIOS_READABLE_COLUMN      5
#define OV_PLUGIN_COLUMN             6

#define RV_NAME_COLUMN               0
#define RV_SIZE_COLUMN               1
#define RV_ALLOCATED_COLUMN          2
#define RV_DIRTY_COLUMN              3
#define RV_CORRUPT_COLUMN            4
#define RV_READ_ONLY_COLUMN          5
#define RV_BIOS_READABLE_COLUMN      6

#define CV_NAME_COLUMN               0
#define CV_SIZE_COLUMN               1
#define CV_DIRTY_COLUMN              2
#define CV_CORRUPT_COLUMN            3
#define CV_READ_ONLY_COLUMN          4

#define SV_NAME_COLUMN               0
#define SV_SIZE_COLUMN               1
#define SV_LBA_COLUMN                2
#define SV_TYPE_COLUMN               3
#define SV_DIRTY_COLUMN              4
#define SV_CORRUPT_COLUMN            5
#define SV_READ_ONLY_COLUMN          6
#define SV_BIOS_READABLE_COLUMN      7

#define DV_NAME_COLUMN               0
#define DV_SIZE_COLUMN               1
#define DV_GEOMETRY_COLUMN           2
#define DV_DIRTY_COLUMN              3
#define DV_CORRUPT_COLUMN            4
#define DV_ERRORS_COLUMN             5
#define DV_READ_ONLY_COLUMN          6

#define FV_NAME_COLUMN               0
#define FV_SIZE_COLUMN               1
#define FV_PLUGIN_COLUMN             2

#define PV_ICON_COLUMN               0
#define PV_ID_COLUMN                 1
#define PV_VERSION_COLUMN            2
#define PV_NAME_COLUMN               3
#define PV_OEM_COLUMN                4
#define PV_DESCRIPTION_COLUMN        5

#define REPAINT_THRESHOLD            50

void set_browser_notebook_tab_pixmap (GtkWidget *widget, gchar *key, object_type_t type, gboolean topmost);

inline void set_ctree_column_checkbox (GtkCTree *ctree, GtkCTreeNode *node, 
                                       gint column, gboolean critical, 
                                       gboolean checked);
                                              
inline void change_ctree_properties (GtkCTree *ctree);

inline void initialize_view (GtkCTree *ctree, view_type_t view);

gchar * get_object_plugin_name (storage_object_info_t *object);

gchar **init_column_text_array (view_type_t view);

GtkCTreeNode* insert_volume_into_ctree (GtkCTree *ctree, GtkCTreeNode *parent, 
                                        logical_volume_info_t *volume, 
                                        GdkPixmap *pixmap, GdkBitmap *mask, 
                                        gchar **text, view_type_t view);
                                        
GtkCTreeNode* insert_storage_object_into_ctree (GtkCTree *ctree, GtkCTreeNode *parent, 
                                                storage_object_info_t *object, 
                                                GdkPixmap *pixmap, GdkBitmap *mask, 
                                                gchar **text, view_type_t view,
                                                object_type_t type);
                                                
GtkCTreeNode* insert_container_into_ctree (GtkCTree *ctree, GtkCTreeNode *parent, 
                                           storage_container_info_t *container, 
                                           GdkPixmap *pixmap, GdkBitmap *mask, 
                                           gchar **text, view_type_t view);
                                           
GtkCTreeNode* insert_plugin_into_ctree (GtkCTree *ctree, GtkCTreeNode *parent,
                                        plugin_info_t *plugin, 
                                        GdkPixmap *pixmap, GdkBitmap *mask, 
                                        gchar **text, view_type_t view);
                                                                                
GtkCTreeNode* insert_object_into_ctree (GtkCTree *ctree, GtkCTreeNode *parent, 
                                        object_handle_t handle, view_type_t view);

void update_volume_in_ctree (GtkCTree *ctree, GtkCTreeNode *node, 
                             logical_volume_info_t *volume,
                             GdkPixmap *pixmap, GdkBitmap *mask,
                             view_type_t view);

void update_storage_object_in_ctree (GtkCTree *ctree, GtkCTreeNode *node, 
                                     storage_object_info_t *object, 
                                     GdkPixmap *pixmap, GdkBitmap *mask, 
                                     view_type_t view, object_type_t type);

void update_container_in_ctree (GtkCTree *ctree, GtkCTreeNode *node, 
                                storage_container_info_t *container,
                                GdkPixmap *pixmap, GdkBitmap *mask,
                                view_type_t view);
                                           
void update_plugin_in_ctree (GtkCTree *ctree, GtkCTreeNode *node,
                             plugin_info_t *plugin,
                             GdkPixmap *pixmap, GdkBitmap *mask,
                             view_type_t view);
                                        
void update_object_in_ctree (GtkCTree *ctree, GtkCTreeNode *node, 
                             object_handle_t handle, view_type_t view);
                             
void update_object_ctree_node (GtkCTree *ctree, GtkCTreeNode *node, gpointer user_data);
                                        
GtkCTreeNode* populate_object_tree (GtkCTree *ctree, GtkCTreeNode *parent, 
                                    object_handle_t handle, view_type_t view);
                                    
void populate_ctree_with_plugins (GtkCTree *ctree, evms_plugin_code_t type,
                                  plugin_search_flags_t flags, GHashTable *refresh_table,
                                  view_type_t view);
                                    
void populate_plugin_view_with_plugins (GtkCList *clist);
                                    
void populate_volume_view_with_volumes (GtkCTree *ctree, GHashTable *refresh_table);

void populate_object_view_with_objects (GtkCTree *ctree, GHashTable *refresh_table);

void populate_feature_object_view_with_objects (GtkCTree *ctree, GHashTable *refresh_table);

void populate_region_view_with_regions (GtkCTree *ctree, GHashTable *refresh_table);

void populate_container_with_objects_produced (GtkCTree *ctree, GtkCTreeNode *parent, 
                                               handle_array_t *objects, GHashTable *table);

void populate_container_with_objects_consumed (GtkCTree *ctree, GtkCTreeNode *parent, 
                                               handle_array_t *objects, GHashTable *table);

void populate_ctree_with_containers (GtkCTree *ctree, GHashTable *refresh_table, 
                                     view_type_t view);

void populate_segment_view_with_segments (GtkCTree *ctree, GHashTable *refresh_table);

void populate_disk_view_with_disks (GtkCTree *ctree, GHashTable *refresh_table);

void display_action_popup_menu_for_handle (object_handle_t handle, GdkEventButton *event);

void populate_volume_view_ctree (GtkCTree *ctree, GHashTable *refresh_table);

void populate_object_view_ctree (GtkCTree *ctree, GHashTable *refresh_table);

void populate_feature_object_view_ctree (GtkCTree *ctree, GHashTable *refresh_table);

void populate_region_view_ctree (GtkCTree *ctree, GHashTable *refresh_table);

void populate_container_view_ctree (GtkCTree *ctree, GHashTable *refresh_table);

void populate_segment_view_ctree (GtkCTree *ctree, GHashTable *refresh_table);

void populate_disk_view_ctree (GtkCTree *ctree, GHashTable *refresh_table);

void refresh_view (view_type_t view);

void refresh_main_window_views (void);

gint set_current_view_by_object_type (object_type_t type);

void refresh_current_view (void);

void set_refresh_views_pixmap (GtkWidget *window);

void display_refresh_view_popup_menu (GdkEventButton *event);
