/*
 *
 *   (C) Copyright IBM Corp. 2004
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: ntfsfsim.h
 */

extern plugin_record_t *    my_plugin_record;
extern engine_functions_t * EngFncs;
extern boolean              have_mkntfs;
extern boolean              have_ntfsfix;
extern boolean              have_ntfsinfo;
extern boolean              have_ntfsclone;
extern boolean              have_ntfsresize;

#define FS_TYPE_NTFS 13

typedef struct private_data_s {
	sector_count_t     fs_size;
	sector_count_t     max_fs_size;
	u_int64_t          ntfs_cluster_size;
	int64_t            ntfs_nr_clusters;
	char             * ntfs_vol_name;
	char             * ntfs_version;
	logical_volume_t * clone_source;
	logical_volume_t * clone_target;
	u_int32_t          flags;
} private_data_t;

#define PDFLAG_RUN_NTFSFIX	(1<<0)
#define PDFLAG_FORCE_NTFSFIX	(1<<1)
#define PDFLAG_NTFSCLONE_SOURCE	(1<<2)
#define PDFLAG_NTFSCLONE_TARGET	(1<<3)
#define PDFLAG_FORCE_NTFSCLONE	(1<<4)

/* mkntfs option array indices */
#define MKFS_LABEL_INDEX         0
#define MKFS_LABEL_NAME          "label"
#define MKFS_CLUSTER_SIZE_INDEX  1
#define MKFS_CLUSTER_SIZE_NAME   "cluster-size"
#define MKFS_MFT_ZONE_MULT_INDEX 2
#define MKFS_MFT_ZONE_MULT_NAME  "mft-zone-mult"
#define MKFS_COMPRESS_INDEX	 3
#define MKFS_COMPRESS_NAME       "compress"
#define MKFS_QUICK_INDEX         4
#define MKFS_QUICK_NAME          "quick"
#define MKFS_OPTIONS_COUNT       5

/* label, cluster size, and MFT zone mult have an extra string for their args */
#define MKFS_OPTIONS_STRING_COUNT MKFS_OPTIONS_COUNT + 3

#define MAX_LABEL_LEN            128


#define EVMS_Task_ntfsfix        EVMS_Task_Plugin_Function + 1
#define NTFSFIX_FORCE_INDEX	 0
#define NTFSFIX_FORCE_NAME	 "force"
#define NTFSFIX_OPTIONS_COUNT    1


#define EVMS_Task_ntfsclone      EVMS_Task_Plugin_Function + 2
#define NTFSCLONE_TARGET_INDEX	 0
#define NTFSCLONE_TARGET_NAME	 "target"
#define NTFSCLONE_FORCE_INDEX	 1
#define NTFSCLONE_FORCE_NAME	 "force"
#define NTFSCLONE_OPTIONS_COUNT	 2
